/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.java.truecommons.cio.Entry;
import net.java.truevfs.comp.zip.DateTimeConverter;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.kernel.spec.FsArchiveEntries;
import net.java.truevfs.kernel.spec.FsArchiveEntry;

public abstract class AbstractZipDriverEntry
extends ZipEntry
implements FsArchiveEntry {
    protected AbstractZipDriverEntry(String name) {
        super(name);
        assert (this.invariants());
    }

    protected AbstractZipDriverEntry(String name, ZipEntry template) {
        super(name, template);
        assert (this.invariants());
    }

    private boolean invariants() {
        return true;
    }

    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    protected abstract DateTimeConverter getDateTimeConverter();

    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: {
                return this.getSize();
            }
            case STORAGE: {
                return this.getCompressedSize();
            }
        }
        return -1L;
    }

    public boolean setSize(Entry.Size type, long size) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size);
        return true;
    }

    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getTime();
        return 0L <= time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setTime(time);
        return true;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return null;
    }

    public boolean setPermitted(Entry.Access type, Entry.Entity entity, Boolean value) {
        return false;
    }

    public String toString() {
        return FsArchiveEntries.toString((FsArchiveEntry)this);
    }
}

