/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.key.spec.KeyManagerMap;
import net.java.truecommons.key.spec.sl.KeyManagerMapLocator;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFileParameters;
import net.java.truevfs.comp.zip.ZipOutputStreamParameters;
import net.java.truevfs.comp.zipdriver.AbstractZipDriverEntry;
import net.java.truevfs.comp.zipdriver.KeyManagerZipCryptoParameters;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.comp.zipdriver.ZipKeyController;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.sl.IoBufferPoolLocator;
import org.slf4j.Logger;

@Immutable
public abstract class AbstractZipDriver<E extends AbstractZipDriverEntry>
extends FsArchiveDriver<E>
implements ZipOutputStreamParameters,
ZipFileParameters<E> {
    private static final Logger logger = new LocalizedLogger(AbstractZipDriver.class);

    public IoBufferPool getPool() {
        return IoBufferPoolLocator.SINGLETON.get();
    }

    public KeyManagerMap getKeyManagerMap() {
        return KeyManagerMapLocator.SINGLETON;
    }

    @CheckForNull
    public final ZipCryptoParameters zipCryptoParameters(ZipInputService<E> input) {
        return this.zipCryptoParameters(input.getModel(), input.getRawCharset());
    }

    @CheckForNull
    public final ZipCryptoParameters zipCryptoParameters(ZipOutputService<E> output) {
        return this.zipCryptoParameters(output.getModel(), output.getRawCharset());
    }

    @CheckForNull
    protected ZipCryptoParameters zipCryptoParameters(FsModel model, Charset charset) {
        return new KeyManagerZipCryptoParameters(this, model, charset);
    }

    public URI mountPointUri(FsModel model) {
        return model.getMountPoint().toHierarchicalUri();
    }

    public URI fileSystemUri(FsModel model, String name) {
        return this.mountPointUri(model);
    }

    public boolean getRedundantContentSupport() {
        return true;
    }

    public boolean getRedundantMetaDataSupport() {
        return true;
    }

    public boolean check(E local, @WillNotClose ZipInputService<E> input) {
        return local.isEncrypted();
    }

    public final boolean rdc(@WillNotClose ZipInputService<E> input, E local, AbstractZipDriverEntry peer) {
        return this.rdc((AbstractZipDriverEntry)((Object)local), peer);
    }

    public final boolean rdc(@WillNotClose ZipOutputService<E> output, E local, AbstractZipDriverEntry peer) {
        return this.rdc(peer, (AbstractZipDriverEntry)((Object)local));
    }

    protected boolean rdc(AbstractZipDriverEntry input, AbstractZipDriverEntry output) {
        return !input.isEncrypted() && !output.isEncrypted();
    }

    public boolean getPreambled() {
        return false;
    }

    public boolean getPostambled() {
        return false;
    }

    public int getOverheadSize() {
        return 47;
    }

    public int getMethod() {
        return 8;
    }

    public int getLevel() {
        return 9;
    }

    public FsController decorate(FsController controller) {
        return new ZipKeyController(controller, this);
    }

    protected final ZipInputService<E> newInput(FsModel model, FsInputSocketSource source) throws IOException {
        ZipInputService<E> zis = this.newZipInput(Objects.requireNonNull(model), source);
        try {
            zis.recoverLostEntries();
        }
        catch (IOException ex) {
            logger.warn("junkInTheTrunk.warn", (Object)this.mountPointUri(model), (Object)zis.getPostambleLength());
            logger.trace("junkInTheTrunk.trace", (Throwable)ex);
        }
        return zis;
    }

    @CreatesObligation
    protected ZipInputService<E> newZipInput(FsModel model, FsInputSocketSource source) throws IOException {
        assert (null != model);
        return new ZipInputService(model, source, this);
    }

    @CreatesObligation
    protected OutputService<E> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<E> input) throws IOException {
        ZipInputService zis = (ZipInputService)input;
        return new MultiplexingOutputService(this.getPool(), new ZipOutputService(model, sink, zis, this));
    }

    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller, FsNodeName name) {
        if ((options = options.set((Enum)FsAccessOption.STORE)).get((Enum)FsAccessOption.GROW)) {
            options = options.set((Enum)FsAccessOption.APPEND).clear((Enum)FsAccessOption.CACHE);
        }
        return new FsOutputSocketSink(options, controller.output(options, name, null));
    }

    public E newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        Object entry;
        name = AbstractZipDriver.normalize((String)name, (Entry.Type)type);
        if (template instanceof ZipEntry) {
            entry = this.newEntry(name, (ZipEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        if (Entry.Type.DIRECTORY != type) {
            if (-1 == entry.getMethod()) {
                int method = options.get((Enum)FsAccessOption.COMPRESS) ? 8 : (options.get((Enum)FsAccessOption.STORE) ? 0 : this.getMethod());
                entry.setMethod(method);
                if (0 != method) {
                    entry.setCompressedSize(-1L);
                }
            }
            if (options.get((Enum)FsAccessOption.ENCRYPT)) {
                entry.setEncrypted(true);
            }
        }
        return (E)entry;
    }

    public abstract E newEntry(String var1);

    public abstract E newEntry(String var1, ZipEntry var2);
}

