/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec.cmd;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.trueupdate.manager.spec.cmd.Command;

public abstract class LogContext {
    public void logStarting(Method method) {
        this.logger().log(this.startingLevel(method), this.startingMessage(method), method.ordinal());
    }

    public void logSucceeded(Method method, long durationMillis) {
        this.logger().log(this.succeededLevel(method), this.succeededMessage(method), this.params(method, true, durationMillis));
    }

    public void logFailed(Method method, long durationMillis) {
        this.logger().log(this.failedLevel(method), this.failedMessage(method), this.params(method, false, durationMillis));
    }

    protected abstract Logger logger();

    protected Level startingLevel(Method method) {
        return method.startingLevel();
    }

    protected abstract String startingMessage(Method var1);

    protected Level succeededLevel(Method method) {
        return method.succeededLevel();
    }

    protected abstract String succeededMessage(Method var1);

    protected Level failedLevel(Method method) {
        return method.failedLevel();
    }

    protected abstract String failedMessage(Method var1);

    protected Object[] params(Method method, boolean succeeded, long durationMillis) {
        int millis = (int)(durationMillis % 1000L);
        int seconds = (int)(durationMillis / 1000L % 60L);
        int minutes = (int)(durationMillis / 1000L / 60L % 60L);
        int hours = (int)(durationMillis / 1000L / 60L / 60L);
        return new Object[]{method.ordinal(), succeeded ? 0 : 1, hours, minutes, seconds, millis};
    }

    public static enum Method {
        perform{

            @Override
            void invoke(Command command) throws Exception {
                command.perform();
            }
        }
        ,
        revert{

            @Override
            void invoke(Command command) throws Exception {
                command.revert();
            }
        };


        abstract void invoke(Command var1) throws Exception;

        public Level startingLevel() {
            return Level.INFO;
        }

        public Level succeededLevel() {
            return Level.INFO;
        }

        public Level failedLevel() {
            return Level.WARNING;
        }
    }
}

