/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec.cmd;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.trueupdate.manager.spec.cmd.Command;
import net.java.trueupdate.manager.spec.cmd.LogContext;

public final class Commands {
    private static final ThreadLocal<Boolean> busy = new InheritableThreadLocal<Boolean>();

    public static void execute(Command cmd) throws Exception {
        if (Boolean.TRUE.equals(busy.get())) {
            throw new UnsupportedOperationException("Nested commands are not supported because they can't get reverted when the enclosing command gets reverted - refactor to CompositeCommand instead.");
        }
        busy.set(Boolean.TRUE);
        try {
            try {
                cmd.perform();
            }
            catch (Throwable t1) {
                try {
                    cmd.revert();
                }
                catch (Throwable t2) {
                    Commands.logger().log(Level.SEVERE, "Exception while reverting command - the integrity of the system is probably corrupted.", t2);
                }
                Commands.rethrow(t1);
            }
        }
        finally {
            busy.remove();
        }
    }

    private static Logger logger() {
        return Logger.getLogger(Commands.class.getName());
    }

    private static void rethrow(Throwable t1) throws Exception {
        try {
            throw t1;
        }
        catch (Error t2) {
            throw t2;
        }
        catch (Exception t2) {
            throw t2;
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }

    public static Command time(final Command cmd, final LogContext ctx) {
        return new Command(){

            @Override
            public void perform() throws Exception {
                this.time(LogContext.Method.perform);
            }

            @Override
            public void revert() throws Exception {
                this.time(LogContext.Method.revert);
            }

            void time(LogContext.Method method) throws Exception {
                ctx.logStarting(method);
                Throwable t1 = null;
                long started = System.currentTimeMillis();
                try {
                    method.invoke(cmd);
                }
                catch (Throwable t2) {
                    t1 = t2;
                }
                long finished = System.currentTimeMillis();
                long durationMillis = finished - started;
                if (null == t1) {
                    ctx.logSucceeded(method, durationMillis);
                } else {
                    ctx.logFailed(method, durationMillis);
                    Commands.rethrow(t1);
                }
            }
        };
    }

    public static Command atomic(final Command cmd) {
        return new Command(){
            boolean performed;

            @Override
            public void perform() throws Exception {
                if (this.performed) {
                    throw new IllegalStateException("Not idempotent.");
                }
                cmd.perform();
                this.performed = true;
            }

            @Override
            public void revert() throws Exception {
                if (this.performed) {
                    cmd.revert();
                    this.performed = false;
                }
            }
        };
    }

    private Commands() {
    }
}

