/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar.trex;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.WhiteSpaceProcessor;
import com.sun.msv.grammar.trex.Localizer;
import java.io.Serializable;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.StreamingValidatorImpl;

public class TypedString
implements DatabindableDatatype,
Serializable {
    public final String value;
    public final boolean preserveWhiteSpace;
    public static final String DIAG_TYPED_STRING = "TypedString.Diagnosis";

    public TypedString(String value, boolean preserveWhiteSpace) {
        this.value = preserveWhiteSpace ? value : WhiteSpaceProcessor.theCollapse.process(value);
        this.preserveWhiteSpace = preserveWhiteSpace;
    }

    public boolean isContextDependent() {
        return false;
    }

    public int getIdType() {
        return 0;
    }

    public Object createValue(String literal, ValidationContext context) {
        if (!this.preserveWhiteSpace) {
            literal = WhiteSpaceProcessor.theCollapse.process(literal);
        }
        if (this.value.equals(literal)) {
            return literal;
        }
        return null;
    }

    public Object createJavaObject(String literal, ValidationContext context) {
        return this.createValue(literal, context);
    }

    public Class getJavaObjectType() {
        return String.class;
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException();
    }

    public String serializeJavaObject(Object obj, SerializationContext context) {
        if (this.value instanceof String) {
            if (this.value.equals(obj)) {
                return this.value;
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(String literal, ValidationContext context) {
        return this.createValue(literal, context) != null;
    }

    public void checkValid(String content, ValidationContext context) throws DatatypeException {
        if (this.createValue(content, context) != null) {
            return;
        }
        throw new DatatypeException(-1, Localizer.localize((String)DIAG_TYPED_STRING, (Object)this.value));
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext context) {
        return new StreamingValidatorImpl((Datatype)this, context);
    }

    public final boolean sameValue(Object o1, Object o2) {
        return o1.equals(o2);
    }

    public final int valueHashCode(Object o) {
        return o.hashCode();
    }

    public String getName() {
        return null;
    }

    public String displayName() {
        return "TREX built-in string";
    }
}

