/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.writer.relaxng;

import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.writer.relaxng.RELAXNGWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.SAXException;

public class Driver {
    private static final String MSG_USAGE = "Driver.Usage";
    private static final String MSG_GRAMMAR_ERROR = "Driver.GrammarError";

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println(Driver.localize(MSG_USAGE));
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        String input = args[0];
        String output = args[1];
        PrintStream out = new PrintStream(new FileOutputStream(output));
        Grammar g = GrammarLoader.loadSchema(input, (GrammarReaderController)new DebugController(true, false, System.err), factory);
        if (g == null) {
            System.err.println(Driver.localize(MSG_GRAMMAR_ERROR));
            return;
        }
        Driver.writeGrammar(g, out);
        out.close();
    }

    public static void writeGrammar(Grammar g, OutputStream out) throws SAXException {
        RELAXNGWriter writer = new RELAXNGWriter();
        writer.setDocumentHandler(new XMLSerializer(out, new OutputFormat("xml", null, true)));
        writer.write(g);
    }

    public static String localize(String propertyName, Object[] args) {
        String format = ResourceBundle.getBundle("com.sun.msv.writer.relaxng.Messages").getString(propertyName);
        return MessageFormat.format(format, args);
    }

    public static String localize(String prop) {
        return Driver.localize(prop, null);
    }

    public static String localize(String prop, Object arg1) {
        return Driver.localize(prop, new Object[]{arg1});
    }

    public static String localize(String prop, Object arg1, Object arg2) {
        return Driver.localize(prop, new Object[]{arg1, arg2});
    }
}

