/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMDecorator {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public static void decorate(Document doc) {
        String defaultNs;
        final HashSet usedURIs = new HashSet();
        final HashSet usedPrefixes = new HashSet();
        Element root = doc.getDocumentElement();
        DOMDecorator.visit(root, new DOMVisitor(){

            public void onElement(Element e) {
                usedURIs.add(DOMDecorator.nullAdjust(e.getNamespaceURI()));
            }

            public void onAttr(Attr a) {
                String qname;
                int idx;
                String uri = DOMDecorator.nullAdjust(a.getNamespaceURI());
                if (!"".equals(uri) && !uri.equals(DOMDecorator.XMLNS_URI)) {
                    usedURIs.add(DOMDecorator.nullAdjust(a.getNamespaceURI()));
                }
                if (DOMDecorator.nullAdjust(a.getNamespaceURI()).equals(DOMDecorator.XMLNS_URI) && (idx = (qname = a.getName()).indexOf(58)) < 0) {
                    usedPrefixes.add(qname.substring(idx + 1));
                }
                StringBuffer buf = new StringBuffer();
                NodeList lst = a.getChildNodes();
                for (int j = 0; j < lst.getLength(); ++j) {
                    buf.append(lst.item(j).getNodeValue());
                }
                a.setValue(buf.toString());
            }
        });
        String string = defaultNs = !usedURIs.contains("") ? DOMDecorator.nullAdjust(root.getNamespaceURI()) : "";
        if (!defaultNs.equals("")) {
            root.setAttributeNS(XMLNS_URI, "xmlns", defaultNs);
        }
        final HashMap<String, String> uri2prefix = new HashMap<String, String>();
        int cnt = 1;
        String[] uris = usedURIs.toArray(new String[0]);
        for (int i = 0; i < uris.length; ++i) {
            String prefix;
            if (uris[i].equals(defaultNs)) continue;
            while (uri2prefix.containsValue(prefix = "ns" + cnt++)) {
            }
            uri2prefix.put(uris[i], prefix);
            root.setAttributeNS(XMLNS_URI, "xmlns:" + prefix, uris[i]);
        }
        DOMDecorator.visit(root, new DOMVisitor(){

            public void onElement(Element e) {
                String uri = DOMDecorator.nullAdjust(e.getNamespaceURI());
                if (!uri.equals(defaultNs)) {
                    e.setPrefix((String)uri2prefix.get(uri));
                }
            }

            public void onAttr(Attr a) {
                String uri = DOMDecorator.nullAdjust(a.getNamespaceURI());
                if ("".equals(uri)) {
                    return;
                }
                if (uri.equals(DOMDecorator.XMLNS_URI)) {
                    return;
                }
                String prefix = (String)uri2prefix.get(uri);
                a.setPrefix(prefix);
            }
        });
    }

    public static void visit(Element e, DOMVisitor visitor) {
        visitor.onElement(e);
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            visitor.onAttr((Attr)map.item(i));
        }
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            DOMDecorator.visit((Element)n, visitor);
        }
    }

    private static String nullAdjust(String s) {
        return s == null ? "" : s;
    }

    static interface DOMVisitor {
        public void onElement(Element var1);

        public void onAttr(Attr var1);
    }
}

