/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.util.StringPair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

class NameGenerator {
    private final Random random;

    NameGenerator(Random random) {
        this.random = random;
    }

    public StringPair generate(NameClass nc) {
        StringPair answer;
        if (nc instanceof SimpleNameClass) {
            return new StringPair(((SimpleNameClass)nc).namespaceURI, ((SimpleNameClass)nc).localName);
        }
        String MAGIC = ".";
        final HashSet possibleNames = new HashSet();
        nc.visit(new NameClassVisitor(){

            public Object onNsName(NamespaceNameClass nc) {
                possibleNames.add(new StringPair(nc.namespaceURI, "."));
                return null;
            }

            public Object onSimple(SimpleNameClass nc) {
                possibleNames.add(new StringPair(nc.namespaceURI, nc.localName));
                return null;
            }

            public Object onAnyName(AnyNameClass nc) {
                possibleNames.add(new StringPair(".", "."));
                return null;
            }

            public Object onChoice(ChoiceNameClass nc) {
                nc.nc1.visit((NameClassVisitor)this);
                nc.nc2.visit((NameClassVisitor)this);
                return null;
            }

            public Object onNot(NotNameClass nc) {
                possibleNames.add(new StringPair(".", "."));
                nc.child.visit((NameClassVisitor)this);
                return null;
            }

            public Object onDifference(DifferenceNameClass nc) {
                nc.nc1.visit((NameClassVisitor)this);
                nc.nc2.visit((NameClassVisitor)this);
                return null;
            }
        });
        Iterator itr = possibleNames.iterator();
        while (itr.hasNext()) {
            StringPair p = (StringPair)itr.next();
            if (nc.accepts(p.namespaceURI, p.localName)) continue;
            itr.remove();
        }
        if (possibleNames.size() == 0) {
            throw new Error("name class that accepts nothing");
        }
        StringPair model = (StringPair)possibleNames.toArray()[this.random.nextInt(possibleNames.size())];
        do {
            answer = new StringPair(model.namespaceURI == "." ? this.getRandomURI() : model.namespaceURI, model.localName == "." ? this.getRandomName() : model.localName);
        } while (!nc.accepts(answer.namespaceURI, answer.localName));
        return answer;
    }

    private String getRandomName() {
        int len = this.random.nextInt(8) + 2;
        StringBuffer tagName = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            tagName.append((char)(65 + this.random.nextInt(26)));
        }
        return tagName.toString();
    }

    private String getRandomURI() {
        return this.getRandomName();
    }
}

