/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;

public class Annotator {
    private final List locInfoList = new ArrayList();
    private int[] lineStartPositions;
    private final String xml;
    private final Map wrapperLocMap = new HashMap();
    private final Map nodeLocMap = new HashMap();
    private int seq;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_TAG = 1;
    private static final int STATE_ENDTAG = 2;
    private static final int STATE_QUOT = 3;
    private static final int STATE_APOS = 4;
    private static final int STATE_COMMENT = 5;
    private static final int STATE_CDATA = 6;
    private static final int TYPE_ELEMENT = 1;
    private static final int TYPE_PROCESSING_INSTRUCTION = 7;
    private static final int TYPE_COMMENT = 8;
    private static final int TYPE_CDATA_SECTION = 4;
    private static final int TYPE_TEXT = 3;

    Annotator(String xml, DOMWrapper def) {
        this.xml = xml;
        this.parse(xml);
        if (def != null) {
            this.seq = 0;
            this.populateMap(def);
            assert (this.nodeLocMap.size() == this.wrapperLocMap.size());
        }
    }

    public Location getLocation(DOMWrapper wrapper) {
        LocInfo location0 = (LocInfo)this.wrapperLocMap.get(wrapper);
        if (location0 == null && (location0 = (LocInfo)this.nodeLocMap.get(((W3CDOMWrapper)wrapper).node)) == null) {
            return null;
        }
        final LocInfo location = location0;
        return new Location(){

            public int getStartLine() {
                return Annotator.this.getLine(this.getStartPos()) + 1;
            }

            public int getStartColumn() {
                return Annotator.this.getCol(this.getStartPos()) + 1;
            }

            public int getStartPos() {
                return location.startTagStartPos;
            }

            public int getEndLine() {
                return Annotator.this.getLine(this.getEndPos()) + 1;
            }

            public int getEndColumn() {
                return Annotator.this.getCol(this.getEndPos()) + 1;
            }

            public int getEndPos() {
                return location.endTagEndPos >= 0 ? location.endTagEndPos : location.startTagEndPos;
            }

            public String getText(boolean headOnly) {
                return location.getText(headOnly);
            }

            public String toString() {
                return location.toString(Annotator.this);
            }
        };
    }

    List getLocInfoList() {
        return this.locInfoList;
    }

    void parse(String s) {
        ArrayStack lockInfoStack = new ArrayStack();
        ArrayList<Integer> lineStartPositions = new ArrayList<Integer>();
        int state = 0;
        int count = s.length();
        int i = 0;
        int last = 0;
        lineStartPositions.add(new Integer(i));
        lockInfoStack.push(null);
        LocInfo location = null;
        block45: while (i < count) {
            char c = s.charAt(i);
            block1 : switch (c) {
                case '<': {
                    switch (state) {
                        case 0: {
                            if (i > last) {
                                LocInfo loc2 = new LocInfo(this.locInfoList.size(), 3, last);
                                loc2.endTagEndPos = i;
                                this.locInfoList.add(loc2);
                            }
                            if (i + 1 < count) {
                                char c1 = s.charAt(i + 1);
                                switch (c1) {
                                    case '/': {
                                        state = 2;
                                        assert (location != null);
                                        break block1;
                                    }
                                    case '?': {
                                        location = new LocInfo(this.locInfoList.size(), 7, i);
                                        this.locInfoList.add(location);
                                        state = 1;
                                        i += "<?".length();
                                        continue block45;
                                    }
                                    case '!': {
                                        if (s.startsWith("--", i + 2)) {
                                            location = new LocInfo(this.locInfoList.size(), 8, i);
                                            this.locInfoList.add(location);
                                            state = 5;
                                            i += "<!--".length();
                                            continue block45;
                                        }
                                        if (!s.startsWith("[CDATA[", i + 2)) break;
                                        location = new LocInfo(this.locInfoList.size(), 4, i);
                                        this.locInfoList.add(location);
                                        state = 6;
                                        i += "<![CDATA[".length();
                                        continue block45;
                                    }
                                }
                            }
                            state = 1;
                            location = new LocInfo(this.locInfoList.size(), 1, i);
                            this.locInfoList.add(location);
                            ++i;
                            continue block45;
                        }
                    }
                    break;
                }
                case '>': {
                    switch (state) {
                        case 1: {
                            ++i;
                            assert (location != null);
                            switch (location.type) {
                                case 4: 
                                case 7: 
                                case 8: {
                                    location.endTagEndPos = i;
                                    location = (LocInfo)lockInfoStack.peek();
                                    break;
                                }
                                default: {
                                    location.startTagEndPos = i;
                                    lockInfoStack.push(location);
                                }
                            }
                            last = i;
                            state = 0;
                            continue block45;
                        }
                        case 2: {
                            ++i;
                            assert (location != null);
                            location.endTagEndPos = i;
                            try {
                                location = (LocInfo)lockInfoStack.pop();
                            }
                            catch (IndexOutOfBoundsException e) {
                                throw new RuntimeException("i=" + i + ", xml=" + this.xml.substring(i) + ", nodeList=" + this.locInfoList, e);
                            }
                            last = i;
                            state = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case '/': {
                    switch (state) {
                        case 1: {
                            if (++i >= count || s.charAt(i) != '>') continue block45;
                            location.endTagEndPos = ++i;
                            location = (LocInfo)lockInfoStack.peek();
                            last = i;
                            state = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case ']': {
                    switch (state) {
                        case 6: {
                            if (!s.startsWith("]>", i + 1)) break;
                            state = 0;
                            location.endTagEndPos = i += "]]>".length();
                            location = (LocInfo)lockInfoStack.peek();
                            last = i;
                            continue block45;
                        }
                    }
                    break;
                }
                case '-': {
                    switch (state) {
                        case 5: {
                            if (!s.startsWith("->", i + 1)) break;
                            location.endTagEndPos = i += "-->".length();
                            last = i;
                            location = (LocInfo)lockInfoStack.peek();
                            state = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case '\r': {
                    if (++i < count && s.charAt(i) == '\n') {
                        ++i;
                    }
                    lineStartPositions.add(new Integer(i));
                    continue block45;
                }
                case '\n': {
                    lineStartPositions.add(new Integer(++i));
                    continue block45;
                }
                case '\'': {
                    switch (state) {
                        case 4: {
                            state = 1;
                            break block1;
                        }
                        case 1: {
                            state = 4;
                            break block1;
                        }
                    }
                    break;
                }
                case '\"': {
                    switch (state) {
                        case 3: {
                            state = 1;
                            break block1;
                        }
                        case 1: {
                            state = 3;
                            break block1;
                        }
                    }
                }
            }
            ++i;
        }
        this.lineStartPositions = new int[lineStartPositions.size()];
        for (int j = 0; j < lineStartPositions.size(); ++j) {
            this.lineStartPositions[j] = (Integer)lineStartPositions.get(j);
        }
    }

    private void populateMap(DOMWrapper def) {
        LocInfo location;
        block2: {
            int defType = def.getType();
            do {
                location = (LocInfo)this.locInfoList.get(this.seq++);
                if (defType == 2 && location.type == 1 || defType == 4 && location.type == 3) break block2;
            } while (this.seq < this.locInfoList.size());
            return;
        }
        this.wrapperLocMap.put(def, location);
        this.nodeLocMap.put(((W3CDOMWrapper)def).node, location);
        DOMWrapper[] elementChildren = def.getElementChildren();
        for (int i = 0; i < elementChildren.length; ++i) {
            DOMWrapper domWrapper = elementChildren[i];
            this.populateMap(domWrapper);
        }
    }

    int getLine(int pos) {
        int index = Arrays.binarySearch(this.lineStartPositions, pos);
        if (index >= 0) {
            return index;
        }
        return -2 - index;
    }

    int getCol(int pos) {
        int index = Arrays.binarySearch(this.lineStartPositions, pos);
        if (index >= 0) {
            return 0;
        }
        index = -2 - index;
        return pos - this.lineStartPositions[index];
    }

    void list(PrintWriter pw) {
        for (int i = 0; i < this.locInfoList.size(); ++i) {
            LocInfo location = (LocInfo)this.locInfoList.get(i);
            pw.println(location.seq + ": " + location.toString(this) + " [" + location.getText(this.xml) + "]");
        }
        pw.flush();
    }

    private static class ArrayStack
    extends ArrayList {
        private ArrayStack() {
        }

        public final void push(Object t) {
            this.add(t);
        }

        public final Object peek() {
            return this.get(this.size() - 1);
        }

        public final Object pop() {
            int index = this.size() - 1;
            Object t = this.remove(index);
            return this.get(index - 1);
        }
    }

    class LocInfo {
        final int seq;
        final int startTagStartPos;
        final int type;
        int startTagEndPos = -1;
        int endTagEndPos = -1;

        LocInfo(int seq, int nodeType, int startTagStartPos) {
            this.seq = seq;
            this.type = nodeType;
            this.startTagStartPos = startTagStartPos;
        }

        public String toString(Annotator annotator) {
            return "line " + annotator.getLine(this.startTagStartPos) + ", column " + annotator.getCol(this.startTagStartPos);
        }

        public String getText(String xml) {
            return xml.substring(this.startTagStartPos, this.endTagEndPos >= 0 ? this.endTagEndPos : xml.length());
        }

        public String getHeadText(String xml) {
            return xml.substring(this.startTagStartPos, this.startTagEndPos >= 0 ? this.startTagEndPos : (this.endTagEndPos >= 0 ? this.endTagEndPos : xml.length()));
        }

        public String toString() {
            return this.getHeadText(Annotator.this.xml);
        }

        public String getText(boolean headOnly) {
            return Annotator.this.xml.substring(this.startTagStartPos, headOnly && this.startTagEndPos >= 0 ? this.startTagEndPos : (this.endTagEndPos >= 0 ? this.endTagEndPos : Annotator.this.xml.length()));
        }
    }
}

