/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eigenbase.xom.Any;
import org.eigenbase.xom.CdataDef;
import org.eigenbase.xom.CommentDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.GenericDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.WrapperElementDef;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.XercesDOMParser;

public abstract class XOMUtil
extends XMLUtil {
    static final NodeDef[] emptyNodeArray = new NodeDef[0];
    static final int MSXML = 1;
    static final int XERCES = 2;

    public static void discard(boolean b) {
    }

    public static void discard(byte b) {
    }

    public static void discard(char c) {
    }

    public static void discard(double d) {
    }

    public static void discard(float d) {
    }

    public static void discard(int i) {
    }

    public static void discard(long l) {
    }

    public static void discard(Object o) {
    }

    public static void discard(short s) {
    }

    static String capitalize(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Object[] addElement(Object[] a, Object o) {
        Class<?> clazz = a.getClass().getComponentType();
        Object[] a2 = (Object[])Array.newInstance(clazz, a.length + 1);
        System.arraycopy(a, 0, a2, 0, a.length);
        a2[a.length] = o;
        return a2;
    }

    public static Object[] concatenate(Object[] a0, Object[] a1) {
        Class<?> clazz = a0.getClass().getComponentType();
        Object[] a2 = (Object[])Array.newInstance(clazz, a0.length + a1.length);
        System.arraycopy(a0, 0, a2, 0, a0.length);
        System.arraycopy(a1, 0, a2, a0.length, a1.length);
        return a2;
    }

    public static void addChildren(ElementDef parent, NodeDef[] children) throws XOMException {
        if (parent instanceof GenericDef) {
            GenericDef xmlGeneric = (GenericDef)parent;
            for (int i = 0; i < children.length; ++i) {
                xmlGeneric.addChild(children[i]);
            }
        } else if (parent instanceof Any) {
            Any any = (Any)((Object)parent);
            Object[] currentChildren = any.getChildren();
            if (currentChildren == null) {
                currentChildren = children instanceof ElementDef[] ? new ElementDef[]{} : new NodeDef[]{};
            }
            NodeDef[] newChildren = (NodeDef[])XOMUtil.concatenate(currentChildren, children);
            any.setChildren(newChildren);
        } else {
            Field field = null;
            Field[] fields = parent.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getType().isArray()) continue;
                field = fields[i];
                break;
            }
            if (field == null) {
                throw new XOMException("cannot add field to " + parent.getClass() + ": it has no array field");
            }
            try {
                Object[] a = (Object[])field.get(parent);
                Object[] b = XOMUtil.concatenate(a, children);
                field.set(parent, b);
            }
            catch (IllegalAccessException e) {
                throw new XOMException(e, "in XOMUtil.getChildren");
            }
        }
    }

    public static void addChild(ElementDef parent, ElementDef child) throws XOMException {
        XOMUtil.addChildren(parent, new ElementDef[]{child});
    }

    public static void addChild(ElementDef parent, NodeDef child) throws XOMException {
        XOMUtil.addChildren(parent, new NodeDef[]{child});
    }

    public static Parser createDefaultParser() throws XOMException {
        String className = "org.eigenbase.xom.wrappers.JaxpDOMParser";
        try {
            Class<?> clazz = Class.forName(className);
            return (Parser)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new XOMException(e, "Error while creating xml parser '" + className + "'");
        }
        catch (IllegalAccessException e) {
            throw new XOMException(e, "Error while creating xml parser '" + className + "'");
        }
        catch (InstantiationException e) {
            throw new XOMException(e, "Error while creating xml parser '" + className + "'");
        }
        catch (VerifyError e) {
            throw new XOMException(e, "Error while creating xml parser '" + className + "' (If you are running Weblogic 6.1, try putting xml-apis.jar and xercesImpl.jar BEFORE weblogic.jar on CLASSPATH)");
        }
    }

    static Parser makeParser(int parserType, boolean usesPlugins, String fileDirectory, String dtdName, String docType) throws XOMException {
        try {
            switch (parserType) {
                case 1: {
                    if (usesPlugins) {
                        Class<?> clazz = Class.forName("org.eigenbase.xom.wrappers.MSXMLWrapper");
                        Method method = clazz.getDeclaredMethod("createParser", new Class[0]);
                        return (Parser)method.invoke(null, new Object[0]);
                    }
                    File dtdPath = new File(fileDirectory, dtdName);
                    Class<?> clazz = Class.forName("org.eigenbase.xom.wrappers.MSXMLWrapper");
                    Method method = clazz.getDeclaredMethod("createParser", String.class, String.class);
                    return (Parser)method.invoke(null, docType, dtdPath);
                }
                case 2: {
                    return new XercesDOMParser(!usesPlugins);
                }
            }
            throw new XOMException("Unknown parser type: " + parserType);
        }
        catch (ClassNotFoundException e) {
            throw new XOMException(e, "while creating xml parser");
        }
        catch (IllegalAccessException e) {
            throw new XOMException(e, "while creating xml parser");
        }
        catch (NoSuchMethodException e) {
            throw new XOMException(e, "while creating xml parser");
        }
        catch (InvocationTargetException e) {
            throw new XOMException(e, "while creating xml parser");
        }
    }

    public static Object getFirstInstance(Object[] a, Class clazz) {
        for (int i = 0; i < a.length; ++i) {
            if (!clazz.isInstance(a[i])) continue;
            return a[i];
        }
        return null;
    }

    public static String wrapperToXml(DOMWrapper wrapper, boolean ignorePcdata) {
        try {
            NodeDef node;
            switch (wrapper.getType()) {
                case 2: {
                    node = new WrapperElementDef(wrapper, null, null);
                    break;
                }
                case 4: {
                    node = new CdataDef(wrapper);
                    break;
                }
                case 1: {
                    node = new TextDef(wrapper);
                    break;
                }
                case 3: {
                    node = new CommentDef(wrapper);
                    break;
                }
                default: {
                    throw new Error("unknown node type " + wrapper.getType() + " while converting node to xml");
                }
            }
            StringWriter sw = new StringWriter();
            XMLOutput out = new XMLOutput(sw);
            out.setIgnorePcdata(ignorePcdata);
            out.setGlob(true);
            node.displayXML(out, 0);
            return sw.toString();
        }
        catch (XOMException e) {
            throw new Error("[" + e.toString() + "] while converting node to xml");
        }
    }
}

