/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.MetaDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class MetaGenerator {
    private MetaDef.Model model;
    private String prefix;
    private Hashtable keywordMap;
    private Hashtable typeMap;
    private Hashtable infoMap;
    private Hashtable subclassMap;
    private Vector allTypes;
    private boolean testMode;
    private static final String newLine = System.getProperty("line.separator");
    private static final char fileSep = System.getProperty("file.separator").charAt(0);

    private void append(StringBuffer buf, String first, String next, String s) {
        if (buf.length() == 0) {
            buf.append(first);
        } else {
            buf.append(next);
        }
        buf.append(s);
    }

    private static boolean booleanValue(Boolean[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            Boolean b = bs[i];
            if (b == null) continue;
            return b;
        }
        return false;
    }

    private static String getContentName(MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            return ((MetaDef.Object)content).name;
        }
        if (content instanceof MetaDef.Array) {
            return ((MetaDef.Array)content).name;
        }
        throw new XOMException("Content of type " + content.getClass().getName() + " does not have a name.");
    }

    public TypeInfo getTypeInfo(String name, boolean fail) throws XOMException {
        TypeInfo info = (TypeInfo)this.infoMap.get(name);
        if (info == null && fail) {
            throw new XOMException("Type " + name + " does not exist.");
        }
        return info;
    }

    public MetaGenerator(String xmlFile, boolean testMode) throws XOMException, IOException {
        this(xmlFile, testMode, null);
    }

    protected MetaGenerator(String xmlFile, boolean testMode, String className) throws XOMException, IOException {
        this.testMode = testMode;
        FileInputStream in = new FileInputStream(xmlFile);
        Parser parser = XOMUtil.createDefaultParser();
        try {
            DOMWrapper def = parser.parse(in);
            this.model = new MetaDef.Model(def);
        }
        catch (XOMException ex) {
            throw new XOMException(ex, "Failed to parse XML file: " + xmlFile);
        }
        if (className != null) {
            if (this.model.className == null) {
                this.model.className = className;
            } else {
                String modelClassName = this.model.className;
                if (this.model.packageName != null && !this.model.packageName.equals("")) {
                    modelClassName = this.model.packageName + "." + this.model.className;
                }
                if (!className.equals(modelClassName)) {
                    throw new XOMException("className parameter (" + className + ") is inconsistent with model's packageName and className attributes (" + modelClassName + ")");
                }
            }
        }
        this.prefix = this.model.prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.initKeywordMap();
        this.initTypeMap();
        this.initSubclassMap();
    }

    private void initKeywordMap() {
        this.keywordMap = new Hashtable();
        this.keywordMap.put("abstract", "_abstract");
        this.keywordMap.put("boolean", "_boolean");
        this.keywordMap.put("break", "_break");
        this.keywordMap.put("byte", "_byte");
        this.keywordMap.put("case", "_case");
        this.keywordMap.put("catch", "_catch");
        this.keywordMap.put("char", "_char");
        this.keywordMap.put("class", "_class");
        this.keywordMap.put("const", "_const");
        this.keywordMap.put("continue", "_continue");
        this.keywordMap.put("default", "_default");
        this.keywordMap.put("do", "_do");
        this.keywordMap.put("double", "_double");
        this.keywordMap.put("else", "_else");
        this.keywordMap.put("extends", "_extends");
        this.keywordMap.put("final", "_final");
        this.keywordMap.put("finally", "_finally");
        this.keywordMap.put("float", "_float");
        this.keywordMap.put("for", "_for");
        this.keywordMap.put("if", "_if");
        this.keywordMap.put("implements", "_implements");
        this.keywordMap.put("import", "_import");
        this.keywordMap.put("instanceof", "_instanceof");
        this.keywordMap.put("int", "_int");
        this.keywordMap.put("interface", "_interface");
        this.keywordMap.put("long", "_long");
        this.keywordMap.put("native", "_native");
        this.keywordMap.put("new", "_new");
        this.keywordMap.put("goto", "_goto");
        this.keywordMap.put("package", "_package");
        this.keywordMap.put("private", "_private");
        this.keywordMap.put("protected", "_protected");
        this.keywordMap.put("public", "_public");
        this.keywordMap.put("return", "_return");
        this.keywordMap.put("short", "_short");
        this.keywordMap.put("static", "_static");
        this.keywordMap.put("super", "_super");
        this.keywordMap.put("switch", "_switch");
        this.keywordMap.put("synchronized", "_synchronized");
        this.keywordMap.put("this", "_this");
        this.keywordMap.put("throw", "_throw");
        this.keywordMap.put("throws", "_throws");
        this.keywordMap.put("transient", "_transient");
        this.keywordMap.put("try", "_try");
        this.keywordMap.put("void", "_void");
        this.keywordMap.put("volatile", "_volatile");
        this.keywordMap.put("while", "_while");
        this.keywordMap.put("true", "_true");
        this.keywordMap.put("false", "_false");
        this.keywordMap.put("null", "_null");
    }

    private void initTypeMap() throws XOMException {
        MetaDef.Definition elt;
        int i;
        this.typeMap = new Hashtable();
        this.allTypes = new Vector();
        for (i = 0; i < this.model.elements.length; ++i) {
            elt = this.model.elements[i];
            String name = null;
            if (elt instanceof MetaDef.Element) {
                name = ((MetaDef.Element)elt).type;
            } else if (elt instanceof MetaDef.Plugin) {
                name = ((MetaDef.Plugin)elt).type;
            } else if (elt instanceof MetaDef.Class) {
                name = ((MetaDef.Class)elt)._class;
            } else if (elt instanceof MetaDef.StringElement) {
                name = ((MetaDef.StringElement)elt).type;
            } else if (elt instanceof MetaDef.Import) {
                name = ((MetaDef.Import)elt).type;
            } else {
                throw new XOMException("Illegal element type " + elt.getClass().getName());
            }
            this.typeMap.put(name, elt);
            this.allTypes.addElement(name);
        }
        this.infoMap = new Hashtable();
        for (i = 0; i < this.model.elements.length; ++i) {
            elt = this.model.elements[i];
            TypeInfo info = new TypeInfo(elt);
            this.infoMap.put(info.name, info);
        }
    }

    private void initSubclassMap() throws XOMException {
        MetaDef.Definition elt;
        int i;
        this.subclassMap = new Hashtable();
        for (i = 0; i < this.model.elements.length; ++i) {
            elt = this.model.elements[i];
            if (elt instanceof MetaDef.Class) {
                MetaDef.Class _class = (MetaDef.Class)elt;
                this.subclassMap.put(_class._class, new Vector());
            }
            if (!(elt instanceof MetaDef.Element)) continue;
            MetaDef.Element element = (MetaDef.Element)elt;
            this.subclassMap.put(element.type, new Vector());
        }
        for (i = 0; i < this.model.elements.length; ++i) {
            elt = this.model.elements[i];
            if (!(elt instanceof MetaDef.Element)) continue;
            MetaDef.Element elem = (MetaDef.Element)elt;
            TypeInfo info = this.getTypeInfo(elem.type, true);
            this.addToSubclassMap(elem, info);
        }
    }

    private void addToSubclassMap(MetaDef.Element elem, TypeInfo info) throws XOMException {
        for (int j = 0; j < info.superInfos.length; ++j) {
            TypeInfo superInfo = info.superInfos[j];
            Vector vec = (Vector)this.subclassMap.get(superInfo.name);
            if (vec == null) {
                throw new XOMException("Class " + superInfo.name + " of element " + elem.type + " is not defined.");
            }
            vec.addElement(elem);
            this.addToSubclassMap(elem, superInfo);
        }
    }

    public void writeFiles(String outputDirName, String dtdFileName) throws XOMException, IOException {
        if (dtdFileName != null) {
            if (this.model.dtdName == null) {
                this.model.dtdName = dtdFileName;
            } else if (!dtdFileName.equals(this.model.dtdName)) {
                throw new XOMException("dtdFileName parameter (" + dtdFileName + ") is inconsistent with model's dtdName attribute (" + this.model.dtdName + ")");
            }
        }
        File javaOutputDir = new File(outputDirName);
        if (!this.testMode && this.model.packageName != null && !this.model.packageName.equals("")) {
            javaOutputDir = new File(javaOutputDir, this.model.packageName.replace('.', fileSep));
        }
        File javaFile = new File(javaOutputDir, this.model.className + ".java");
        File outputDir = javaFile.getParentFile();
        File dtdFile = new File(outputDir, this.model.dtdName);
        XOMUtil.discard(new MetaDef());
        outputDir.mkdir();
        FileWriter dtdWriter = new FileWriter(dtdFile);
        PrintWriter dtdOut = new PrintWriter(dtdWriter);
        FileWriter javaWriter = new FileWriter(javaFile);
        PrintWriter javaOut = new PrintWriter(javaWriter);
        if (!this.testMode) {
            System.out.println("Writing " + dtdFile);
        }
        this.writeDtd(dtdOut);
        dtdOut.flush();
        dtdWriter.close();
        if (!this.testMode) {
            System.out.println("Writing " + javaFile);
        }
        this.writeJava(javaOut);
        javaOut.flush();
        javaWriter.close();
        if (!this.testMode) {
            System.out.println("Done");
        }
    }

    public void writeDtd(PrintWriter out) throws XOMException {
        int i;
        out.println("<!--");
        out.println("     This dtd file was automatically generated from XOM model " + this.model.name + ".");
        out.println("     Do not edit this file by hand.");
        out.println("  -->");
        out.println();
        this.writeDtdDoc(out, this.model.doc);
        for (i = 0; i < this.model.elements.length; ++i) {
            if (!(this.model.elements[i] instanceof MetaDef.Class)) continue;
            this.writeDtdEntity(out, (MetaDef.Class)this.model.elements[i]);
        }
        for (i = 0; i < this.model.elements.length; ++i) {
            this.writeDtdElement(out, this.model.elements[i]);
        }
    }

    public void writeJava(PrintWriter out) throws XOMException {
        int i;
        out.println("/*");
        out.println("// This java file was automatically generated");
        out.println("// from XOM model '" + this.model.name + "'");
        if (!this.testMode) {
            out.println("// on " + new Date().toString());
        }
        out.println("// Do not edit this file by hand.");
        out.println("*/");
        out.println();
        if (!this.testMode && this.model.packageName != null && !this.model.packageName.equals("")) {
            out.println("package " + this.model.packageName + ";");
        }
        if (!this.testMode && this.model.importName != null && !this.model.importName.equals("")) {
            int colonLoc = this.model.importName.indexOf(":");
            int start = 0;
            while (colonLoc != -1) {
                out.println("import " + this.model.importName.substring(start, colonLoc) + ";");
                start = colonLoc + 1;
                colonLoc = this.model.importName.indexOf(":", start);
            }
            out.println("import " + this.model.importName.substring(start) + ";");
        }
        String extraDoc = newLine + "<p>This class was generated from XOM model '" + this.model.name + "' on " + new Date().toString();
        if (this.testMode) {
            extraDoc = "";
        }
        this.writeJavaDoc(out, 0, this.model.doc + extraDoc);
        out.println("public class " + this.model.className + " {");
        out.println();
        out.println("\tpublic static java.lang.Class getXMLDefClass()");
        out.println("\t{");
        out.println("\t\treturn " + this.model.className + ".class;");
        out.println("\t}");
        out.println();
        out.println("\tpublic static String[] _elements = {");
        for (i = 0; i < this.allTypes.size(); ++i) {
            String type = (String)this.allTypes.elementAt(i);
            out.print("\t\t\"" + type + "\"");
            if (i < this.allTypes.size() - 1) {
                out.println(",");
                continue;
            }
            out.println();
        }
        out.println("\t};");
        out.println();
        for (i = 0; i < this.model.elements.length; ++i) {
            this.writeJavaElement(out, this.model.elements[i]);
        }
        out.println();
        out.println("}");
    }

    private void writeDtdEntity(PrintWriter out, MetaDef.Class _class) {
        if (_class.doc != null) {
            this.writeDtdDoc(out, _class.doc);
        }
        Vector subclassVec = (Vector)this.subclassMap.get(_class._class);
        out.print("<!ENTITY % " + _class._class + " \"");
        if (subclassVec == null) {
            throw new AssertFailure("Missing subclass vector for class " + _class._class);
        }
        for (int i = 0; i < subclassVec.size(); ++i) {
            MetaDef.Element elem = (MetaDef.Element)subclassVec.elementAt(i);
            if (elem.dtdName != null) {
                out.print(elem.dtdName);
            } else {
                out.print(this.prefix + elem.type);
            }
            if (i >= subclassVec.size() - 1) continue;
            out.print("|");
        }
        out.println("\">");
        out.println();
    }

    private void writeDtdElement(PrintWriter out, MetaDef.Definition elt) throws XOMException {
        if (elt instanceof MetaDef.Element) {
            int i;
            MetaDef.Element element = (MetaDef.Element)elt;
            TypeInfo info = this.getTypeInfo(element.type, false);
            if (info == null) {
                throw new AssertFailure("Element type " + element.type + " is missing from the type map.");
            }
            if (element.doc != null) {
                this.writeDtdDoc(out, element.doc);
            }
            out.print("<!ELEMENT " + info.tagName + " ");
            if (info.allContent.length == 0 && !info.isAny && !info.isCData) {
                out.print("EMPTY");
            } else if (info.isAny) {
                out.print("ANY");
            } else if (info.isCData) {
                out.print("(#PCDATA)");
            } else {
                out.print("(");
                for (i = 0; i < info.allContent.length; ++i) {
                    this.writeDtdContent(out, info.allContent[i]);
                    if (i >= info.allContent.length - 1) continue;
                    out.print(",");
                }
                out.print(")");
            }
            out.println(">");
            if (info.allAttributes.length > 0) {
                out.println("<!ATTLIST " + info.tagName);
                for (i = 0; i < info.allAttributes.length; ++i) {
                    this.writeDtdAttribute(out, info.allAttributes[i]);
                }
                out.println(">");
            }
            out.println();
        } else if (!(elt instanceof MetaDef.Class)) {
            if (elt instanceof MetaDef.StringElement) {
                MetaDef.StringElement element = (MetaDef.StringElement)elt;
                TypeInfo info = (TypeInfo)this.infoMap.get(element.type);
                if (info == null) {
                    throw new AssertFailure("StringElement type " + element.type + " is missing from the type map.");
                }
                if (element.doc != null) {
                    this.writeDtdDoc(out, element.doc);
                }
                out.println("<!ELEMENT " + info.tagName + " (#PCDATA)>");
                out.println();
            } else if (elt instanceof MetaDef.Plugin) {
                MetaDef.Plugin plugin = (MetaDef.Plugin)elt;
                TypeInfo info = (TypeInfo)this.infoMap.get(plugin.type);
                if (info == null) {
                    throw new AssertFailure("Plugin element " + plugin.type + " is missing from the type map.");
                }
                if (plugin.doc != null) {
                    this.writeDtdDoc(out, plugin.doc);
                }
                out.println("<!ELEMENT " + info.tagName + " ANY>");
                out.println("<!ATTLIST " + info.tagName);
                for (int i = 0; i < info.allAttributes.length; ++i) {
                    if (info.allAttributes[i].name.equals("defPackage") || info.allAttributes[i].name.equals("defClass")) {
                        throw new XOMException("The attribute \"" + info.allAttributes[i].name + "\" is reserved and may not be redefined in or inherited by a Plugin.");
                    }
                    this.writeDtdAttribute(out, info.allAttributes[i]);
                }
                out.println("defPackage CDATA \"org.eigenbase.xom\"");
                out.println("defClass CDATA #REQUIRED");
                out.println(">");
                out.println();
            } else if (elt instanceof MetaDef.Import) {
                MetaDef.Import imp = (MetaDef.Import)elt;
                TypeInfo info = this.getTypeInfo(imp.type, true);
                out.println("<!ELEMENT " + info.name + " ANY>");
                out.println();
            } else {
                throw new XOMException("Unrecognized element type definition: " + elt.getClass().getName());
            }
        }
    }

    private void writeDtdDoc(PrintWriter out, String doc) {
        out.println("<!--");
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new StringReader(doc));
            while ((line = reader.readLine()) != null) {
                String trimLine = line.trim();
                if (trimLine.equals("")) continue;
                out.print("     ");
                out.println(trimLine);
            }
        }
        catch (IOException ex) {
            throw new AssertFailure(ex);
        }
        out.println("  -->");
    }

    private void writeJavaDoc(PrintWriter out, int indent, String doc) {
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println("/**");
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new StringReader(doc));
            while ((line = reader.readLine()) != null) {
                String trimLine = line.trim();
                if (trimLine.equals("")) continue;
                for (int i = 0; i < indent; ++i) {
                    out.print("\t");
                }
                out.print(" * ");
                out.println(trimLine);
            }
        }
        catch (IOException ex) {
            throw new AssertFailure(ex);
        }
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println(" */");
    }

    private void writeJavaCode(PrintWriter out, int indent, String code) {
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println("// BEGIN pass-through code block ---");
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new StringReader(code));
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
        }
        catch (IOException ex) {
            throw new AssertFailure(ex);
        }
        for (int i = 0; i < indent; ++i) {
            out.print("\t");
        }
        out.println("// END pass-through code block ---");
    }

    private MetaDef.Definition getType(String name) throws XOMException {
        MetaDef.Definition type = (MetaDef.Definition)this.typeMap.get(name);
        if (type == null) {
            throw new XOMException("Element type name " + name + " was never defined.");
        }
        return type;
    }

    private String getDeclaredName(String name) {
        String mappedName = (String)this.keywordMap.get(name);
        if (mappedName == null) {
            return name;
        }
        return mappedName;
    }

    private void writeDtdContent(PrintWriter out, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            TypeInfo info = (TypeInfo)this.infoMap.get(obj.type);
            if (info == null) {
                throw new XOMException("Object " + obj.name + " has undefined type " + obj.type);
            }
            out.print(info.tagName);
            if (!obj.required.booleanValue()) {
                out.print("?");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            TypeInfo info = (TypeInfo)this.infoMap.get(array.type);
            if (info == null) {
                throw new XOMException("Array " + array.name + " has undefined type " + array.type);
            }
            out.print("(" + info.tagName + ")");
            if (array.min > 0) {
                out.print("+");
            } else {
                out.print("*");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    private void writeDtdAttribute(PrintWriter out, MetaDef.Attribute attr) {
        out.print(attr.name + " ");
        if (attr.values == null || attr.values.length == 0) {
            if (attr.type.equalsIgnoreCase("Boolean")) {
                out.print("(true|false) ");
            } else {
                out.print("CDATA ");
            }
        } else {
            out.print("(");
            for (int i = 0; i < attr.values.length; ++i) {
                out.print(attr.values[i]);
                if (i >= attr.values.length - 1) continue;
                out.print("|");
            }
            out.print(") ");
        }
        if (attr._default == null) {
            if (attr.required.booleanValue()) {
                out.println("#REQUIRED");
            } else {
                out.println("#IMPLIED");
            }
        } else {
            out.print("\"" + attr._default + "\"");
            out.println();
        }
    }

    private static boolean hasContentType(MetaDef.Content[] content, Class match) {
        for (int i = 0; i < content.length; ++i) {
            if (content[i].getClass() != match) continue;
            return true;
        }
        return false;
    }

    private void writeJavaElement(PrintWriter out, MetaDef.Definition elt) throws XOMException {
        if (elt instanceof MetaDef.Element) {
            MetaDef.Element element = (MetaDef.Element)elt;
            TypeInfo info = (TypeInfo)this.infoMap.get(element.type);
            if (info == null) {
                throw new XOMException("Element type " + element.type + " was never defined.");
            }
            info.writeJavaClass(out);
        } else if (elt instanceof MetaDef.Plugin) {
            MetaDef.Plugin plugin = (MetaDef.Plugin)elt;
            TypeInfo info = (TypeInfo)this.infoMap.get(plugin.type);
            if (info == null) {
                throw new XOMException("Plugin type " + plugin.type + " was never defined.");
            }
            info.writeJavaClass(out);
        } else if (elt instanceof MetaDef.Class) {
            MetaDef.Class _class = (MetaDef.Class)elt;
            TypeInfo info = (TypeInfo)this.infoMap.get(_class._class);
            if (info == null) {
                throw new XOMException("Class type " + _class._class + " was never defined.");
            }
            info.writeJavaClass(out);
        } else if (elt instanceof MetaDef.StringElement) {
            MetaDef.StringElement element = (MetaDef.StringElement)elt;
            if (element.doc != null) {
                this.writeJavaDoc(out, 1, element.doc);
            }
            out.println("\tpublic static final String " + element.type + " = \"" + element.type + "\";");
            out.println();
        } else if (!(elt instanceof MetaDef.Import)) {
            throw new XOMException("Unrecognized element type definition: " + elt.getClass().getName());
        }
    }

    public void writeJavaGetAttribute(PrintWriter out, MetaDef.Attribute attr) throws XOMException {
        out.print("\t\t\t\t" + this.getDeclaredName(attr.name) + " = ");
        out.print("(" + attr.type + ")_parser.getAttribute(");
        out.print("\"" + attr.name + "\", \"" + attr.type + "\", ");
        if (attr._default == null) {
            out.print("null, ");
        } else {
            out.print("\"" + attr._default + "\", ");
        }
        if (attr.values == null || attr.values.length == 0) {
            out.print("null, ");
        } else {
            out.print("_" + this.getDeclaredName(attr.name) + "_values, ");
        }
        if (attr.required.booleanValue()) {
            out.print("true");
        } else {
            out.print("false");
        }
        out.println(");");
    }

    public void writeJavaDeclareAttribute(PrintWriter out, MetaDef.Attribute attr) throws XOMException {
        if (attr.values != null && attr.values.length > 0) {
            out.println("\t\t/** Allowable values for {@link #" + this.getDeclaredName(attr.name) + "}. */");
            out.print("\t\tpublic static final String[] _" + this.getDeclaredName(attr.name) + "_values = {");
            for (int i = 0; i < attr.values.length; ++i) {
                out.print("\"" + attr.values[i] + "\"");
                if (i >= attr.values.length - 1) continue;
                out.print(", ");
            }
            out.println("};");
        }
        out.print("\t\tpublic " + attr.type + " " + this.getDeclaredName(attr.name) + ";  // ");
        if (attr._default != null) {
            out.print("attribute default: " + attr._default);
        } else if (attr.required.booleanValue()) {
            out.print("required attribute");
        } else {
            out.print("optional attribute");
        }
        out.println();
    }

    public void writeJavaDisplayAttribute(PrintWriter out, MetaDef.Attribute attr) throws XOMException {
        out.println("\t\t\tdisplayAttribute(_out, \"" + attr.name + "\", " + this.getDeclaredName(attr.name) + ", _indent+1);");
    }

    public void writeJavaDisplayXMLAttribute(PrintWriter out, MetaDef.Attribute attr) throws XOMException {
        out.println("\t\t\t\t.add(\"" + attr.name + "\", " + this.getDeclaredName(attr.name) + ")");
    }

    public void writeJavaDisplayDiffAttribute(PrintWriter out, int[] diffCount, MetaDef.Attribute attr) throws XOMException {
        out.println("\t\t\t" + this.prefix(diffCount) + "displayAttributeDiff(\"" + attr.name + "\", " + this.getDeclaredName(attr.name) + ", _cother." + this.getDeclaredName(attr.name) + ", _out, _indent+1);");
    }

    public void writeJavaGetContent(PrintWriter out, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            MetaDef.Definition type = this.getType(obj.type);
            TypeInfo info = this.getTypeInfo(obj.type, true);
            out.print("\t\t\t\t" + this.getDeclaredName(obj.name) + " = ");
            if (type != null && type instanceof MetaDef.Import) {
                info = this.getTypeInfo(((MetaDef.Import)type).type, true);
                out.print("(" + info.impName + ")_parser.getElement(");
                out.print(info.impName + ".class, ");
            } else if (type != null && type instanceof MetaDef.StringElement) {
                out.print("_parser.getString(" + info.className + ", ");
            } else {
                out.print("(" + info.className + ")_parser.getElement(");
                out.print(info.className + ".class, ");
            }
            if (obj.required.booleanValue()) {
                out.print("true");
            } else {
                out.print("false");
            }
            out.println(");");
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition type = this.getType(array.type);
            String typeName = this.getTypeInfo((String)array.type, (boolean)true).className;
            if (type instanceof MetaDef.Import) {
                TypeInfo info = this.getTypeInfo(((MetaDef.Import)type).type, true);
                out.print("\t\t\t\t_tempArray = _parser.getArray(");
                out.print(info.impName + ".class, ");
                out.println(array.min + ", " + array.max + ");");
                out.println("\t\t\t\t" + this.getDeclaredName(array.name) + " = new " + info.impName + "[_tempArray.length];");
                out.println("\t\t\t\tfor (int _i = 0; _i < " + this.getDeclaredName(array.name) + ".length; _i++)");
                out.println("\t\t\t\t\t" + this.getDeclaredName(array.name) + "[_i] = (" + typeName + ")_tempArray[_i];");
            } else if (type instanceof MetaDef.StringElement) {
                out.print("\t\t\t\t" + this.getDeclaredName(array.name) + " = _parser.getStringArray(");
                out.println("\"" + typeName + "\", " + array.min + ", " + array.max + ");");
            } else {
                out.print("\t\t\t\t_tempArray = _parser.getArray(");
                out.print(typeName + ".class, ");
                out.println(array.min + ", " + array.max + ");");
                out.println("\t\t\t\t" + this.getDeclaredName(array.name) + " = new " + typeName + "[_tempArray.length];");
                out.println("\t\t\t\tfor (int _i = 0; _i < " + this.getDeclaredName(array.name) + ".length; _i++)");
                out.println("\t\t\t\t\t" + this.getDeclaredName(array.name) + "[_i] = (" + typeName + ")_tempArray[_i];");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaGetAnyContent(PrintWriter out, boolean mixed) {
        if (mixed) {
            out.println("\t\t\t\tchildren = getMixedChildren(_def, " + this.model.className + ".class, \"" + this.prefix + "\");");
        } else {
            out.println("\t\t\t\tchildren = getElementChildren(_def, " + this.model.className + ".class, \"" + this.prefix + "\");");
        }
    }

    public void writeJavaGetCDataContent(PrintWriter out) {
        out.println("\t\t\t\tcdata = _parser.getText();");
    }

    public void writeJavaDeclareContent(PrintWriter out, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            if (obj.doc != null) {
                this.writeJavaDoc(out, 2, obj.doc);
            }
            MetaDef.Definition type = this.getType(obj.type);
            String typeName = this.getTypeInfo((String)obj.type, (boolean)true).className;
            if (type instanceof MetaDef.Import) {
                TypeInfo info = this.getTypeInfo(((MetaDef.Import)type).type, true);
                typeName = info.impName;
                out.print("\t\tpublic " + typeName + " " + this.getDeclaredName(obj.name) + ";  //");
            } else if (type instanceof MetaDef.StringElement) {
                out.print("\t\tpublic String " + this.getDeclaredName(obj.name) + ";  //");
            } else {
                out.print("\t\tpublic " + typeName + " " + this.getDeclaredName(obj.name) + ";  //");
            }
            if (obj.required.booleanValue()) {
                out.println("required element");
            } else {
                out.println("optional element");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            if (array.doc != null) {
                this.writeJavaDoc(out, 2, array.doc);
            }
            MetaDef.Definition type = this.getType(array.type);
            String typeName = this.getTypeInfo((String)array.type, (boolean)true).className;
            if (type instanceof MetaDef.Import) {
                TypeInfo info = this.getTypeInfo(((MetaDef.Import)type).type, true);
                typeName = info.impName;
                out.print("\t\tpublic " + typeName + "[] " + this.getDeclaredName(array.name) + ";  //");
            } else if (type instanceof MetaDef.StringElement) {
                out.print("\t\tpublic String[] " + this.getDeclaredName(array.name) + ";  //");
            } else {
                out.print("\t\tpublic " + typeName + "[] " + this.getDeclaredName(array.name) + ";  //");
            }
            if (array.min <= 0 && array.max <= 0) {
                out.println("optional array");
            } else {
                if (array.min > 0) {
                    out.print("min " + array.min);
                }
                if (array.max > 0) {
                    out.print("max " + array.max);
                }
                out.println();
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDeclareAnyContent(PrintWriter out, boolean mixed) {
        out.println("\t\tpublic org.eigenbase.xom." + (mixed ? "NodeDef" : "ElementDef") + "[] children;  //holder for variable-type children");
        out.println("\t\t// implement Any");
        out.println("\t\tpublic org.eigenbase.xom.NodeDef[] getChildren()");
        out.println("\t\t{");
        out.println("\t\t\treturn children;");
        out.println("\t\t}");
        out.println("\t\t// implement Any");
        out.println("\t\tpublic void setChildren(org.eigenbase.xom.NodeDef[] children)");
        out.println("\t\t{");
        out.println("\t\t\tthis.children = " + (mixed ? "" : "(org.eigenbase.xom.ElementDef[]) ") + "children;");
        out.println("\t\t}");
    }

    public void writeJavaDeclareCDataContent(PrintWriter out) {
        out.print("\t\tpublic String cdata;  // All text goes here");
    }

    public void writeJavaDisplayContent(PrintWriter out, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            MetaDef.Definition type = this.getType(obj.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\tdisplayString(_out, \"" + obj.name + "\", " + this.getDeclaredName(obj.name) + ", _indent+1);");
            } else {
                out.println("\t\t\tdisplayElement(_out, \"" + obj.name + "\", (org.eigenbase.xom.ElementDef) " + this.getDeclaredName(obj.name) + ", _indent+1);");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition type = this.getType(array.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\tdisplayStringArray(_out, \"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _indent+1);");
            } else {
                out.println("\t\t\tdisplayElementArray(_out, \"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _indent+1);");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDisplayAnyContent(PrintWriter out) {
        out.println("\t\t\tdisplayElementArray(_out, \"children\", children, _indent+1);");
    }

    public void writeJavaDisplayCDataContent(PrintWriter out) {
        out.println("\t\t\tdisplayString(_out, \"cdata\", cdata, _indent+1);");
    }

    public void writeJavaDisplayXMLContent(PrintWriter out, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            MetaDef.Definition type = this.getType(obj.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\tdisplayXMLString(_out, \"" + this.getTypeInfo((String)obj.type, (boolean)true).tagName + "\", " + this.getDeclaredName(obj.name) + ");");
            } else {
                out.println("\t\t\tdisplayXMLElement(_out, (org.eigenbase.xom.ElementDef) " + this.getDeclaredName(obj.name) + ");");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition type = this.getType(array.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\tdisplayXMLStringArray(_out, \"" + this.getTypeInfo((String)array.type, (boolean)true).tagName + "\", " + this.getDeclaredName(array.name) + ");");
            } else {
                out.println("\t\t\tdisplayXMLElementArray(_out, " + this.getDeclaredName(array.name) + ");");
            }
        } else if (content instanceof MetaDef.Any) {
            out.println("\t\t\tdisplayXMLElementArray(_out, children);");
        } else if (content instanceof MetaDef.CData) {
            out.println("\t\t\t_out.cdata(cdata);");
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDisplayXMLAnyContent(PrintWriter out) {
        out.println("\t\t\tdisplayXMLElementArray(_out, children);");
    }

    public void writeJavaDisplayXMLCDataContent(PrintWriter out) {
        out.println("\t\t\t_out.cdata(cdata);");
    }

    public void writeJavaDisplayDiffContent(PrintWriter out, int[] diffCount, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object obj = (MetaDef.Object)content;
            MetaDef.Definition type = this.getType(obj.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\t" + this.prefix(diffCount) + "displayStringDiff(\"" + obj.name + "\", " + this.getDeclaredName(obj.name) + ", _cother." + this.getDeclaredName(obj.name) + ", _out, _indent+1);");
            } else {
                out.println("\t\t\t" + this.prefix(diffCount) + "displayElementDiff(\"" + obj.name + "\", " + this.getDeclaredName(obj.name) + ", _cother." + this.getDeclaredName(obj.name) + ", _out, _indent+1);");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition type = this.getType(array.type);
            if (type instanceof MetaDef.StringElement) {
                out.println("\t\t\t" + this.prefix(diffCount) + "displayStringArrayDiff(\"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _cother." + this.getDeclaredName(array.name) + ", _out, _indent+1);");
            } else {
                out.println("\t\t\t" + this.prefix(diffCount) + "displayElementArrayDiff(\"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _cother." + this.getDeclaredName(array.name) + ", _out, _indent+1);");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    private String prefix(int[] diffCount) {
        int n = diffCount[0];
        diffCount[0] = n + 1;
        if (n == 0) {
            return "boolean _diff = ";
        }
        return "_diff = _diff && ";
    }

    public void writeJavaDisplayDiffAnyContent(PrintWriter out, int[] diffCount) {
        out.println("\t\t\t" + this.prefix(diffCount) + "displayElementArrayDiff(\"children\", children, _cother.children, _out, _indent+1);");
    }

    public void writeJavaDisplayDiffCDataContent(PrintWriter out, int[] diffCount) {
        out.println("\t\t\t" + this.prefix(diffCount) + "displayStringDiff(\"cdata\", cdata, _cother.cdata, _out, _indent+1);");
    }

    public void writeJavaDeclarePluginAttributes(PrintWriter out) {
        this.writeJavaDoc(out, 2, "defPackage is a built-in attribute defining the package of the plugin class.");
        out.println("\t\tpublic String defPackage;");
        out.println();
        this.writeJavaDoc(out, 2, "defClass is a built-in attribute definition the plugin parser class.");
        out.println("\t\tpublic String defClass;");
        out.println();
    }

    public void writeJavaDisplayPluginAttributes(PrintWriter out) {
        out.println("\t\t\tdisplayAttribute(_out, \"defPackage\", defPackage, _indent+1);");
        out.println("\t\t\tdisplayAttribute(_out, \"defClass\", defClass, _indent+1);");
    }

    public void writeJavaDisplayXMLPluginAttributes(PrintWriter out) {
        out.println("\t\t\t\t.add(\"defPackage\", defPackage)");
        out.println("\t\t\t\t.add(\"defClass\", defClass)");
    }

    public void writeJavaDisplayDiffPluginAttributes(PrintWriter out, int[] diffCount) {
        out.println("\t\t\t" + this.prefix(diffCount) + "displayAttributeDiff(\"defPackage\", defPackage, _cother.defPackage, _out, _indent+1);");
        out.println("\t\t\t" + this.prefix(diffCount) + "displayAttributeDiff(\"defClass\", defClass, _cother.defClass, _out, _indent+1);");
    }

    public void writeJavaGetPluginContent(PrintWriter out, boolean mixed) {
        if (mixed) {
            out.println("\t\t\t\tchildren = getMixedChildren(_def, _pluginClass, \"\");");
        } else {
            out.println("\t\t\t\tchildren = getElementChildren(_def, _pluginClass, \"\");");
        }
    }

    public void writeJavaDeclarePluginContent(PrintWriter out, boolean mixed) {
        out.println("\t\tpublic org.eigenbase.xom." + (mixed ? "NodeDef" : "ElementDef") + "[] children;  //holder for variable-type children");
    }

    public void writeJavaDisplayPluginContent(PrintWriter out) {
        out.println("\t\t\tdisplayElementArray(_out, \"children\", children, _indent+1);");
    }

    public void writeJavaDisplayXMLPluginContent(PrintWriter out) {
        out.println("\t\t\tdisplayXMLElementArray(_out, children);");
    }

    public void writeJavaDisplayDiffPluginContent(PrintWriter out, int[] diffCount) {
        out.println("\t\t\t" + this.prefix(diffCount) + "displayElementArrayDiff(\"children\", children, _cother.children, _out, _indent+1);");
    }

    public void writeOutputs() {
        if (this.testMode) {
            System.out.println(this.model.dtdName + " " + this.model.className);
        }
    }

    public static void main(String[] args) {
        int firstArg = 0;
        boolean testMode = false;
        if (firstArg < args.length && args[firstArg].equals("-debug")) {
            System.err.println("MetaGenerator pausing for debugging.  Attach your debugger and press return.");
            try {
                System.in.read();
                ++firstArg;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (firstArg < args.length && args[firstArg].equals("-test")) {
            System.err.println("Ignoring package name.");
            testMode = true;
            ++firstArg;
        }
        if (args.length != 2 + firstArg) {
            System.err.println("Usage: java MetaGenerator [-debug] [-test] <XML model file> <output directory>");
            System.exit(2);
        }
        try {
            MetaGenerator generator = new MetaGenerator(args[0 + firstArg], testMode);
            generator.writeFiles(args[1 + firstArg], null);
            generator.writeOutputs();
        }
        catch (XOMException ex) {
            System.err.println("Generation of model failed:");
            System.err.println(ex.toString());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("Generation of model failed:");
            System.err.println(ex.toString());
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void debugDisplay() {
        System.out.println("Model:");
        System.out.println(this.model.toString());
    }

    private class TypeInfo {
        public MetaDef.Definition def;
        public String doc;
        public String code;
        public String name;
        public String className;
        public String tagName;
        public MetaDef.Attribute[] allAttributes;
        public MetaDef.Attribute[] ovrAttributes;
        public MetaDef.Attribute[] newAttributes;
        public MetaDef.Content[] allContent;
        public MetaDef.Content[] newContent;
        public boolean isAny;
        public boolean isCData;
        public TypeInfo[] superInfos;
        public Class impClass;
        public String impName;
        public String contentModel;

        public TypeInfo(MetaDef.Definition elt) throws XOMException {
            MetaDef.Content[] content;
            MetaDef.Attribute[] attributes;
            this.def = elt;
            this.name = null;
            this.contentModel = "sequential";
            Vector superInfoList = new Vector();
            if (elt instanceof MetaDef.Element) {
                MetaDef.Element element = (MetaDef.Element)elt;
                this.name = element.type;
                this.tagName = element.dtdName != null ? element.dtdName : MetaGenerator.this.prefix + this.name;
                this.registerSuper(superInfoList, element._class);
                attributes = element.attributes;
                content = element.content;
                this.contentModel = element.contentModel;
                this.doc = element.doc;
                this.code = element.code;
                this.impClass = null;
                this.impName = null;
            } else if (elt instanceof MetaDef.Plugin) {
                this.name = ((MetaDef.Plugin)elt).type;
                this.tagName = MetaGenerator.this.prefix + this.name;
                this.registerSuper(superInfoList, ((MetaDef.Plugin)elt)._class);
                attributes = ((MetaDef.Plugin)elt).attributes;
                content = new MetaDef.Content[]{};
                this.doc = ((MetaDef.Plugin)elt).doc;
                this.code = ((MetaDef.Plugin)elt).code;
                this.impClass = null;
                this.impName = null;
            } else if (elt instanceof MetaDef.Class) {
                this.name = ((MetaDef.Class)elt)._class;
                this.tagName = "(%" + this.name + ";)";
                this.registerSuper(superInfoList, ((MetaDef.Class)elt).superclass);
                attributes = ((MetaDef.Class)elt).attributes;
                content = ((MetaDef.Class)elt).content;
                this.doc = ((MetaDef.Class)elt).doc;
                this.code = ((MetaDef.Class)elt).code;
                this.impClass = null;
                this.impName = null;
            } else if (elt instanceof MetaDef.StringElement) {
                this.name = ((MetaDef.StringElement)elt).type;
                this.tagName = MetaGenerator.this.prefix + this.name;
                attributes = new MetaDef.Attribute[]{};
                content = new MetaDef.Content[]{};
                this.doc = ((MetaDef.StringElement)elt).doc;
                this.code = null;
                this.impClass = null;
                this.impName = null;
            } else if (elt instanceof MetaDef.Import) {
                MetaDef.Import imp = (MetaDef.Import)elt;
                this.name = imp.type;
                this.tagName = imp.dtdName != null ? imp.dtdName : MetaGenerator.this.prefix + this.name;
                attributes = new MetaDef.Attribute[]{};
                content = new MetaDef.Content[]{};
                this.doc = null;
                this.code = null;
                try {
                    this.impName = imp.defPackage + "." + imp.defClass + "." + this.name;
                    this.impClass = Class.forName(imp.defPackage + "." + imp.defClass + "$" + this.name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                throw new XOMException("Illegal element type " + elt.getClass().getName());
            }
            this.className = XOMUtil.capitalize(this.name);
            this.superInfos = superInfoList.toArray(new TypeInfo[superInfoList.size()]);
            boolean newAny = false;
            boolean newCData = false;
            if (content.length == 1) {
                if (content[0] instanceof MetaDef.CData) {
                    newCData = true;
                } else if (content[0] instanceof MetaDef.Any) {
                    newAny = true;
                }
            }
            if (!newAny && !newCData) {
                for (int i = 0; i < content.length; ++i) {
                    if (!(content[i] instanceof MetaDef.CData) && !(content[i] instanceof MetaDef.Any)) continue;
                    throw new XOMException("Type " + this.name + " defines <Any> or <CData> content as well as other content.");
                }
            }
            if (this.superInfos.length == 0) {
                this.allAttributes = attributes;
                this.ovrAttributes = new MetaDef.Attribute[0];
                this.newAttributes = this.allAttributes;
                if (newAny || newCData) {
                    this.isAny = newAny;
                    this.isCData = newCData;
                    this.allContent = new MetaDef.Content[0];
                } else {
                    this.isCData = false;
                    this.isAny = false;
                    this.allContent = content;
                }
                this.newContent = this.allContent;
            } else {
                TypeInfo superInfo;
                int j;
                int i;
                Hashtable<String, MetaDef.Attribute> attrHash = new Hashtable<String, MetaDef.Attribute>();
                Hashtable<String, MetaDef.Attribute> ovrHash = new Hashtable<String, MetaDef.Attribute>();
                Vector<MetaDef.Attribute> allAttrs = new Vector<MetaDef.Attribute>();
                Vector<MetaDef.Attribute> ovrAttrs = new Vector<MetaDef.Attribute>();
                Vector<MetaDef.Attribute> newAttrs = new Vector<MetaDef.Attribute>();
                for (int j2 = 0; j2 < this.superInfos.length; ++j2) {
                    TypeInfo superInfo2 = this.superInfos[j2];
                    for (i = 0; i < superInfo2.allAttributes.length; ++i) {
                        attrHash.put(superInfo2.allAttributes[i].name, superInfo2.allAttributes[i]);
                    }
                }
                for (int i2 = 0; i2 < attributes.length; ++i2) {
                    MetaDef.Attribute inhAttr = (MetaDef.Attribute)attrHash.get(attributes[i2].name);
                    if (inhAttr == null) {
                        allAttrs.addElement(attributes[i2]);
                        newAttrs.addElement(attributes[i2]);
                        continue;
                    }
                    if (!attributes[i2].type.equals(inhAttr.type)) {
                        throw new XOMException("Element " + this.name + " inherits attribute " + inhAttr.name + " of type " + inhAttr.type + " but redefines it to be of type " + attributes[i2].type);
                    }
                    ovrAttrs.addElement(attributes[i2]);
                    ovrHash.put(attributes[i2].name, attributes[i2]);
                }
                boolean superAny = false;
                boolean superCData = false;
                for (j = 0; j < this.superInfos.length; ++j) {
                    superInfo = this.superInfos[j];
                    for (int i3 = 0; i3 < superInfo.allAttributes.length; ++i3) {
                        if (ovrHash.get(superInfo.allAttributes[i3].name) != null) continue;
                        allAttrs.addElement(superInfo.allAttributes[i3]);
                    }
                    if (superInfo.isAny) {
                        superAny = true;
                    }
                    if (!superInfo.isCData) continue;
                    superCData = true;
                }
                for (i = 0; i < ovrAttrs.size(); ++i) {
                    allAttrs.addElement((MetaDef.Attribute)ovrAttrs.elementAt(i));
                }
                this.allAttributes = new MetaDef.Attribute[allAttrs.size()];
                for (i = 0; i < this.allAttributes.length; ++i) {
                    this.allAttributes[i] = (MetaDef.Attribute)allAttrs.elementAt(i);
                }
                this.ovrAttributes = new MetaDef.Attribute[ovrAttrs.size()];
                for (i = 0; i < this.ovrAttributes.length; ++i) {
                    this.ovrAttributes[i] = (MetaDef.Attribute)ovrAttrs.elementAt(i);
                }
                this.newAttributes = new MetaDef.Attribute[newAttrs.size()];
                for (i = 0; i < this.newAttributes.length; ++i) {
                    this.newAttributes[i] = (MetaDef.Attribute)newAttrs.elementAt(i);
                }
                if (newAny || newCData) {
                    for (j = 0; j < this.superInfos.length; ++j) {
                        superInfo = this.superInfos[j];
                        if (superInfo.isAny || superInfo.isCData) {
                            throw new XOMException("Element " + this.name + " both defines and inherits <CData> or <Any> content.");
                        }
                        if (superInfo.allContent.length <= 0) continue;
                        throw new XOMException("Element " + this.name + " inherits standard content but defines <CData> or <Any> content.");
                    }
                    this.isAny = newAny;
                    this.isCData = newCData;
                    this.allContent = new MetaDef.Content[0];
                    this.newContent = new MetaDef.Content[0];
                } else if (superAny || superCData) {
                    if (content.length > 0) {
                        throw new XOMException("Element " + this.name + " inherits <CData> or <Any> content but defines standard content.");
                    }
                    this.isAny = superAny;
                    this.isCData = superCData;
                    this.allContent = new MetaDef.Content[0];
                    this.newContent = new MetaDef.Content[0];
                } else {
                    int i4;
                    this.isCData = false;
                    this.isAny = false;
                    Hashtable<String, MetaDef.Content> contentHash = new Hashtable<String, MetaDef.Content>();
                    Vector<MetaDef.Content> allContentVec = new Vector<MetaDef.Content>();
                    Vector<MetaDef.Content> newContentVec = new Vector<MetaDef.Content>();
                    newContentVec.addAll(Arrays.asList(content));
                    for (int j3 = 0; j3 < this.superInfos.length; ++j3) {
                        TypeInfo superInfo3 = this.superInfos[j3];
                        for (int i5 = 0; i5 < superInfo3.allContent.length; ++i5) {
                            if (!superInfo3.isInterface()) {
                                contentHash.put(MetaGenerator.getContentName(superInfo3.allContent[i5]), superInfo3.allContent[i5]);
                            } else {
                                newContentVec.addElement(superInfo3.allContent[i5]);
                            }
                            allContentVec.addElement(superInfo3.allContent[i5]);
                        }
                    }
                    for (i4 = 0; i4 < content.length; ++i4) {
                        MetaDef.Content inhContent = (MetaDef.Content)contentHash.get(MetaGenerator.getContentName(content[i4]));
                        if (inhContent != null) {
                            throw new XOMException("Content named " + MetaGenerator.getContentName(content[i4]) + " defined in element " + this.name + " was already defined in an inherited element.");
                        }
                        allContentVec.addElement(content[i4]);
                    }
                    this.allContent = new MetaDef.Content[allContentVec.size()];
                    for (i4 = 0; i4 < this.allContent.length; ++i4) {
                        this.allContent[i4] = (MetaDef.Content)allContentVec.elementAt(i4);
                    }
                    this.newContent = new MetaDef.Content[newContentVec.size()];
                    for (i4 = 0; i4 < this.newContent.length; ++i4) {
                        this.newContent[i4] = (MetaDef.Content)newContentVec.elementAt(i4);
                    }
                }
            }
            if (MetaGenerator.this.infoMap.get(this.name) == null) {
                MetaGenerator.this.infoMap.put(this.name, this);
            }
        }

        private void registerSuper(Vector superInfoList, String className) throws XOMException {
            if (className == null) {
                return;
            }
            String[] classNames = className.split(",");
            for (int i = 0; i < classNames.length; ++i) {
                superInfoList.add(this.lookupSuper(classNames[i].trim()));
            }
        }

        private TypeInfo lookupSuper(String superName) throws XOMException {
            TypeInfo superInfo = (TypeInfo)MetaGenerator.this.infoMap.get(superName);
            if (superInfo == null) {
                MetaDef.Definition superDef = (MetaDef.Definition)MetaGenerator.this.infoMap.get(superName);
                if (superDef == null) {
                    throw new XOMException("Parent class " + superName + " of element " + this.name + " was never defined.");
                }
                superInfo = new TypeInfo(superDef);
            }
            return superInfo;
        }

        private boolean isInterface() {
            return this.def instanceof MetaDef.Class;
        }

        public void writeJavaClass(PrintWriter out) throws XOMException {
            int i;
            int i2;
            TypeInfo superInfo;
            String classDesc;
            if (this.doc != null) {
                MetaGenerator.this.writeJavaDoc(out, 1, this.doc);
            }
            StringBuffer extendsList = new StringBuffer();
            StringBuffer implementsList = new StringBuffer();
            if (this.def instanceof MetaDef.Class) {
                classDesc = "interface";
                for (int j = 0; j < this.superInfos.length; ++j) {
                    TypeInfo superInfo2 = this.superInfos[j];
                    if (!superInfo2.isInterface()) {
                        throw new RuntimeException("Superclass of a Class must be a Class: " + this.className + " extends " + superInfo2.className);
                    }
                    MetaGenerator.this.append(extendsList, " extends ", ", ", superInfo2.className);
                }
                if (extendsList.length() == 0) {
                    extendsList.append(" extends org.eigenbase.xom.NodeDef");
                }
            } else {
                MetaDef.Element element = (MetaDef.Element)this.def;
                classDesc = "static " + (element._abstract != null && element._abstract != false ? "abstract " : "") + "class";
                for (int j = 0; j < this.superInfos.length; ++j) {
                    superInfo = this.superInfos[j];
                    if (superInfo.isInterface()) {
                        MetaGenerator.this.append(implementsList, " implements ", ", ", superInfo.className);
                        continue;
                    }
                    MetaGenerator.this.append(extendsList, " extends ", ", ", superInfo.className);
                }
                if (extendsList.length() == 0) {
                    extendsList.append(" extends org.eigenbase.xom.ElementDef");
                }
            }
            out.println("\tpublic " + classDesc + " " + this.className + extendsList + implementsList);
            if (this.isAny) {
                out.println("\t\timplements org.eigenbase.xom.Any");
            }
            if (this.def instanceof MetaDef.Class) {
                out.println("\t{");
                if (this.code != null) {
                    MetaGenerator.this.writeJavaCode(out, 2, this.code);
                }
                out.println("\t}");
                out.println();
                return;
            }
            out.println("\t{");
            out.println("\t\tpublic " + this.className + "()");
            out.println("\t\t{");
            out.println("\t\t}");
            out.println();
            out.println("\t\tpublic " + this.className + "(org.eigenbase.xom.DOMWrapper _def)");
            out.println("\t\t\tthrows org.eigenbase.xom.XOMException");
            out.println("\t\t{");
            boolean mixed = this.contentModel.equals("mixed");
            if (this.allContent.length != 0 || this.allAttributes.length != 0 || this.isAny || this.isCData || this.def instanceof MetaDef.Plugin) {
                int i3;
                if (this.def instanceof MetaDef.Element && MetaGenerator.booleanValue(new Boolean[]{((MetaDef.Element)this.def).keepDef, ((MetaGenerator)MetaGenerator.this).model.defaultKeepDef, Boolean.FALSE})) {
                    out.println("\t\t\tthis._def = _def;");
                }
                out.println("\t\t\ttry {");
                if (this.def instanceof MetaDef.Plugin) {
                    out.println("\t\t\t\tdefPackage = org.eigenbase.xom.DOMElementParser.requiredDefAttribute(_def, \"defPackage\", \"org.eigenbase.xom\");");
                    out.println("\t\t\t\tdefClass = org.eigenbase.xom.DOMElementParser.requiredDefAttribute(_def, \"defClass\", null);");
                    out.println("\t\t\t\tClass _pluginClass = org.eigenbase.xom.DOMElementParser.getPluginClass(defPackage, defClass);");
                }
                out.print("\t\t\t\torg.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, ");
                if (this.def instanceof MetaDef.Plugin) {
                    out.println("\"\", _pluginClass);");
                } else {
                    if (((MetaGenerator)MetaGenerator.this).model.prefix == null) {
                        out.print("\"\", ");
                    } else {
                        out.print("\"" + ((MetaGenerator)MetaGenerator.this).model.prefix + "\", ");
                    }
                    out.println(((MetaGenerator)MetaGenerator.this).model.className + ".class);");
                }
                if (MetaGenerator.hasContentType(this.allContent, MetaDef.Array.class)) {
                    out.println("\t\t\t\torg.eigenbase.xom.NodeDef[] _tempArray;");
                }
                for (i3 = 0; i3 < this.allAttributes.length; ++i3) {
                    MetaGenerator.this.writeJavaGetAttribute(out, this.allAttributes[i3]);
                }
                if (this.def instanceof MetaDef.Plugin) {
                    MetaGenerator.this.writeJavaGetPluginContent(out, mixed);
                } else if (this.isAny) {
                    MetaGenerator.this.writeJavaGetAnyContent(out, mixed);
                } else if (this.isCData) {
                    MetaGenerator.this.writeJavaGetCDataContent(out);
                } else {
                    for (i3 = 0; i3 < this.allContent.length; ++i3) {
                        MetaGenerator.this.writeJavaGetContent(out, this.allContent[i3]);
                    }
                }
                out.println("\t\t\t} catch(org.eigenbase.xom.XOMException _ex) {");
                out.println("\t\t\t\tthrow new org.eigenbase.xom.XOMException(\"In \" + getName() + \": \" + _ex.getMessage());");
                out.println("\t\t\t}");
            }
            out.println("\t\t}");
            out.println();
            for (int j = 0; j < this.superInfos.length; ++j) {
                superInfo = this.superInfos[j];
                if (!superInfo.isInterface()) continue;
                for (int i4 = 0; i4 < superInfo.newAttributes.length; ++i4) {
                    MetaGenerator.this.writeJavaDeclareAttribute(out, superInfo.newAttributes[i4]);
                }
            }
            for (i2 = 0; i2 < this.newAttributes.length; ++i2) {
                MetaGenerator.this.writeJavaDeclareAttribute(out, this.newAttributes[i2]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDeclarePluginAttributes(out);
            }
            if (this.def instanceof MetaDef.Element && MetaGenerator.booleanValue(new Boolean[]{((MetaDef.Element)this.def).keepDef, ((MetaGenerator)MetaGenerator.this).model.defaultKeepDef, Boolean.FALSE})) {
                out.println("\t\tpublic org.eigenbase.xom.DOMWrapper _def;");
            }
            out.println();
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDeclarePluginContent(out, mixed);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDeclareAnyContent(out, mixed);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDeclareCDataContent(out);
            } else {
                for (i2 = 0; i2 < this.newContent.length; ++i2) {
                    MetaGenerator.this.writeJavaDeclareContent(out, this.newContent[i2]);
                }
            }
            out.println();
            out.println("\t\tpublic String getName()");
            out.println("\t\t{");
            out.println("\t\t\treturn \"" + this.className + "\";");
            out.println("\t\t}");
            out.println();
            out.println("\t\tpublic void display(java.io.PrintWriter _out, int _indent)");
            out.println("\t\t{");
            if (!(this.def instanceof MetaDef.Class) || this.isAny || this.isCData || this.allContent.length != 0 || this.allAttributes.length != 0) {
                out.println("\t\t\t_out.println(getName());");
            }
            for (i2 = 0; i2 < this.allAttributes.length; ++i2) {
                MetaGenerator.this.writeJavaDisplayAttribute(out, this.allAttributes[i2]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayPluginAttributes(out);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayPluginContent(out);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayAnyContent(out);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayCDataContent(out);
            } else {
                for (i2 = 0; i2 < this.allContent.length; ++i2) {
                    MetaGenerator.this.writeJavaDisplayContent(out, this.allContent[i2]);
                }
            }
            out.println("\t\t}");
            out.println("\t\tpublic void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)");
            out.println("\t\t{");
            out.println("\t\t\t_out.beginTag(\"" + this.tagName + "\", new org.eigenbase.xom.XMLAttrVector()");
            for (i2 = 0; i2 < this.allAttributes.length; ++i2) {
                MetaGenerator.this.writeJavaDisplayXMLAttribute(out, this.allAttributes[i2]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayXMLPluginAttributes(out);
            }
            out.println("\t\t\t\t);");
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayXMLPluginContent(out);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayXMLAnyContent(out);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayXMLCDataContent(out);
            } else {
                for (i2 = 0; i2 < this.allContent.length; ++i2) {
                    MetaGenerator.this.writeJavaDisplayXMLContent(out, this.allContent[i2]);
                }
            }
            out.println("\t\t\t_out.endTag(\"" + this.tagName + "\");");
            out.println("\t\t}");
            out.println("\t\tpublic boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)");
            out.println("\t\t{");
            if (this.allAttributes.length > 0 || this.allContent.length > 0 || this.isAny || this.isCData || this.def instanceof MetaDef.Plugin) {
                out.println("\t\t\t" + this.className + " _cother = (" + this.className + ")_other;");
            }
            int[] diffCount = new int[]{0};
            for (i = 0; i < this.newAttributes.length; ++i) {
                MetaGenerator.this.writeJavaDisplayDiffAttribute(out, diffCount, this.allAttributes[i]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayDiffPluginAttributes(out, diffCount);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayDiffPluginContent(out, diffCount);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayDiffAnyContent(out, diffCount);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayDiffCDataContent(out, diffCount);
            } else {
                for (i = 0; i < this.allContent.length; ++i) {
                    MetaGenerator.this.writeJavaDisplayDiffContent(out, diffCount, this.allContent[i]);
                }
            }
            out.println("\t\t\treturn " + (diffCount[0] > 0 ? "_diff" : "true") + ";");
            out.println("\t\t}");
            if (this.code != null) {
                MetaGenerator.this.writeJavaCode(out, 2, this.code);
            }
            out.println("\t}");
            out.println();
        }
    }
}

