/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Cache;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EncodingDetector;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.Logger;
import au.id.jericho.lib.html.LoggerDisabled;
import au.id.jericho.lib.html.LoggerFactory;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.RowColumnVector;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.SourceFormatter;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.Util;
import au.id.jericho.lib.html.WriterLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Source
extends Segment {
    final String string;
    private String documentSpecifiedEncoding = "";
    private String encoding = "";
    private String encodingSpecificationInfo;
    private String preliminaryEncodingInfo = null;
    private String newLine = "";
    private ParseText parseText = null;
    private OutputDocument parseTextOutputDocument = null;
    Logger logger;
    private RowColumnVector[] rowColumnVectorCacheArray = null;
    final Cache cache = new Cache(this);
    boolean useAllTypesCache = true;
    boolean useSpecialTypesCache = true;
    int[] fullSequentialParseData = null;
    Tag[] allTagsArray = null;
    List allTags = null;
    List allStartTags = null;
    private List allElements = null;
    private static String lastNewLine = null;
    private static final String UNINITIALISED = "";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    static final String PACKAGE_NAME = "net.htmlparser.jericho";

    public Source(CharSequence text) {
        super(text.length());
        this.string = ((Object)text).toString();
        this.setLogger(Source.newLogger());
    }

    private Source(EncodingDetector encodingDetector) throws IOException {
        this(Source.getString(encodingDetector));
        this.encoding = encodingDetector.getEncoding();
        this.encodingSpecificationInfo = encodingDetector.getEncodingSpecificationInfo();
        this.preliminaryEncodingInfo = encodingDetector.getPreliminaryEncoding() + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo();
    }

    Source(Reader reader, String encoding) throws IOException {
        this(Util.getString(reader));
        if (encoding != null) {
            this.encoding = encoding;
            this.encodingSpecificationInfo = "InputStreamReader.getEncoding() of constructor argument";
        }
    }

    public Source(Reader reader) throws IOException {
        this(reader, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null);
    }

    public Source(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream));
    }

    public Source(URL url) throws IOException {
        this(new EncodingDetector(url.openConnection()));
    }

    public Source(URLConnection urlConnection) throws IOException {
        this(new EncodingDetector(urlConnection));
    }

    private String setEncoding(String encoding, String encodingSpecificationInfo) {
        if (this.encoding == UNINITIALISED) {
            this.encoding = encoding;
            this.encodingSpecificationInfo = encodingSpecificationInfo;
        }
        return encoding;
    }

    public String getDocumentSpecifiedEncoding() {
        String contentValue;
        StartTag contentTypeMetaTag;
        if (this.documentSpecifiedEncoding != UNINITIALISED) {
            return this.documentSpecifiedEncoding;
        }
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            this.documentSpecifiedEncoding = ((StartTag)xmlDeclarationTag).getAttributeValue("encoding");
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, xmlDeclarationTag.toString());
            }
        }
        if ((contentTypeMetaTag = this.findNextStartTag(0, "http-equiv", "Content-Type", false)) != null && (contentValue = contentTypeMetaTag.getAttributeValue("content")) != null) {
            this.documentSpecifiedEncoding = Source.getCharsetParameterFromHttpHeaderValue(contentValue);
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, contentTypeMetaTag.toString());
            }
        }
        return this.setEncoding(null, "No encoding specified in document");
    }

    public String getEncoding() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncodingInfo() {
        return this.preliminaryEncodingInfo;
    }

    public boolean isXML() {
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        Tag doctypeTag = this.findNextTag(0, StartTagType.DOCTYPE_DECLARATION);
        return doctypeTag != null && this.getParseText().indexOf("xhtml", doctypeTag.begin, doctypeTag.end) != -1;
    }

    public String getNewLine() {
        if (this.newLine != UNINITIALISED) {
            return this.newLine;
        }
        for (int i = 0; i < this.end; ++i) {
            char ch = this.string.charAt(i);
            if (ch == '\n') {
                lastNewLine = LF;
                this.newLine = LF;
                return LF;
            }
            if (ch != '\r') continue;
            lastNewLine = ++i < this.end && this.string.charAt(i) == '\n' ? CRLF : CR;
            this.newLine = lastNewLine;
            return lastNewLine;
        }
        this.newLine = null;
        return null;
    }

    String getBestGuessNewLine() {
        String newLine = this.getNewLine();
        if (newLine != null) {
            return newLine;
        }
        if (lastNewLine != null) {
            return lastNewLine;
        }
        return Config.NewLine;
    }

    public int getRow(int pos) {
        return this.getRowColumnVector(pos).getRow();
    }

    public int getColumn(int pos) {
        return this.getRowColumnVector(pos).getColumn();
    }

    public RowColumnVector getRowColumnVector(int pos) {
        if (pos > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rowColumnVectorCacheArray == null) {
            this.rowColumnVectorCacheArray = RowColumnVector.getCacheArray(this);
        }
        return RowColumnVector.get(this.rowColumnVectorCacheArray, pos);
    }

    public String toString() {
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] fullSequentialParse() {
        if (this.allTagsArray != null) {
            return this.allTagsArray;
        }
        boolean assumeNoNestedTags = false;
        if (this.cache.getTagCount() != 0) {
            this.cache.clear();
        }
        boolean useAllTypesCacheSave = this.useAllTypesCache;
        try {
            this.useAllTypesCache = false;
            this.useSpecialTypesCache = false;
            Tag[] tagArray = Tag.parseAll(this, false);
            return tagArray;
        }
        finally {
            this.useAllTypesCache = useAllTypesCacheSave;
            this.useSpecialTypesCache = true;
        }
    }

    public List getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag childStartTag;
                if (this.allTags == null) {
                    this.fullSequentialParse();
                }
                this.childElements = new ArrayList();
                int pos = 0;
                while ((childStartTag = this.source.findNextStartTag(pos)) != null) {
                    if (childStartTag.getTagType().isServerTag()) {
                        pos = childStartTag.end;
                        continue;
                    }
                    Element childElement = childStartTag.getElement();
                    childElement.getChildElements(0);
                    if (childElement.parentElement == Element.NOT_CACHED) {
                        childElement.parentElement = null;
                        this.childElements.add(childElement);
                    }
                    pos = childElement.end;
                }
            }
        }
        return this.childElements;
    }

    public SourceFormatter getSourceFormatter() {
        return new SourceFormatter(this);
    }

    public List findAllTags() {
        if (this.allTags == null) {
            this.fullSequentialParse();
        }
        return this.allTags;
    }

    public List findAllStartTags() {
        if (this.allStartTags == null) {
            List allTags = this.findAllTags();
            this.allStartTags = new ArrayList(allTags.size());
            Iterator i = allTags.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!(next instanceof StartTag)) continue;
                this.allStartTags.add(next);
            }
        }
        return this.allStartTags;
    }

    public List findAllElements() {
        if (this.allElements == null) {
            List allStartTags = this.findAllStartTags();
            if (allStartTags.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            this.allElements = new ArrayList(allStartTags.size());
            Iterator i = allStartTags.iterator();
            while (i.hasNext()) {
                StartTag startTag = (StartTag)i.next();
                this.allElements.add(startTag.getElement());
            }
        }
        return this.allElements;
    }

    public Element getElementById(String id) {
        StartTag startTag = this.findNextStartTag(0, "id", id, true);
        return startTag == null ? null : startTag.getElement();
    }

    public final Tag getTagAt(int pos) {
        return Tag.getTagAt(this, pos, false);
    }

    public Tag findPreviousTag(int pos) {
        return Tag.findPreviousTag(this, pos);
    }

    public Tag findPreviousTag(int pos, TagType tagType) {
        return Tag.findPreviousTag(this, pos, tagType);
    }

    public Tag findNextTag(int pos) {
        return Tag.findNextTag(this, pos);
    }

    Tag findNextNonServerTag(int pos) {
        Tag tag;
        while ((tag = this.findNextTag(pos)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            pos = tag.end;
        }
        return null;
    }

    Tag findPreviousNonServerTag(int pos) {
        Tag tag;
        while ((tag = this.findPreviousTag(pos - 1)) != null) {
            if (!tag.getTagType().isServerTag()) {
                return tag;
            }
            pos = tag.begin - 1;
        }
        return null;
    }

    public Tag findNextTag(int pos, TagType tagType) {
        return Tag.findNextTag(this, pos, tagType);
    }

    public Tag findEnclosingTag(int pos) {
        return this.findEnclosingTag(pos, null);
    }

    public Tag findEnclosingTag(int pos, TagType tagType) {
        Tag tag = this.findPreviousTag(pos, tagType);
        if (tag == null || tag.end <= pos) {
            return null;
        }
        return tag;
    }

    public Element findNextElement(int pos) {
        StartTag startTag = this.findNextStartTag(pos);
        return startTag == null ? null : startTag.getElement();
    }

    public Element findNextElement(int pos, String name) {
        StartTag startTag = this.findNextStartTag(pos, name);
        return startTag == null ? null : startTag.getElement();
    }

    public Element findNextElement(int pos, String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = this.findNextStartTag(pos, attributeName, value, valueCaseSensitive);
        return startTag == null ? null : startTag.getElement();
    }

    public StartTag findPreviousStartTag(int pos) {
        return StartTag.findPrevious(this, pos);
    }

    public StartTag findPreviousStartTag(int pos, String name) {
        return this.findPreviousStartTag(pos, name, StartTagType.NORMAL);
    }

    public StartTag findPreviousStartTag(int pos, String name, StartTagType startTagType) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.findPrevious(this, pos, name, startTagType);
    }

    public StartTag findNextStartTag(int pos) {
        return StartTag.findNext(this, pos);
    }

    public StartTag findNextStartTag(int pos, String name) {
        return this.findNextStartTag(pos, name, StartTagType.NORMAL);
    }

    public StartTag findNextStartTag(int pos, String name, StartTagType startTagType) {
        if (name != null) {
            name = name.toLowerCase();
        }
        return StartTag.findNext(this, pos, name, startTagType);
    }

    public StartTag findNextStartTag(int pos, String attributeName, String value, boolean valueCaseSensitive) {
        return StartTag.findNext(this, pos, attributeName, value, valueCaseSensitive);
    }

    public EndTag findPreviousEndTag(int pos) {
        return EndTag.findPrevious(this, pos);
    }

    public EndTag findPreviousEndTag(int pos, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findPrevious(this, pos, name.toLowerCase(), EndTagType.NORMAL);
    }

    public EndTag findNextEndTag(int pos) {
        return EndTag.findNext(this, pos);
    }

    public EndTag findNextEndTag(int pos, String name) {
        return this.findNextEndTag(pos, name, EndTagType.NORMAL);
    }

    public EndTag findNextEndTag(int pos, String name, EndTagType endTagType) {
        if (name == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findNext(this, pos, name.toLowerCase(), endTagType);
    }

    public Element findEnclosingElement(int pos) {
        return this.findEnclosingElement(pos, null);
    }

    public Element findEnclosingElement(int pos, String name) {
        int startBefore = pos;
        if (name != null) {
            name = name.toLowerCase();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        StartTag startTag;
        while ((startTag = StartTag.findPrevious(this, startBefore, name, StartTagType.NORMAL, isXMLTagName)) != null) {
            Element element = startTag.getElement();
            if (pos < element.end) {
                return element;
            }
            startBefore = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference findPreviousCharacterReference(int pos) {
        return CharacterReference.findPrevious(this, pos);
    }

    public CharacterReference findNextCharacterReference(int pos) {
        return CharacterReference.findNext(this, pos);
    }

    public int findNameEnd(int pos) {
        if (!Tag.isXMLNameStartChar(this.string.charAt(pos++))) {
            return -1;
        }
        while (pos < this.string.length() && Tag.isXMLNameChar(this.string.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public Attributes parseAttributes(int pos, int maxEnd) {
        return this.parseAttributes(pos, maxEnd, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int pos, int maxEnd, int maxErrorCount) {
        return Attributes.construct(this, pos, maxEnd, maxErrorCount);
    }

    public void ignoreWhenParsing(int begin, int end) {
        if (this.wasFullSequentialParseCalled()) {
            throw new IllegalStateException("ignoreWhenParsing can not be used after fullSequentialParse() has been called");
        }
        if (this.parseTextOutputDocument == null) {
            this.parseTextOutputDocument = new OutputDocument(this.getParseText());
            this.parseText = null;
        }
        this.parseTextOutputDocument.replaceWithSpaces(begin, end);
    }

    public void ignoreWhenParsing(Collection segments) {
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            ((Segment)i.next()).ignoreWhenParsing();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : LoggerDisabled.INSTANCE;
    }

    public Logger getLogger() {
        return this.logger != LoggerDisabled.INSTANCE ? this.logger : null;
    }

    public void clearCache() {
        this.cache.clear();
        this.allTagsArray = null;
        this.allTags = null;
        this.allStartTags = null;
        this.allElements = null;
    }

    public String getCacheDebugInfo() {
        return this.cache.toString();
    }

    List getParsedTags() {
        ArrayList list = new ArrayList();
        Iterator i = this.cache.getTagIterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public final ParseText getParseText() {
        if (this.parseText == null) {
            if (this.parseTextOutputDocument != null) {
                this.parseText = new ParseText(this.parseTextOutputDocument.toString());
                this.parseTextOutputDocument = null;
            } else {
                this.parseText = new ParseText(this.string);
            }
        }
        return this.parseText;
    }

    public CharStreamSource indent(String indentString, boolean tidyTags, boolean collapseWhiteSpace, boolean indentAllElements) {
        return this.getSourceFormatter().setIndentString(indentString).setTidyTags(tidyTags).setCollapseWhiteSpace(collapseWhiteSpace).setIndentAllElements(indentAllElements);
    }

    public void setLogWriter(Writer writer) {
        this.setLogger(new WriterLogger(writer));
    }

    public Writer getLogWriter() {
        if (!(this.logger instanceof WriterLogger)) {
            return null;
        }
        return ((WriterLogger)this.getLogger()).getWriter();
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public boolean isLoggingEnabled() {
        return this.logger.isInfoEnabled();
    }

    static String getCharsetParameterFromHttpHeaderValue(String httpHeaderValue) {
        int charsetParameterPos = httpHeaderValue.toLowerCase().indexOf("charset=");
        if (charsetParameterPos == -1) {
            return null;
        }
        int charsetBegin = charsetParameterPos + 8;
        int charsetEnd = httpHeaderValue.indexOf(59, charsetBegin);
        String charset = charsetEnd == -1 ? httpHeaderValue.substring(charsetBegin) : httpHeaderValue.substring(charsetBegin, charsetEnd);
        return charset.trim();
    }

    static Logger newLogger() {
        return LoggerFactory.getLogger(PACKAGE_NAME);
    }

    private static String getString(EncodingDetector encodingDetector) throws IOException {
        try {
            return Util.getString(encodingDetector.openReader());
        }
        catch (IOException ex) {
            try {
                Logger logger = Source.newLogger();
                if (logger.isInfoEnabled()) {
                    logger.info("IOException constructing encoded source. Encoding: " + encodingDetector.getEncoding() + " - " + encodingDetector.getEncodingSpecificationInfo() + ". PreliminaryEncoding: " + encodingDetector.getPreliminaryEncoding() + " - " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    private boolean wasFullSequentialParseCalled() {
        return this.allTagsArray != null;
    }
}

