/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.nodoc.SequentialListSegment;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public final class Attributes
extends SequentialListSegment {
    private final LinkedList attributeList;
    private static final int AFTER_TAG_NAME = 0;
    private static final int BETWEEN_ATTRIBUTES = 1;
    private static final int IN_NAME = 2;
    private static final int AFTER_NAME = 3;
    private static final int START_VALUE = 4;
    private static final int IN_VALUE = 5;
    private static final int AFTER_VALUE_FINAL_QUOTE = 6;
    private static int defaultMaxErrorCount = 2;

    private Attributes(Source source, int begin, int end, LinkedList attributeList) {
        super(source, begin, end);
        this.attributeList = attributeList;
    }

    static Attributes construct(Source source, int startTagBegin, StartTagType startTagType, String tagName) {
        return Attributes.construct(source, "StartTag", 0, startTagBegin, -1, -1, startTagType, tagName, defaultMaxErrorCount);
    }

    static Attributes construct(Source source, int startTagBegin, int attributesBegin, int maxEnd, StartTagType startTagType, String tagName, int maxErrorCount) {
        return Attributes.construct(source, "Attributes for StartTag", 1, startTagBegin, attributesBegin, maxEnd, startTagType, tagName, maxErrorCount);
    }

    static Attributes construct(Source source, int begin, int maxEnd, int maxErrorCount) {
        return Attributes.construct(source, "Attributes", 1, begin, -1, maxEnd, StartTagType.NORMAL, null, maxErrorCount);
    }

    /*
     * Unable to fully structure code
     */
    private static Attributes construct(Source source, String logType, int state, int logBegin, int attributesBegin, int maxEnd, StartTagType startTagType, String tagName, int maxErrorCount) {
        isClosingSlashIgnored = false;
        if (tagName != null) {
            if (attributesBegin == -1) {
                attributesBegin = logBegin + 1 + tagName.length();
            }
            if (startTagType == StartTagType.NORMAL && HTMLElements.isClosingSlashIgnored(tagName)) {
                isClosingSlashIgnored = true;
            }
        } else {
            attributesBegin = logBegin;
        }
        attributesEnd = attributesBegin;
        attributeList = new LinkedList<Attribute>();
        parseText = source.getParseText();
        i = attributesBegin;
        quote = ' ';
        nameSegment = null;
        key = null;
        currentBegin = -1;
        isTerminatingCharacter = false;
        errorCount = 0;
        try {
            while (!isTerminatingCharacter) {
                if (i == maxEnd || startTagType.atEndOfAttributes(source, i, isClosingSlashIgnored)) {
                    isTerminatingCharacter = true;
                }
                if ((ch = parseText.charAt(i)) == '<' && (interlopingTag = source.getTagAt(i)) != null && interlopingTag.getTagType().isServerTag()) {
                    i = interlopingTag.end;
                    if (state != 4) continue;
                    state = 5;
                    continue;
                }
                switch (state) {
                    case 5: {
                        if (!isTerminatingCharacter && ch != quote && (quote != 32 || !Segment.isWhiteSpace(ch))) ** GOTO lbl52
                        if (quote != ' ') ** GOTO lbl34
                        valueSegment = valueSegmentIncludingQuotes = new Segment(source, currentBegin, i);
                        ** GOTO lbl47
lbl34:
                        // 1 sources

                        if (!isTerminatingCharacter) ** GOTO lbl45
                        if (i == maxEnd) {
                            if (source.logger.isInfoEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "terminated in the middle of a quoted attribute value", i);
                            }
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i);
                        } else {
                            isTerminatingCharacter = false;
                            break;
lbl45:
                            // 1 sources

                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i + 1);
                        }
lbl47:
                        // 3 sources

                        attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegmentIncludingQuotes));
                        attributesEnd = valueSegmentIncludingQuotes.getEnd();
                        state = 1;
                        break;
lbl52:
                        // 1 sources

                        if (ch != '<' || quote != 32) break;
                        if (source.logger.isInfoEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character in unquoted attribute value", i);
                        }
                        return null;
                    }
                    case 2: {
                        if (isTerminatingCharacter || ch == '=' || Segment.isWhiteSpace(ch)) {
                            nameSegment = new Segment(source, currentBegin, i);
                            key = nameSegment.toString().toLowerCase();
                            if (isTerminatingCharacter) {
                                attributeList.add(new Attribute(source, key, nameSegment));
                                attributesEnd = i;
                                break;
                            }
                            state = ch == '=' ? 4 : 3;
                            break;
                        }
                        if (Tag.isXMLNameChar(ch)) break;
                        if (ch == '<') {
                            if (source.logger.isInfoEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character in attribute name", i);
                            }
                            return null;
                        }
                        if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                        if (source.logger.isInfoEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "contains attribute name with invalid character", i);
                        }
                        if (!Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) break;
                        return null;
                    }
                    case 3: {
                        if (isTerminatingCharacter || ch != '=' && !Segment.isWhiteSpace(ch)) {
                            attributeList.add(new Attribute(source, key, nameSegment));
                            attributesEnd = nameSegment.getEnd();
                            if (isTerminatingCharacter) break;
                            state = 1;
                            --i;
                            break;
                        }
                        if (ch == '=') {
                            state = 4;
                            break;
                        }
                        if (ch != '<') break;
                        if (source.logger.isInfoEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character after attribute name", i);
                        }
                        return null;
                    }
                    case 1: {
                        if (isTerminatingCharacter) break;
                        if (Segment.isWhiteSpace(ch)) {
                            quote = ' ';
                            break;
                        }
                        if (quote != ' ' && source.logger.isInfoEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "has missing whitespace after quoted attribute value", i);
                        }
                        if (!Tag.isXMLNameStartChar(ch)) {
                            if (ch == '<') {
                                if (source.logger.isInfoEnabled()) {
                                    Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character", i);
                                }
                                return null;
                            }
                            if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                            if (startTagType == StartTagType.NORMAL && startTagType.atEndOfAttributes(source, i, false)) {
                                if (!source.logger.isInfoEnabled()) break;
                                Attributes.log(source, logType, tagName, logBegin, "contains a '/' character before the closing '>', which is ignored because tags of this name cannot be empty-element tags");
                                break;
                            }
                            if (source.logger.isInfoEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "contains attribute name with invalid first character", i);
                            }
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                        }
                        state = 2;
                        currentBegin = i;
                        break;
                    }
                    case 4: {
                        currentBegin = i;
                        if (isTerminatingCharacter) {
                            if (source.logger.isInfoEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "has missing attribute value after '=' sign", i);
                            }
                            valueSegment = new Segment(source, i, i);
                            attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegment));
                            attributesEnd = i;
                            state = 1;
                            break;
                        }
                        if (ch == '\'' || ch == '\"') {
                            quote = ch;
                            ++currentBegin;
                        } else {
                            if (Segment.isWhiteSpace(ch)) break;
                            if (ch == '<') {
                                if (source.logger.isInfoEnabled()) {
                                    Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character at the start of an attribute value", i);
                                }
                                return null;
                            }
                            quote = ' ';
                        }
                        state = 5;
                        break;
                    }
                    case 0: {
                        if (isTerminatingCharacter) break;
                        if (!Segment.isWhiteSpace(ch)) {
                            if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                            if (source.logger.isInfoEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "rejected because the name contains an invalid character", i);
                            }
                            return null;
                        }
                        state = 1;
                    }
                }
                ++i;
            }
            return new Attributes(source, attributesBegin, attributesEnd, attributeList);
        }
        catch (IndexOutOfBoundsException ex) {
            if (source.logger.isInfoEnabled()) {
                Attributes.log(source, logType, tagName, logBegin, "rejected because it has no closing '>' character");
            }
            return null;
        }
    }

    private static boolean reachedMaxErrorCount(int errorCount, Source source, String logType, String tagName, int logBegin, int maxErrorCount) {
        if (errorCount <= maxErrorCount) {
            return false;
        }
        if (source.logger.isInfoEnabled()) {
            Attributes.log(source, logType, tagName, logBegin, "rejected because it contains too many errors");
        }
        return true;
    }

    private static boolean isInvalidEmptyElementTag(StartTagType startTagType, Source source, int i, String logType, String tagName, int logBegin) {
        if (startTagType != StartTagType.NORMAL || !startTagType.atEndOfAttributes(source, i, false)) {
            return false;
        }
        if (source.logger.isInfoEnabled()) {
            Attributes.log(source, logType, tagName, logBegin, "contains a '/' character before the closing '>', which is ignored because tags of this name cannot be empty-element tags");
        }
        return true;
    }

    public Attribute get(String name) {
        if (this.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            Attribute attribute = (Attribute)this.get(i);
            if (!attribute.getKey().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    public String getValue(String name) {
        Attribute attribute = this.get(name);
        return attribute == null ? null : attribute.getValue();
    }

    String getRawValue(String name) {
        Attribute attribute = this.get(name);
        return attribute == null || !attribute.hasValue() ? null : attribute.getValueSegment().toString();
    }

    public int getCount() {
        return this.attributeList.size();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.attributeList.listIterator(index);
    }

    public Map populateMap(Map attributesMap, boolean convertNamesToLowerCase) {
        ListIterator i = this.listIterator(0);
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            attributesMap.put(convertNamesToLowerCase ? attribute.getKey() : attribute.getName(), attribute.getValue());
        }
        return attributesMap;
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attributes ").append(super.getDebugInfo()).append(": ");
        if (this.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append(Config.NewLine);
            ListIterator i = this.listIterator(0);
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                sb.append("  ").append(attribute.getDebugInfo());
            }
        }
        return sb.toString();
    }

    public static int getDefaultMaxErrorCount() {
        return defaultMaxErrorCount;
    }

    public static void setDefaultMaxErrorCount(int value) {
        defaultMaxErrorCount = value;
    }

    public static String generateHTML(Map attributesMap) {
        StringWriter stringWriter = new StringWriter();
        try {
            Attributes.appendHTML(stringWriter, attributesMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    static void appendHTML(Writer writer, Map attributesMap) throws IOException {
        Iterator i = attributesMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Attribute.appendHTML(writer, (CharSequence)((String)entry.getKey()), (CharSequence)entry.getValue());
        }
    }

    StringBuffer appendTidy(StringBuffer sb, Tag nextTag) {
        ListIterator i = this.listIterator(0);
        while (i.hasNext()) {
            nextTag = ((Attribute)i.next()).appendTidy(sb, nextTag);
        }
        return sb;
    }

    Map getMap(boolean convertNamesToLowerCase) {
        return this.populateMap(new LinkedHashMap(this.getCount() * 2, 1.0f), convertNamesToLowerCase);
    }

    private static void log(Source source, String part1, CharSequence part2, int begin, String part3, int pos) {
        source.logger.info(source.getRowColumnVector(pos).appendTo(source.getRowColumnVector(begin).appendTo(new StringBuffer(200).append(part1).append(' ').append((Object)part2).append(" at ")).append(' ').append(part3).append(" at position ")).toString());
    }

    private static void log(Source source, String part1, CharSequence part2, int begin, String part3) {
        source.logger.info(source.getRowColumnVector(begin).appendTo(new StringBuffer(200).append(part1).append(' ').append((Object)part2).append(" at ")).append(' ').append(part3).toString());
    }
}

