/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Cache;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EncodedSource;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.Indent;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.RowColumnVector;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Source
extends Segment {
    final String string;
    String documentSpecifiedEncoding = "";
    String encoding = "";
    String encodingSpecificationInfo;
    private ParseText parseText = null;
    private OutputDocument parseTextOutputDocument = null;
    private Writer logWriter = null;
    private RowColumnVector[] rowColumnVectorCacheArray = null;
    final Cache cache = new Cache(this);
    boolean useAllTypesCache = true;
    boolean useSpecialTypesCache = true;
    int endOfLastTagIgnoringEnclosedMarkup = -1;
    Tag[] allTagsArray = null;
    List allTags = null;
    List allStartTags = null;
    private List allElements = null;
    private static final String UNINITIALISED = "";

    public Source(CharSequence text) {
        super(text.length());
        this.string = ((Object)text).toString();
    }

    private Source(EncodedSource encodedSource) throws IOException {
        this(Util.getString(encodedSource.Reader));
        this.encoding = encodedSource.Encoding;
        this.encodingSpecificationInfo = encodedSource.EncodingSpecificationInfo;
    }

    private Source(Reader reader, String inputStreamReaderEncoding) throws IOException {
        this(Util.getString(reader));
        if (inputStreamReaderEncoding != null) {
            this.encoding = inputStreamReaderEncoding;
            this.encodingSpecificationInfo = "InputStreamReader.getEncoding() of constructor argument";
        }
    }

    public Source(Reader reader) throws IOException {
        this(reader, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null);
    }

    public Source(InputStream inputStream) throws IOException {
        this(EncodedSource.construct(inputStream, null));
    }

    public Source(URL url) throws IOException {
        this(EncodedSource.construct(url));
    }

    private String setEncoding(String encoding, String encodingSpecificationInfo) {
        if (this.encoding == UNINITIALISED) {
            this.encoding = encoding;
            this.encodingSpecificationInfo = encodingSpecificationInfo;
        }
        return encoding;
    }

    public String getDocumentSpecifiedEncoding() {
        String contentValue;
        StartTag contentTypeMetaTag;
        if (this.documentSpecifiedEncoding != UNINITIALISED) {
            return this.documentSpecifiedEncoding;
        }
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            this.documentSpecifiedEncoding = ((StartTag)xmlDeclarationTag).getAttributeValue("encoding");
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, xmlDeclarationTag.toString());
            }
        }
        if ((contentTypeMetaTag = this.findNextStartTag(0, "http-equiv", "Content-Type", false)) != null && (contentValue = contentTypeMetaTag.getAttributeValue("content")) != null) {
            this.documentSpecifiedEncoding = Source.getCharsetParameterFromHttpHeaderValue(contentValue);
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, contentTypeMetaTag.toString());
            }
        }
        return this.setEncoding(null, "no encoding specified in document");
    }

    public String getEncoding() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encodingSpecificationInfo;
    }

    public boolean isXML() {
        Tag xmlDeclarationTag = this.getTagAt(0);
        if (xmlDeclarationTag != null && xmlDeclarationTag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        Tag doctypeTag = this.findNextTag(0, StartTagType.DOCTYPE_DECLARATION);
        if (doctypeTag != null && this.getParseText().indexOf("xhtml", doctypeTag.begin, doctypeTag.end) != -1) {
            return true;
        }
        return this.findNextStartTag(0, "html") == null;
    }

    public int getRow(int pos) {
        return this.getRowColumnVector(pos).getRow();
    }

    public int getColumn(int pos) {
        return this.getRowColumnVector(pos).getColumn();
    }

    public RowColumnVector getRowColumnVector(int pos) {
        if (pos > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rowColumnVectorCacheArray == null) {
            this.rowColumnVectorCacheArray = RowColumnVector.getCacheArray(this);
        }
        return RowColumnVector.get(this.rowColumnVectorCacheArray, pos);
    }

    public String toString() {
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] fullSequentialParse() {
        boolean assumeNoNestedTags = false;
        if (this.cache.getTagCount() != 0) {
            this.cache.clear();
        }
        boolean useAllTypesCacheSave = this.useAllTypesCache;
        try {
            this.useAllTypesCache = false;
            this.useSpecialTypesCache = false;
            Tag[] tagArray = Tag.parseAll(this, false);
            Object var5_4 = null;
            this.useAllTypesCache = useAllTypesCacheSave;
            this.useSpecialTypesCache = true;
            this.endOfLastTagIgnoringEnclosedMarkup = -1;
            return tagArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.useAllTypesCache = useAllTypesCacheSave;
            this.useSpecialTypesCache = true;
            this.endOfLastTagIgnoringEnclosedMarkup = -1;
            throw throwable;
        }
    }

    public List getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag childStartTag;
                if (this.allTags == null) {
                    this.log("NOTE: Calling Source.fullSequentialParse() can significantly improve the performance of this operation");
                }
                this.childElements = new ArrayList();
                int pos = 0;
                while ((childStartTag = this.source.findNextStartTag(pos)) != null) {
                    if (childStartTag.getTagType().isServerTag()) {
                        pos = childStartTag.end;
                        continue;
                    }
                    Element childElement = childStartTag.getElement();
                    childElement.parentElement = null;
                    this.childElements.add(childElement);
                    childElement.getChildElements(0);
                    pos = childElement.end;
                }
            }
        }
        return this.childElements;
    }

    public List findAllTags() {
        if (this.allTags == null) {
            this.log("NOTE: Calling Source.fullSequentialParse() can significantly improve the performance of this operation");
            this.allTags = super.findAllTags();
        }
        return this.allTags;
    }

    public List findAllStartTags() {
        if (this.allStartTags == null) {
            List allTags = this.findAllTags();
            this.allStartTags = new ArrayList(allTags.size());
            Iterator i = allTags.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!(next instanceof StartTag)) continue;
                this.allStartTags.add(next);
            }
        }
        return this.allStartTags;
    }

    public List findAllElements() {
        if (this.allElements == null) {
            List allStartTags = this.findAllStartTags();
            if (allStartTags.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            this.allElements = new ArrayList(allStartTags.size());
            Iterator i = allStartTags.iterator();
            while (i.hasNext()) {
                StartTag startTag = (StartTag)i.next();
                this.allElements.add(startTag.getElement());
            }
        }
        return this.allElements;
    }

    public Element getElementById(String id) {
        StartTag startTag = this.findNextStartTag(0, "id", id, true);
        return startTag == null ? null : startTag.getElement();
    }

    public final Tag getTagAt(int pos) {
        return Tag.getTagAt(this, pos);
    }

    public Tag findPreviousTag(int pos) {
        return Tag.findPreviousOrNextTag(this, pos, true);
    }

    public Tag findPreviousTag(int pos, TagType tagType) {
        return Tag.findPreviousOrNextTag(this, pos, tagType, true);
    }

    public Tag findNextTag(int pos) {
        return Tag.findPreviousOrNextTag(this, pos, false);
    }

    public Tag findNextTag(int pos, TagType tagType) {
        return Tag.findPreviousOrNextTag(this, pos, tagType, false);
    }

    public Tag findEnclosingTag(int pos) {
        return this.findEnclosingTag(pos, null);
    }

    public Tag findEnclosingTag(int pos, TagType tagType) {
        Tag tag = this.findPreviousTag(pos, tagType);
        if (tag == null || tag.end <= pos) {
            return null;
        }
        return tag;
    }

    public Element findNextElement(int pos) {
        StartTag startTag = this.findNextStartTag(pos);
        return startTag == null ? null : startTag.getElement();
    }

    public Element findNextElement(int pos, String name) {
        StartTag startTag = this.findNextStartTag(pos, name);
        return startTag == null ? null : startTag.getElement();
    }

    public StartTag findPreviousStartTag(int pos) {
        return StartTag.findPreviousOrNext(this, pos, true);
    }

    public StartTag findPreviousStartTag(int pos, String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        return StartTag.findPreviousOrNext(this, pos, name, isXMLTagName, true);
    }

    public StartTag findNextStartTag(int pos) {
        return StartTag.findPreviousOrNext(this, pos, false);
    }

    public StartTag findNextStartTag(int pos, String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        return StartTag.findPreviousOrNext(this, pos, name, isXMLTagName, false);
    }

    public StartTag findNextStartTag(int pos, String attributeName, String value, boolean valueCaseSensitive) {
        return StartTag.findNext(this, pos, attributeName, value, valueCaseSensitive);
    }

    public EndTag findPreviousEndTag(int pos) {
        return EndTag.findPreviousOrNext(this, pos, true);
    }

    public EndTag findPreviousEndTag(int pos, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findPreviousOrNext(this, pos, name.toLowerCase(), EndTagType.NORMAL, true);
    }

    public EndTag findNextEndTag(int pos) {
        return EndTag.findPreviousOrNext(this, pos, false);
    }

    public EndTag findNextEndTag(int pos, String name) {
        return this.findNextEndTag(pos, name, EndTagType.NORMAL);
    }

    public EndTag findNextEndTag(int pos, String name, EndTagType endTagType) {
        if (name == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findPreviousOrNext(this, pos, name.toLowerCase(), endTagType, false);
    }

    public Element findEnclosingElement(int pos) {
        return this.findEnclosingElement(pos, null);
    }

    public Element findEnclosingElement(int pos, String name) {
        int startBefore = pos;
        if (name != null) {
            name = name.toLowerCase();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        StartTag startTag;
        while ((startTag = StartTag.findPreviousOrNext(this, startBefore, name, isXMLTagName, true)) != null) {
            Element element = startTag.getElement();
            if (pos < element.end) {
                return element;
            }
            startBefore = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference findPreviousCharacterReference(int pos) {
        return CharacterReference.findPreviousOrNext(this, pos, true);
    }

    public CharacterReference findNextCharacterReference(int pos) {
        return CharacterReference.findPreviousOrNext(this, pos, false);
    }

    public int findNameEnd(int pos) {
        if (!Tag.isXMLNameStartChar(this.string.charAt(pos++))) {
            return -1;
        }
        while (pos < this.string.length() && Tag.isXMLNameChar(this.string.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public Attributes parseAttributes(int pos, int maxEnd) {
        return this.parseAttributes(pos, maxEnd, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int pos, int maxEnd, int maxErrorCount) {
        return Attributes.construct(this, pos, maxEnd, maxErrorCount);
    }

    public void ignoreWhenParsing(int begin, int end) {
        if (this.parseTextOutputDocument == null) {
            this.parseTextOutputDocument = new OutputDocument(this.getParseText());
            this.parseText = null;
        }
        this.parseTextOutputDocument.replaceWithSpaces(begin, end);
    }

    public void ignoreWhenParsing(Collection segments) {
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            ((Segment)i.next()).ignoreWhenParsing();
        }
    }

    public CharStreamSource indent(String indentText, boolean tidyTags, boolean collapseWhiteSpace, boolean indentAllElements) {
        return new Indent(this, indentText, tidyTags, collapseWhiteSpace, indentAllElements);
    }

    public Writer getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(Writer writer) {
        this.logWriter = writer;
    }

    public boolean isLoggingEnabled() {
        return this.logWriter != null;
    }

    public void log(String message) {
        if (this.logWriter == null) {
            return;
        }
        try {
            this.logWriter.write(message);
            this.logWriter.write(10);
            this.logWriter.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void clearCache() {
        this.cache.clear();
        this.allTagsArray = null;
        this.allTags = null;
        this.allStartTags = null;
        this.allElements = null;
    }

    public String getCacheDebugInfo() {
        return this.cache.toString();
    }

    List getParsedTags() {
        ArrayList list = new ArrayList();
        Iterator i = this.cache.getTagIterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public final ParseText getParseText() {
        if (this.parseText == null) {
            if (this.parseTextOutputDocument != null) {
                this.parseText = new ParseText(this.parseTextOutputDocument);
                this.parseTextOutputDocument = null;
            } else {
                this.parseText = new ParseText(this);
            }
        }
        return this.parseText;
    }

    public StartTag findEnclosingStartTag(int pos) {
        StartTag startTag = this.findPreviousStartTag(pos);
        if (startTag == null || startTag.end <= pos) {
            return null;
        }
        return startTag;
    }

    public StartTag findNextComment(int pos) {
        return (StartTag)this.findNextTag(pos, StartTagType.COMMENT);
    }

    public Segment findEnclosingComment(int pos) {
        return this.findEnclosingTag(pos, StartTagType.COMMENT);
    }

    public Iterator getNextTagIterator(int pos) {
        return Tag.getNextTagIterator(this, pos);
    }

    static String getCharsetParameterFromHttpHeaderValue(String httpHeaderValue) {
        int charsetParameterPos = httpHeaderValue.toLowerCase().indexOf("charset=");
        if (charsetParameterPos == -1) {
            return null;
        }
        int charsetBegin = charsetParameterPos + 8;
        int charsetEnd = httpHeaderValue.indexOf(59, charsetBegin);
        String charset = charsetEnd == -1 ? httpHeaderValue.substring(charsetBegin) : httpHeaderValue.substring(charsetBegin, charsetEnd);
        return charset.trim();
    }
}

