/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class Indent
implements CharStreamSource {
    private final Segment segment;
    private final CharSequence sourceText;
    private final String indentText;
    private final boolean tidyTags;
    private final boolean collapseWhiteSpace;
    private final boolean indentAllElements;
    private final boolean indentScriptElements;
    private Writer writer;
    private Tag nextTag;
    private int index;

    public Indent(Segment segment, String indentText, boolean tidyTags, boolean collapseWhiteSpace, boolean indentAllElements) {
        this.segment = segment;
        this.sourceText = segment.source.toString();
        this.indentText = indentText;
        this.tidyTags = tidyTags;
        this.collapseWhiteSpace = collapseWhiteSpace;
        this.indentAllElements = indentAllElements;
        this.indentScriptElements = indentAllElements;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writer = writer;
        this.nextTag = this.segment.source.findNextTag(this.segment.begin);
        this.index = this.segment.begin;
        this.writeContent(this.segment.end, this.segment.getChildElements(), 0);
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.sourceText.length() * 2;
    }

    private void writeContent(int end, List childElements, int depth) throws IOException {
        Iterator i = childElements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            int elementBegin = element.begin;
            if (elementBegin >= end) break;
            if (this.indentAllElements) {
                this.writeText(elementBegin, depth, false, false, false, this.collapseWhiteSpace);
                this.writeElement(element, depth, end, false, false);
                continue;
            }
            String elementName = element.getName();
            if (!this.indent(element)) continue;
            this.writeText(elementBegin, depth, false, false, false, this.collapseWhiteSpace);
            if (elementName == "pre" || elementName == "textarea") {
                this.writeElement(element, depth, end, true, true);
                continue;
            }
            if (elementName == "script") {
                this.writeElement(element, depth, end, true, false);
                continue;
            }
            this.writeElement(element, depth, end, false, !this.containsNonInlineLevelChildElements(element));
        }
        this.writeText(end, depth, false, false, false, this.collapseWhiteSpace);
    }

    private boolean indent(Element element) {
        StartTagType startTagType = element.getStartTag().getStartTagType();
        if (startTagType == StartTagType.DOCTYPE_DECLARATION) {
            return true;
        }
        if (startTagType != StartTagType.NORMAL) {
            return false;
        }
        String elementName = element.getName();
        if (elementName == "script") {
            return this.indentScriptElements;
        }
        if (!HTMLElements.getInlineLevelElementNames().contains(elementName)) {
            return true;
        }
        return this.containsNonInlineLevelChildElements(element);
    }

    private void writeText(int end, int depth, boolean beginInline, boolean endInline, boolean increaseIndentAfterFirstLineBreak, boolean collapseWhiteSpace) throws IOException {
        if (this.index == end) {
            return;
        }
        while (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
            if (++this.index != end) continue;
            return;
        }
        if (!beginInline) {
            this.writeIndent(depth);
        }
        this.writeTextInline(end, depth, increaseIndentAfterFirstLineBreak, collapseWhiteSpace);
        if (!endInline) {
            this.writer.write(10);
        }
    }

    private void writeElement(Element element, int depth, int end, boolean preformatted, boolean renderContentInline) throws IOException {
        int contentEnd;
        StartTag startTag = element.getStartTag();
        EndTag endTag = element.getEndTag();
        this.writeIndent(depth);
        this.writeTag(startTag, depth, end);
        if (this.index == end) {
            this.writer.write(10);
            return;
        }
        if (!renderContentInline) {
            this.writer.write(10);
        }
        if (end < (contentEnd = element.getContentEnd())) {
            contentEnd = end;
        }
        if (preformatted) {
            if (renderContentInline) {
                this.writeContentPreformatted(contentEnd, depth);
            } else {
                this.writeIndentedScriptContent(contentEnd, depth + 1);
            }
        } else if (renderContentInline) {
            if (this.collapseWhiteSpace) {
                this.writeTextCollapseWhiteSpace(contentEnd, depth);
            } else if (!this.writeTextInline(contentEnd, depth, true, false)) {
                this.writer.write(10);
                renderContentInline = false;
            }
        } else {
            this.writeContent(contentEnd, element.getChildElements(), depth + 1);
        }
        if (endTag != null && end > endTag.begin) {
            if (!renderContentInline) {
                this.writeIndent(depth);
            }
            this.writeTag(endTag, depth, end);
            this.writer.write(10);
        } else if (renderContentInline) {
            this.writer.write(10);
        }
    }

    private void updateNextTag() {
        while (this.nextTag != null) {
            if (this.nextTag.begin >= this.index) {
                return;
            }
            this.nextTag = this.nextTag.findNextTag();
        }
    }

    private void writeIndentedScriptContent(int end, int depth) throws IOException {
        if (this.index == end) {
            return;
        }
        int startOfLinePos = this.getStartOfLinePos(end, false);
        if (this.index == end) {
            return;
        }
        if (startOfLinePos == -1) {
            this.writeIndent(depth);
            this.writeLineKeepWhiteSpace(end, depth);
            this.writer.write(10);
            if (this.index == end) {
                return;
            }
            startOfLinePos = this.getStartOfLinePos(end, true);
            if (this.index == end) {
                return;
            }
        }
        this.writeTextPreserveIndenting(end, depth, this.index - startOfLinePos);
        this.writer.write(10);
    }

    private boolean writeTextPreserveIndenting(int end, int depth) throws IOException {
        this.writeLineKeepWhiteSpace(end, depth);
        if (this.index == end) {
            return true;
        }
        int startOfLinePos = this.getStartOfLinePos(end, true);
        if (this.index == end) {
            return true;
        }
        this.writer.write(10);
        this.writeTextPreserveIndenting(end, depth + 1, this.index - startOfLinePos);
        return false;
    }

    private void writeTextPreserveIndenting(int end, int depth, int originalIndentLength) throws IOException {
        this.writeIndent(depth);
        this.writeLineKeepWhiteSpace(end, depth);
        while (this.index != end) {
            char ch;
            for (int x = 0; x < originalIndentLength && ((ch = this.sourceText.charAt(this.index)) == ' ' || ch == '\t'); ++x) {
                if (++this.index != end) continue;
                return;
            }
            this.writer.write(10);
            this.writeIndent(depth);
            this.writeLineKeepWhiteSpace(end, depth);
        }
    }

    private int getStartOfLinePos(int end, boolean atStartOfLine) {
        int startOfLinePos;
        int n = startOfLinePos = atStartOfLine ? this.index : -1;
        do {
            char ch;
            if ((ch = this.sourceText.charAt(this.index)) == '\n' || ch == '\r') {
                startOfLinePos = this.index + 1;
                continue;
            }
            if (ch != ' ' && ch != '\t') break;
        } while (++this.index != end);
        return startOfLinePos;
    }

    private void writeSpecifiedTextInline(CharSequence text, int depth) throws IOException {
        int textLength = text.length();
        int i = this.writeSpecifiedLine(text, 0);
        if (i < textLength) {
            int subsequentLineDepth = depth + 1;
            while (true) {
                if (Segment.isWhiteSpace(text.charAt(i))) {
                    if (++i < textLength) continue;
                    return;
                }
                this.writer.write(10);
                this.writeIndent(subsequentLineDepth);
                if ((i = this.writeSpecifiedLine(text, i)) >= textLength) break;
            }
        }
    }

    private int writeSpecifiedLine(CharSequence text, int i) throws IOException {
        int textLength = text.length();
        do {
            int nexti;
            char ch;
            if ((ch = text.charAt(i)) == '\r' && (nexti = i + 1) < textLength && text.charAt(nexti) == '\n') {
                return i + 2;
            }
            if (ch == '\n') {
                return i + 1;
            }
            this.writer.write(ch);
        } while (++i < textLength);
        return i;
    }

    private boolean writeTextInline(int end, int depth, boolean increaseIndentAfterFirstLineBreak, boolean collapseWhiteSpace) throws IOException {
        int subsequentLineDepth;
        if (this.index == end) {
            return true;
        }
        this.writeLine(end, depth, collapseWhiteSpace);
        if (this.index == end) {
            return true;
        }
        int n = subsequentLineDepth = increaseIndentAfterFirstLineBreak ? depth + 1 : depth;
        while (true) {
            if (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                if (++this.index != end) continue;
                return false;
            }
            this.writer.write(10);
            this.writeIndent(subsequentLineDepth);
            this.writeLine(end, subsequentLineDepth, collapseWhiteSpace);
            if (this.index >= end) break;
        }
        return false;
    }

    private void writeLine(int end, int depth, boolean collapseWhiteSpace) throws IOException {
        if (collapseWhiteSpace) {
            this.writeTextCollapseWhiteSpace(end, depth);
        } else {
            this.writeLineKeepWhiteSpace(end, depth);
        }
    }

    private void writeLineKeepWhiteSpace(int end, int depth) throws IOException {
        this.updateNextTag();
        while (true) {
            int nextindex;
            if (this.nextTag != null && this.index == this.nextTag.begin) {
                this.writeTag(this.nextTag, depth, end);
                if (this.index != end) continue;
                return;
            }
            char ch = this.sourceText.charAt(this.index);
            if (ch == '\r' && (nextindex = this.index + 1) < end && this.sourceText.charAt(nextindex) == '\n') {
                this.index += 2;
                return;
            }
            if (ch == '\n') {
                ++this.index;
                return;
            }
            this.writer.write(ch);
            if (++this.index == end) break;
        }
    }

    private void writeTextCollapseWhiteSpace(int end, int depth) throws IOException {
        boolean lastWasWhiteSpace = false;
        this.updateNextTag();
        while (this.index < end) {
            char ch;
            while (this.nextTag != null && this.index == this.nextTag.begin) {
                if (lastWasWhiteSpace) {
                    this.writer.write(32);
                    lastWasWhiteSpace = false;
                }
                this.writeTag(this.nextTag, depth, end);
                if (this.index != end) continue;
                return;
            }
            if (Segment.isWhiteSpace(ch = this.sourceText.charAt(this.index++))) {
                lastWasWhiteSpace = true;
                continue;
            }
            if (lastWasWhiteSpace) {
                this.writer.write(32);
                lastWasWhiteSpace = false;
            }
            this.writer.write(ch);
        }
        if (lastWasWhiteSpace) {
            this.writer.write(32);
        }
    }

    private void writeContentPreformatted(int end, int depth) throws IOException {
        this.updateNextTag();
        while (true) {
            if (this.nextTag != null && this.index == this.nextTag.begin) {
                this.writeTag(this.nextTag, depth, end);
                if (this.index != end) continue;
                return;
            }
            this.writer.write(this.sourceText.charAt(this.index));
            if (++this.index >= end) break;
        }
    }

    private void writeTag(Tag tag, int depth, int end) throws IOException {
        int tagEnd;
        this.nextTag = tag.findNextTag();
        int n = tagEnd = end > tag.end ? tag.end : end;
        if (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.CDATA_SECTION) {
            this.writeTextPreserveIndenting(tagEnd, depth);
        } else if (this.tidyTags) {
            String tidyTag = tag.tidy();
            if (tag instanceof StartTag && ((StartTag)tag).getAttributes() != null) {
                this.writer.write(tidyTag);
            } else {
                this.writeSpecifiedTextInline(tidyTag, depth);
            }
            this.index = tagEnd;
        } else {
            this.writeTextInline(tagEnd, depth, true, false);
        }
        if (end <= tag.end || !(tag instanceof StartTag)) {
            return;
        }
        if (tag.name == "script" && !this.indentScriptElements || tag.getTagType().isServerTag()) {
            Element element = tag.getElement();
            EndTag endTag = element.getEndTag();
            if (endTag == null) {
                return;
            }
            int contentEnd = end < endTag.begin ? end : endTag.begin;
            boolean singleLineContent = this.writeTextPreserveIndenting(contentEnd, depth);
            if (endTag.begin >= end) {
                return;
            }
            if (!singleLineContent) {
                this.writer.write(10);
                this.writeIndent(depth);
            }
            this.writeTag(endTag, depth, end);
        }
    }

    private void writeIndent(int depth) throws IOException {
        for (int x = 0; x < depth; ++x) {
            this.writer.write(this.indentText);
        }
    }

    private boolean containsNonInlineLevelChildElements(Element element) {
        List childElements = element.getChildElements();
        if (childElements == Collections.EMPTY_LIST) {
            return false;
        }
        Iterator i = childElements.iterator();
        while (i.hasNext()) {
            Element childElement = (Element)i.next();
            String elementName = childElement.getName();
            if (elementName == "script" || !HTMLElements.getInlineLevelElementNames().contains(elementName)) {
                return true;
            }
            if (!this.containsNonInlineLevelChildElements(childElement)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }
}

