/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.LocalDate;

public interface BusinessdayCalendarInterface {
    public boolean isBusinessday(LocalDate var1);

    public LocalDate getAdjustedDate(LocalDate var1, DateRollConvention var2);

    public LocalDate getAdjustedDate(LocalDate var1, String var2, DateRollConvention var3);

    public LocalDate getRolledDate(LocalDate var1, int var2);

    public LocalDate createDateFromDateAndOffsetCode(LocalDate var1, String var2);

    public static enum DateRollConvention {
        UNADJUSTED,
        FOLLOWING,
        PRECEDING,
        MODIFIED_FOLLOWING,
        MODIFIED_PRECEDING;


        public static DateRollConvention getEnum(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (string.equalsIgnoreCase("actual")) {
                return UNADJUSTED;
            }
            if (string.equalsIgnoreCase("modfollow")) {
                return MODIFIED_FOLLOWING;
            }
            if (string.equalsIgnoreCase("modpreced")) {
                return MODIFIED_PRECEDING;
            }
            if (string.equalsIgnoreCase("follow")) {
                return FOLLOWING;
            }
            if (string.equalsIgnoreCase("preced")) {
                return PRECEDING;
            }
            return DateRollConvention.valueOf(string.toUpperCase());
        }
    }

    public static enum DateOffsetUnit {
        DAYS,
        BUSINESS_DAYS,
        WEEKS,
        MONTHS,
        YEARS;


        public static DateOffsetUnit getEnum(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (string.equalsIgnoreCase("d")) {
                return DAYS;
            }
            if (string.equalsIgnoreCase("b")) {
                return BUSINESS_DAYS;
            }
            if (string.equalsIgnoreCase("bd")) {
                return BUSINESS_DAYS;
            }
            if (string.equalsIgnoreCase("w")) {
                return WEEKS;
            }
            if (string.equalsIgnoreCase("m")) {
                return MONTHS;
            }
            if (string.equalsIgnoreCase("y")) {
                return YEARS;
            }
            return DateOffsetUnit.valueOf(string.toUpperCase());
        }
    }
}

