/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.LocalDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class BusinessdayCalendarExcludingTARGETHolidays
extends BusinessdayCalendar {
    private BusinessdayCalendarInterface baseCalendar;
    private final BusinessdayCalendarInterface weekdayCalendar = new BusinessdayCalendarExcludingWeekends();

    public BusinessdayCalendarExcludingTARGETHolidays() {
    }

    public BusinessdayCalendarExcludingTARGETHolidays(BusinessdayCalendarInterface baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    @Override
    public boolean isBusinessday(LocalDate date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        return !(!this.weekdayCalendar.isBusinessday(date) || this.baseCalendar != null && !this.baseCalendar.isBusinessday(date) || day == 1 && month == 1 || BusinessdayCalendarExcludingTARGETHolidays.isEasterSunday(date.plusDays(2L)) || BusinessdayCalendarExcludingTARGETHolidays.isEasterSunday(date.minusDays(1L)) || day == 1 && month == 5 || day == 25 && month == 12 || day == 26 && month == 12);
    }

    public static boolean isEasterSunday(LocalDate date) {
        int Y = date.getYear();
        int a = Y % 19;
        int b = Y / 100;
        int c = Y % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int L = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * L) / 451;
        int easterSundayMonth = (h + L - 7 * m + 114) / 31;
        int easterSundayDay = (h + L - 7 * m + 114) % 31 + 1;
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        return easterSundayMonth == month && easterSundayDay == day;
    }

    @Override
    public String toString() {
        return "BusinessdayCalendarExcludingTARGETHolidays [baseCalendar=" + this.baseCalendar + "]";
    }
}

