/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.daycount.DayCountConventionInterface;

public class Schedule
implements ScheduleInterface {
    private LocalDate referenceDate;
    private List<Period> periods;
    private DayCountConventionInterface daycountconvention;
    private double[] fixingTimes;
    private double[] paymentTimes;
    private double[] periodStartTimes;
    private double[] periodEndTimes;
    private double[] periodLength;

    public Schedule(LocalDate referenceDate, DayCountConventionInterface daycountconvention, Period ... periods) {
        this(referenceDate, Arrays.asList(periods), daycountconvention);
    }

    public Schedule(LocalDate referenceDate, List<Period> periods, DayCountConventionInterface daycountconvention) {
        this.referenceDate = referenceDate;
        this.periods = periods;
        this.daycountconvention = daycountconvention;
        this.fixingTimes = new double[periods.size()];
        this.paymentTimes = new double[periods.size()];
        this.periodStartTimes = new double[periods.size()];
        this.periodEndTimes = new double[periods.size()];
        this.periodLength = new double[periods.size()];
        for (int periodIndex = 0; periodIndex < periods.size(); ++periodIndex) {
            this.fixingTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getFixing());
            this.paymentTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPayment());
            this.periodStartTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPeriodStart());
            this.periodEndTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPeriodEnd());
            this.periodLength[periodIndex] = daycountconvention.getDaycountFraction(periods.get(periodIndex).getPeriodStart(), periods.get(periodIndex).getPeriodEnd());
        }
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public List<Period> getPeriods() {
        return this.periods;
    }

    @Override
    public DayCountConventionInterface getDaycountconvention() {
        return this.daycountconvention;
    }

    @Override
    public int getNumberOfPeriods() {
        return this.periods.size();
    }

    @Override
    public Period getPeriod(int periodIndex) {
        return this.periods.get(periodIndex);
    }

    @Override
    public double getFixing(int periodIndex) {
        return this.fixingTimes[periodIndex];
    }

    @Override
    public double getPayment(int periodIndex) {
        return this.paymentTimes[periodIndex];
    }

    @Override
    public double getPeriodStart(int periodIndex) {
        return this.periodStartTimes[periodIndex];
    }

    @Override
    public double getPeriodEnd(int periodIndex) {
        return this.periodEndTimes[periodIndex];
    }

    @Override
    public double getPeriodLength(int periodIndex) {
        return this.periodLength[periodIndex];
    }

    @Override
    public Iterator<Period> iterator() {
        return this.periods.iterator();
    }

    public String toString() {
        String periodOutputString = "Periods (fixing, periodStart, periodEnd, payment):";
        for (int periodIndex = 0; periodIndex < this.periods.size(); ++periodIndex) {
            periodOutputString = periodOutputString + "\n" + this.periods.get(periodIndex).getFixing() + ", " + this.periods.get(periodIndex).getPeriodStart() + ", " + this.periods.get(periodIndex).getPeriodEnd() + ", " + this.periods.get(periodIndex).getPayment();
        }
        return "Schedule [referenceDate=" + this.referenceDate + ", daycountconvention=" + this.daycountconvention + "\n" + periodOutputString + "]";
    }
}

