/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomVariableInterface;

public class Scalar
implements RandomVariableInterface {
    final double value;

    public Scalar(double value) {
        this.value = value;
    }

    @Override
    public boolean equals(RandomVariableInterface randomVariable) {
        return randomVariable.isDeterministic() && this.value == randomVariable.get(0);
    }

    @Override
    public double getFiltrationTime() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double get(int pathOrState) {
        return this.value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public double[] getRealizations() {
        return null;
    }

    @Override
    public IntToDoubleFunction getOperator() {
        return null;
    }

    @Override
    public DoubleStream getRealizationsStream() {
        return null;
    }

    @Override
    public double getMin() {
        return this.value;
    }

    @Override
    public double getMax() {
        return this.value;
    }

    @Override
    public double getAverage() {
        return this.value;
    }

    @Override
    public double getAverage(RandomVariableInterface probabilities) {
        return this.value * probabilities.getAverage();
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    @Override
    public double getVariance(RandomVariableInterface probabilities) {
        return 0.0;
    }

    @Override
    public double getSampleVariance() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation(RandomVariableInterface probabilities) {
        return 0.0;
    }

    @Override
    public double getStandardError() {
        return 0.0;
    }

    @Override
    public double getStandardError(RandomVariableInterface probabilities) {
        return 0.0;
    }

    @Override
    public double getQuantile(double quantile) {
        return 0.0;
    }

    @Override
    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        return 0.0;
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return 0.0;
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        return null;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return null;
    }

    @Override
    public RandomVariableInterface cache() {
        return this;
    }

    @Override
    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        return new Scalar(operator.applyAsDouble(this.value));
    }

    @Override
    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        return null;
    }

    @Override
    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        return null;
    }

    @Override
    public RandomVariableInterface floor(double floor) {
        return new Scalar(Math.max(this.value, floor));
    }

    @Override
    public RandomVariableInterface add(double value) {
        return new Scalar(this.value + value);
    }

    @Override
    public RandomVariableInterface sub(double value) {
        return new Scalar(this.value - value);
    }

    @Override
    public RandomVariableInterface mult(double value) {
        return new Scalar(this.value * value);
    }

    @Override
    public RandomVariableInterface div(double value) {
        return new Scalar(this.value / value);
    }

    @Override
    public RandomVariableInterface pow(double exponent) {
        return new Scalar(Math.pow(this.value, exponent));
    }

    @Override
    public RandomVariableInterface average() {
        return this;
    }

    @Override
    public RandomVariableInterface squared() {
        return new Scalar(this.value * this.value);
    }

    @Override
    public RandomVariableInterface sqrt() {
        return new Scalar(Math.sqrt(this.value));
    }

    @Override
    public RandomVariableInterface exp() {
        return new Scalar(Math.exp(this.value));
    }

    @Override
    public RandomVariableInterface log() {
        return new Scalar(Math.log(this.value));
    }

    @Override
    public RandomVariableInterface sin() {
        return new Scalar(Math.sin(this.value));
    }

    @Override
    public RandomVariableInterface cos() {
        return new Scalar(Math.cos(this.value));
    }

    @Override
    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return randomVariable.add(this.value);
    }

    @Override
    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return randomVariable.sub(this.value).mult(-1.0);
    }

    @Override
    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        if (this.value == 0.0) {
            return new Scalar(0.0);
        }
        return randomVariable.mult(this.value);
    }

    @Override
    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        if (this.value == 0.0) {
            return new Scalar(0.0);
        }
        return randomVariable.mult(this.value);
    }

    @Override
    public RandomVariableInterface cap(RandomVariableInterface cap) {
        if (cap.isDeterministic()) {
            return new Scalar(Math.min(this.value, cap.get(0)));
        }
        return cap.cap(this.value);
    }

    @Override
    public RandomVariableInterface floor(RandomVariableInterface floor) {
        if (floor.isDeterministic()) {
            return new Scalar(Math.max(this.value, floor.get(0)));
        }
        return floor.floor(this.value);
    }

    @Override
    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        if (rate.isDeterministic()) {
            return new Scalar(this.value * (1.0 + rate.get(0) * periodLength));
        }
        return rate.mult(periodLength * this.value).add(this.value);
    }

    @Override
    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        if (this.value == 0.0) {
            return new Scalar(0.0);
        }
        if (rate.isDeterministic()) {
            return new Scalar(this.value / (1.0 + rate.get(0) * periodLength));
        }
        return rate.mult(periodLength / this.value).add(1.0 / this.value).invert();
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        return null;
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return null;
    }

    @Override
    public RandomVariableInterface invert() {
        return new Scalar(1.0 / this.value);
    }

    @Override
    public RandomVariableInterface abs() {
        return new Scalar(Math.abs(this.value));
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        if (factor1.isDeterministic()) {
            return new Scalar(this.value + factor1.get(0) * factor2);
        }
        return factor1.mult(factor2).add(this.value);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        if (factor1.isDeterministic() && factor2.isDeterministic()) {
            return new Scalar(this.value + factor1.get(0) * factor2.get(0));
        }
        return factor1.mult(factor2).add(this.value);
    }

    @Override
    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        if (numerator.isDeterministic() && denominator.isDeterministic()) {
            return new Scalar(this.value + numerator.get(0) * denominator.get(0));
        }
        return numerator.div(denominator).add(this.value);
    }

    @Override
    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        if (numerator.isDeterministic() && denominator.isDeterministic()) {
            return new Scalar(this.value - numerator.get(0) * denominator.get(0));
        }
        return numerator.div(denominator).sub(this.value).mult(-1.0);
    }

    @Override
    public RandomVariableInterface isNaN() {
        return new Scalar(Double.isNaN(this.value) ? 1.0 : 0.0);
    }
}

