/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.templatemethoddesign.LogNormalProcess;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloBlackScholesModel2
extends LogNormalProcess
implements AssetModelMonteCarloSimulationInterface {
    private double initialValue;
    private double riskFreeRate;
    private double volatility;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];
    private RandomVariableInterface drift;
    private RandomVariableInterface volatilityOnPaths;

    public MonteCarloBlackScholesModel2(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility) {
        super(timeDiscretization, 1, 1, numberOfPaths, 3141);
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.initialValueVector[0] = new RandomVariable(0.0, initialValue);
        this.drift = new RandomVariable(0.0, riskFreeRate);
        this.volatilityOnPaths = new RandomVariable(0.0, volatility);
    }

    public MonteCarloBlackScholesModel2(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility, int seed) {
        super(timeDiscretization, 1, 1, numberOfPaths, seed);
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.initialValueVector[0] = new RandomVariable(0.0, initialValue);
        this.drift = new RandomVariable(0.0, riskFreeRate);
        this.volatilityOnPaths = new RandomVariable(0.0, volatility);
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public RandomVariableInterface[] getInitialValue() {
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface getDrift(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariableInterface getFactorLoading(int timeIndex, int factor, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        return this.volatilityOnPaths;
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) {
        return this.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) {
        double time = this.getTime(timeIndex);
        return this.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return new RandomVariable(time, numeraireValue);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getBrownianMotion().getRandomVariableForConstant(value);
    }

    public String toString() {
        return super.toString() + "\nMonteCarloBlackScholesModelByInheritance:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int seed) {
        return new MonteCarloBlackScholesModel2(this.getTimeDiscretization(), this.getNumberOfPaths(), this.getInitialValue()[0].get(0), this.getRiskFreeRate(), this.getVolatility(), seed);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) {
        throw new UnsupportedOperationException();
    }
}

