/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.process.ProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LinearInterpolatedTimeDiscreteProcess
implements ProcessInterface {
    private TimeDiscretizationInterface timeDiscretization;
    private Map<Double, RandomVariableInterface> realizations;

    public LinearInterpolatedTimeDiscreteProcess(Map<Double, RandomVariableInterface> realizations) {
        this.timeDiscretization = new TimeDiscretization(realizations.keySet());
        this.realizations = new HashMap<Double, RandomVariableInterface>();
        this.realizations.putAll(realizations);
    }

    private LinearInterpolatedTimeDiscreteProcess(TimeDiscretizationInterface timeDiscretization, Map<Double, RandomVariableInterface> realizations) {
        this.timeDiscretization = timeDiscretization;
        this.realizations = realizations;
    }

    public LinearInterpolatedTimeDiscreteProcess add(LinearInterpolatedTimeDiscreteProcess process) throws CalculationException {
        HashMap<Double, RandomVariableInterface> sum = new HashMap<Double, RandomVariableInterface>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            sum.put(time, this.realizations.get(time).add(process.getProcessValue(time, 0)));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, sum);
    }

    public LinearInterpolatedTimeDiscreteProcess apply(DoubleUnaryOperator function) {
        HashMap<Double, RandomVariableInterface> result = new HashMap<Double, RandomVariableInterface>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            result.put(time, this.realizations.get(time).apply(function));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, result);
    }

    public RandomVariableInterface getProcessValue(double time, int component) throws CalculationException {
        double timeUpper;
        double timeLower = this.timeDiscretization.getTimeIndexNearestLessOrEqual(time);
        if (timeLower == (timeUpper = (double)this.timeDiscretization.getTimeIndexNearestGreaterOrEqual(time))) {
            return this.realizations.get(timeLower);
        }
        RandomVariableInterface valueLower = this.realizations.get(timeLower);
        RandomVariableInterface valueUpper = this.realizations.get(timeUpper);
        return valueUpper.mult((time - timeLower) / (timeUpper - timeLower)).add(valueLower.mult((timeUpper - time) / (timeUpper - timeLower)));
    }

    @Override
    public RandomVariableInterface getProcessValue(int timeIndex, int component) throws CalculationException {
        return this.realizations.get(this.timeDiscretization.getTime(timeIndex));
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int timeIndex) {
        return this.timeDiscretization.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    @Override
    public ProcessInterface clone() {
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, this.realizations);
    }
}

