/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class TriggerIndex
extends AbstractIndex {
    private static final long serialVersionUID = 2329303879116802448L;
    private AbstractProductComponent trigger;
    private AbstractProductComponent indexIfTriggerIsPositive;
    private AbstractProductComponent indexIfTriggerIsNegative;

    public TriggerIndex(AbstractProductComponent trigger, AbstractProductComponent indexIfTriggerIsPositive, AbstractProductComponent indexIfTriggerIsNegative) {
        this.trigger = trigger;
        this.indexIfTriggerIsPositive = indexIfTriggerIsPositive;
        this.indexIfTriggerIsNegative = indexIfTriggerIsNegative;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface valueTrigger = this.trigger.getValue(evaluationTime, model);
        RandomVariableInterface valueIfTriggerNonNegative = this.indexIfTriggerIsPositive.getValue(evaluationTime, model);
        RandomVariableInterface valueIfTriggerIsNegative = this.indexIfTriggerIsNegative.getValue(evaluationTime, model);
        return valueTrigger.barrier(valueTrigger, valueIfTriggerNonNegative, valueIfTriggerIsNegative);
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNamesNegative;
        Set<String> underlyingNames = this.trigger.queryUnderlyings();
        Set<String> underlyingNamesPositive = this.indexIfTriggerIsPositive.queryUnderlyings();
        if (underlyingNamesPositive != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesPositive);
            } else {
                underlyingNames = underlyingNamesPositive;
            }
        }
        if ((underlyingNamesNegative = this.indexIfTriggerIsNegative.queryUnderlyings()) != null) {
            if (underlyingNames != null) {
                underlyingNames.addAll(underlyingNamesNegative);
            } else {
                underlyingNames = underlyingNamesNegative;
            }
        }
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "TriggerIndex [trigger=" + this.trigger + ", indexIfTriggerIsPositive=" + this.indexIfTriggerIsPositive + ", indexIfTriggerIsNegative=" + this.indexIfTriggerIsNegative + ", toString()=" + super.toString() + "]";
    }
}

