/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Option
extends AbstractProductComponent {
    private static final long serialVersionUID = 2987369289230532162L;
    private final double exerciseDate;
    private final double strikePrice;
    private final AbstractLIBORMonteCarloProduct underlying;
    private final AbstractLIBORMonteCarloProduct strikeProduct;
    private final boolean isCall;

    public Option(double exerciseDate, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, 0.0, underlying);
    }

    public Option(double exerciseDate, double strikePrice, AbstractLIBORMonteCarloProduct underlying) {
        this(exerciseDate, strikePrice, true, underlying);
    }

    public Option(double exerciseDate, double strikePrice, boolean isCall, AbstractLIBORMonteCarloProduct underlying) {
        this.exerciseDate = exerciseDate;
        this.strikePrice = strikePrice;
        this.underlying = underlying;
        this.isCall = isCall;
        this.strikeProduct = null;
    }

    public Option(double exerciseDate, boolean isCall, AbstractLIBORMonteCarloProduct strikeProduct, AbstractLIBORMonteCarloProduct underlying) {
        this.exerciseDate = exerciseDate;
        this.strikePrice = Double.NaN;
        this.strikeProduct = strikeProduct;
        this.underlying = underlying;
        this.isCall = isCall;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface strike;
        RandomVariableInterface one = model.getRandomVariableForConstant(1.0);
        RandomVariableInterface zero = model.getRandomVariableForConstant(0.0);
        if (evaluationTime > this.exerciseDate) {
            return zero;
        }
        RandomVariableInterface values = this.underlying.getValue(this.exerciseDate, model);
        RandomVariableInterface exerciseTrigger = values.sub(strike = this.strikeProduct != null ? this.strikeProduct.getValue(this.exerciseDate, model) : model.getRandomVariableForConstant(this.strikePrice)).mult(this.isCall ? 1.0 : -1.0);
        if (exerciseTrigger.getFiltrationTime() > this.exerciseDate) {
            RandomVariableInterface filterNaN = exerciseTrigger.isNaN().sub(1.0).mult(-1.0);
            RandomVariableInterface exerciseTriggerFiltered = exerciseTrigger.mult(filterNaN);
            double exerciseTriggerMean = exerciseTriggerFiltered.getAverage();
            double exerciseTriggerStdDev = exerciseTriggerFiltered.getStandardDeviation();
            double exerciseTriggerFloor = exerciseTriggerMean * (1.0 - Math.signum(exerciseTriggerMean) * 1.0E-5) - 3.0 * exerciseTriggerStdDev;
            double exerciseTriggerCap = exerciseTriggerMean * (1.0 + Math.signum(exerciseTriggerMean) * 1.0E-5) + 3.0 * exerciseTriggerStdDev;
            RandomVariableInterface filter = exerciseTrigger.barrier(exerciseTrigger.sub(exerciseTriggerFloor), one, zero).mult(exerciseTrigger.barrier(exerciseTrigger.sub(exerciseTriggerCap).mult(-1.0), one, zero));
            filter = filter.mult(filterNaN);
            exerciseTrigger = exerciseTrigger.mult(filter);
            RandomVariableInterface[] regressionBasisFunctions = this.getRegressionBasisFunctions(this.exerciseDate, model);
            RandomVariableInterface[] filteredRegressionBasisFunctions = new RandomVariableInterface[regressionBasisFunctions.length];
            for (int i = 0; i < regressionBasisFunctions.length; ++i) {
                filteredRegressionBasisFunctions[i] = regressionBasisFunctions[i].mult(filter);
            }
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(filteredRegressionBasisFunctions, regressionBasisFunctions);
            exerciseTrigger = condExpEstimator.getConditionalExpectation(exerciseTrigger);
        }
        values = this.strikeProduct != null ? values.barrier(exerciseTrigger, values, this.strikeProduct.getValue(this.exerciseDate, model)) : values.barrier(exerciseTrigger, values, this.strikePrice);
        if (evaluationTime != this.exerciseDate) {
            RandomVariableInterface numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariableInterface numeraire = model.getNumeraire(this.exerciseDate);
            values = values.div(numeraire).mult(numeraireAtEval);
        }
        return values;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        double periodLength3;
        double periodLength2;
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface basisFunction = model.getRandomVariableForConstant(1.0);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariableInterface rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunction = basisFunction.discount(rate, periodLength2);
        }
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd = model.getNumberOfLibors()) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
        }
        return basisFunctions.toArray(new RandomVariableInterface[0]);
    }

    @Override
    public String toString() {
        return "Option [exerciseDate=" + this.exerciseDate + ", strikePrice=" + this.strikePrice + ", underlying=" + this.underlying + ", isCall=" + this.isCall + ", toString()=" + super.toString() + "]";
    }
}

