/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class IndexedValue
extends AbstractProductComponent {
    private static final long serialVersionUID = -7268432817913776974L;
    private double exerciseDate;
    private AbstractProductComponent index;
    private AbstractProductComponent underlying;

    public IndexedValue(double exerciseDate, AbstractProductComponent index, AbstractProductComponent underlying) {
        this.exerciseDate = exerciseDate;
        this.index = index;
        this.underlying = underlying;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = this.underlying.queryUnderlyings();
        Set<String> indexUnderylingNames = this.index.queryUnderlyings();
        if (underlyingNames == null && indexUnderylingNames == null) {
            return null;
        }
        if (underlyingNames != null && indexUnderylingNames == null) {
            return underlyingNames;
        }
        if (underlyingNames == null && indexUnderylingNames != null) {
            return indexUnderylingNames;
        }
        underlyingNames.addAll(indexUnderylingNames);
        return underlyingNames;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        double evaluationTimeUnderlying = Math.max(evaluationTime, this.exerciseDate);
        RandomVariableInterface underlyingValues = this.underlying.getValue(evaluationTimeUnderlying, model);
        RandomVariableInterface indexValues = this.index.getValue(this.exerciseDate, model);
        if (indexValues.getFiltrationTime() > this.exerciseDate && this.exerciseDate > evaluationTime) {
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.exerciseDate, model));
            indexValues = condExpEstimator.getConditionalExpectation(indexValues);
        }
        underlyingValues = underlyingValues.mult(indexValues);
        if (evaluationTime != evaluationTimeUnderlying) {
            RandomVariableInterface numeraireAtEval = model.getNumeraire(evaluationTime);
            RandomVariableInterface numeraire = model.getNumeraire(evaluationTimeUnderlying);
            underlyingValues = underlyingValues.div(numeraire).mult(numeraireAtEval);
        }
        return underlyingValues;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double exerciseDate, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface basisFunction = new RandomVariable(exerciseDate, 1.0);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariable(exerciseDate, 1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariableInterface rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariable(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2;
        periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = new RandomVariable(exerciseDate, 1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(exerciseDate);
        liborPeriodIndexEnd = model.getNumberOfLibors();
        periodLength = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        rate = model.getLIBOR(exerciseDate, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength);
        basisFunctions.add(basisFunction);
        return basisFunctions.toArray(new RandomVariableInterface[0]);
    }
}

