/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.AnalyticModelIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class AccrualAccount
extends AbstractProductComponent {
    private static final long serialVersionUID = 188297603697240319L;
    private AnalyticModelIndex pastFixings = null;
    private AbstractIndex accrualIndex;
    private double accrualPeriod;

    public AccrualAccount(String currency, AnalyticModelIndex pastFixings, AbstractIndex accrualIndex, double accrualPeriod) {
        super(currency);
        this.pastFixings = pastFixings;
        this.accrualIndex = accrualIndex;
        this.accrualPeriod = accrualPeriod;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.accrualIndex.queryUnderlyings();
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        if (evaluationTime <= 0.0) {
            return this.pastFixings.getValue(evaluationTime, model);
        }
        RandomVariableInterface value = this.pastFixings.getValue(0.0, model);
        for (double time = 0.0; time < evaluationTime; time += this.accrualPeriod) {
            RandomVariableInterface forwardRate = this.accrualIndex.getValue(time, model);
            double currentAccrualPeriod = Math.min(this.accrualPeriod, evaluationTime - time);
            value = value.accrue(forwardRate, currentAccrualPeriod);
        }
        return value;
    }
}

