/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class SimpleSwap
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] swaprates;
    private final boolean isPayFix;

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates, boolean isPayFix) {
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.swaprates = swaprates;
        this.isPayFix = isPayFix;
    }

    public SimpleSwap(double[] fixingDates, double[] paymentDates, double[] swaprates) {
        this(fixingDates, paymentDates, swaprates, true);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values = model.getRandomVariableForConstant(0.0);
        for (int period = 0; period < this.fixingDates.length; ++period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double swaprate = this.swaprates[period];
            double periodLength = paymentDate - fixingDate;
            if (paymentDate < evaluationTime) continue;
            RandomVariableInterface libor = model.getLIBOR(fixingDate, fixingDate, paymentDate);
            RandomVariableInterface payoff = libor.sub(swaprate).mult(periodLength);
            if (!this.isPayFix) {
                payoff = payoff.mult(-1.0);
            }
            RandomVariableInterface numeraire = model.getNumeraire(paymentDate);
            RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            values = values.add(payoff);
        }
        RandomVariableInterface numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }

    @Override
    public String toString() {
        return super.toString() + "\nfixingDates: " + Arrays.toString(this.fixingDates) + "\npaymentDates: " + Arrays.toString(this.paymentDates) + "\nswaprates: " + Arrays.toString(this.swaprates);
    }
}

