/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class SimpleCappedFlooredFloatingRateBond
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] spreads;
    private final double[] floors;
    private final double[] caps;
    private final double maturity;

    public SimpleCappedFlooredFloatingRateBond(String currency, double[] fixingDates, double[] paymentDates, double[] spreads, double[] floors, double[] caps, double maturity) {
        super(currency);
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.spreads = spreads;
        this.floors = floors;
        this.caps = caps;
        this.maturity = maturity;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface value = model.getRandomVariableForConstant(0.0);
        for (int periodIndex = 0; periodIndex < this.fixingDates.length; ++periodIndex) {
            double fixingDate = this.fixingDates[periodIndex];
            double paymentDate = this.paymentDates[periodIndex];
            double periodLength = paymentDate - fixingDate;
            RandomVariableInterface coupon = model.getLIBOR(fixingDate, fixingDate, paymentDate);
            if (this.spreads != null) {
                coupon = coupon.sub(this.spreads[periodIndex]);
            }
            if (this.floors != null) {
                coupon = coupon.floor(this.floors[periodIndex]);
            }
            if (this.caps != null) {
                coupon = coupon.cap(this.caps[periodIndex]);
            }
            coupon = coupon.mult(periodLength);
            RandomVariableInterface numeraire = model.getNumeraire(paymentDate);
            RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            value = value.add(coupon.div(numeraire).mult(monteCarloProbabilities));
        }
        RandomVariableInterface notionalPayoff = model.getRandomVariableForConstant(1.0);
        RandomVariableInterface numeraire = model.getNumeraire(this.maturity);
        RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(this.maturity);
        value = value.add(notionalPayoff.div(numeraire).mult(monteCarloProbabilities));
        RandomVariableInterface numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return value;
    }
}

