/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class DigitalCaplet
extends AbstractLIBORMonteCarloProduct {
    private final double optionMaturity;
    private final double periodStart;
    private final double periodEnd;
    private final double strike;

    public DigitalCaplet(double optionMaturity, double periodStart, double periodEnd, double strike) {
        this.optionMaturity = optionMaturity;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.strike = strike;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        double paymentDate = this.periodEnd;
        double periodLength = this.periodEnd - this.periodStart;
        RandomVariableInterface libor = model.getLIBOR(this.optionMaturity, this.periodStart, this.periodEnd);
        RandomVariableInterface trigger = libor.sub(this.strike).mult(periodLength);
        RandomVariableInterface values = new RandomVariable(1.0).barrier(trigger, (RandomVariableInterface)new RandomVariable(periodLength), new RandomVariable(0.0));
        RandomVariableInterface numeraire = model.getNumeraire(paymentDate);
        RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }
}

