/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class Bond
extends AbstractLIBORMonteCarloProduct {
    private double maturity;

    public Bond(double maturity) {
        this.maturity = maturity;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface numeraire = model.getNumeraire(this.maturity);
        RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(this.maturity);
        RandomVariableInterface values = model.getRandomVariableForConstant(1.0);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public void setMaturity(double maturity) {
        this.maturity = maturity;
    }

    @Override
    public String toString() {
        return super.toString() + "\nmaturity: " + this.maturity;
    }
}

