/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Arrays;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelMaturityDependentFourParameterExponentialForm
extends LIBORVolatilityModel {
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b, double c, double d) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.a, a);
        this.b = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.b, b);
        this.c = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.c, c);
        this.d = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.d, d);
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double[] a, double[] b, double[] c, double[] d) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[]{this.a[0], this.b[0], this.c[0], this.d[0]};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        Arrays.fill(this.a, parameter[0]);
        Arrays.fill(this.b, parameter[1]);
        Arrays.fill(this.c, parameter[2]);
        Arrays.fill(this.d, parameter[3]);
    }

    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int liborIndex) {
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        double volatilityInstanteaneous = timeToMaturity <= 0.0 ? 0.0 : (this.a[liborIndex] + this.b[liborIndex] * timeToMaturity) * Math.exp(-this.c[liborIndex] * timeToMaturity) + this.d[liborIndex];
        if (volatilityInstanteaneous < 0.0) {
            volatilityInstanteaneous = Math.max(volatilityInstanteaneous, 0.0);
        }
        return new RandomVariable(this.getTimeDiscretization().getTime(timeIndex), volatilityInstanteaneous);
    }

    public void setParameters(double[] a, double[] b, double[] c, double[] d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d);
    }
}

