/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFourParameterExponentialForm
extends LIBORVolatilityModel {
    private final AbstractRandomVariableFactory randomVariableFactory;
    private double a;
    private double b;
    private double c;
    private double d;
    private boolean isCalibrateable = false;
    private transient RandomVariableInterface[][] volatility;

    public LIBORVolatilityModelFourParameterExponentialForm(AbstractRandomVariableFactory randomVariableFactory, TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = randomVariableFactory;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        this(null, timeDiscretization, liborPeriodDiscretization, a, b, c, d, isCalibrateable);
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = parameter[0];
        this.b = parameter[1];
        this.c = parameter[2];
        this.d = parameter[3];
        this.volatility = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int liborIndex) {
        if (this.randomVariableFactory != null) {
            AbstractRandomVariableFactory abstractRandomVariableFactory = this.randomVariableFactory;
            synchronized (abstractRandomVariableFactory) {
                if (this.volatility == null) {
                    this.volatility = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
                }
                if (this.volatility[timeIndex][liborIndex] == null) {
                    this.volatility[timeIndex][liborIndex] = this.randomVariableFactory.createRandomVariable(this.getVolatilityAsDouble(timeIndex, liborIndex));
                }
            }
            return this.volatility[timeIndex][liborIndex];
        }
        return new RandomVariable(this.getVolatilityAsDouble(timeIndex, liborIndex));
    }

    private double getVolatilityAsDouble(int timeIndex, int liborIndex) {
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        double volatilityInstanteaneous = timeToMaturity <= 0.0 ? 0.0 : (this.a + this.b * timeToMaturity) * Math.exp(-this.c * timeToMaturity) + this.d;
        if (volatilityInstanteaneous < 0.0) {
            volatilityInstanteaneous = Math.max(volatilityInstanteaneous, 0.0);
        }
        return volatilityInstanteaneous;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }
}

