/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelStochasticVolatility
extends AbstractLIBORCovarianceModelParametric {
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private BrownianMotionInterface brownianMotion;
    private double rho;
    private double nu;
    private boolean isCalibrateable = false;
    private AbstractProcessInterface stochasticVolatilityScalings = null;

    public LIBORCovarianceModelStochasticVolatility(AbstractLIBORCovarianceModelParametric covarianceModel, BrownianMotionInterface brownianMotion, double nu, double rho, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.brownianMotion = brownianMotion;
        this.nu = nu;
        this.rho = rho;
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        double[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new double[]{this.nu, this.rho};
        }
        double[] jointParameters = new double[covarianceParameters.length + 2];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length + 0] = this.nu;
        jointParameters[covarianceParameters.length + 1] = this.rho;
        return jointParameters;
    }

    private void setParameter(double[] parameter) {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameter);
            return;
        }
        double[] covarianceParameters = new double[parameter.length - 2];
        System.arraycopy(parameter, 0, covarianceParameters, 0, covarianceParameters.length);
        this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        this.nu = parameter[covarianceParameters.length + 0];
        this.rho = parameter[covarianceParameters.length + 1];
        this.stochasticVolatilityScalings = null;
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelStochasticVolatility newModel = new LIBORCovarianceModelStochasticVolatility((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.brownianMotion, this.nu, this.rho, this.isCalibrateable);
        return newModel;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORCovarianceModelStochasticVolatility model = (LIBORCovarianceModelStochasticVolatility)this.clone();
        model.setParameter(parameters);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        LIBORCovarianceModelStochasticVolatility lIBORCovarianceModelStochasticVolatility = this;
        synchronized (lIBORCovarianceModelStochasticVolatility) {
            if (this.stochasticVolatilityScalings == null) {
                this.stochasticVolatilityScalings = new ProcessEulerScheme(this.brownianMotion);
                ((AbstractProcess)this.stochasticVolatilityScalings).setModel(new AbstractModelInterface(){

                    @Override
                    public void setProcess(AbstractProcessInterface process) {
                    }

                    @Override
                    public TimeDiscretizationInterface getTimeDiscretization() {
                        return LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getTimeDiscretization();
                    }

                    @Override
                    public AbstractProcessInterface getProcess() {
                        return LIBORCovarianceModelStochasticVolatility.this.stochasticVolatilityScalings;
                    }

                    @Override
                    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
                        return null;
                    }

                    @Override
                    public int getNumberOfFactors() {
                        return 2;
                    }

                    @Override
                    public int getNumberOfComponents() {
                        return 1;
                    }

                    @Override
                    public RandomVariableInterface[] getInitialState() {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(0.0)};
                    }

                    @Override
                    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(LIBORCovarianceModelStochasticVolatility.this.rho * LIBORCovarianceModelStochasticVolatility.this.nu), LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(Math.sqrt(1.0 - LIBORCovarianceModelStochasticVolatility.this.rho * LIBORCovarianceModelStochasticVolatility.this.rho) * LIBORCovarianceModelStochasticVolatility.this.nu)};
                    }

                    @Override
                    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(-0.5 * LIBORCovarianceModelStochasticVolatility.this.nu * LIBORCovarianceModelStochasticVolatility.this.nu)};
                    }

                    @Override
                    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
                        return randomVariable.exp();
                    }

                    @Override
                    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
                        return randomVariable.log();
                    }

                    @Override
                    public RandomVariableInterface getRandomVariableForConstant(double value) {
                        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
                    }

                    @Override
                    public AbstractModelInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
                        throw new UnsupportedOperationException("Method not implemented");
                    }
                });
            }
        }
        RandomVariableInterface stochasticVolatilityScaling = null;
        try {
            stochasticVolatilityScaling = this.stochasticVolatilityScalings.getProcessValue(timeIndex, 0);
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        RandomVariableInterface[] factorLoading = null;
        if (stochasticVolatilityScaling != null) {
            factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
            for (int i = 0; i < factorLoading.length; ++i) {
                factorLoading[i] = factorLoading[i].mult(stochasticVolatilityScaling);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        return null;
    }
}

