/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelThreeParameterExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelMaturityDependentFourParameterExponentialForm;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelExponentialForm7Param
extends AbstractLIBORCovarianceModelParametric {
    private double[] parameter = new double[7];
    private LIBORVolatilityModelMaturityDependentFourParameterExponentialForm volatilityModel;
    private LIBORCorrelationModelThreeParameterExponentialDecay correlationModel;

    public LIBORCovarianceModelExponentialForm7Param(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter[0] = 0.1;
        this.parameter[1] = 0.1;
        this.parameter[2] = 0.1;
        this.parameter[3] = 0.2;
        this.parameter[4] = 0.1;
        this.parameter[5] = 0.1;
        this.parameter[6] = 0.1;
        this.volatilityModel = new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.parameter[0], this.parameter[1], this.parameter[2], this.parameter[3]);
        this.correlationModel = new LIBORCorrelationModelThreeParameterExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.parameter[4], this.parameter[5], this.parameter[6], false);
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelExponentialForm7Param model = new LIBORCovarianceModelExponentialForm7Param(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors());
        model.parameter = this.parameter;
        model.volatilityModel = this.volatilityModel;
        model.correlationModel = this.correlationModel;
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORCovarianceModelExponentialForm7Param model = (LIBORCovarianceModelExponentialForm7Param)this.clone();
        model.parameter = parameters;
        if (parameters[0] != this.parameter[0] || parameters[1] != this.parameter[1] || parameters[2] != this.parameter[2] || parameters[3] != this.parameter[3]) {
            model.volatilityModel = new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameters[0], parameters[1], parameters[2], parameters[3]);
        }
        if (parameters[4] != this.parameter[4] || parameters[5] != this.parameter[5] || parameters[6] != this.parameter[6]) {
            model.correlationModel = new LIBORCorrelationModelThreeParameterExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameters[4], parameters[5], parameters[6], false);
        }
        return model;
    }

    @Override
    public double[] getParameter() {
        return this.parameter;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = new RandomVariableInterface[this.correlationModel.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            RandomVariableInterface volatility;
            factorLoading[factorIndex] = volatility = this.volatilityModel.getVolatility(timeIndex, component);
            factorLoading[factorIndex] = factorLoading[factorIndex].mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }
}

