/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCorrelationModelExponentialDecay
extends LIBORCorrelationModel {
    private final int numberOfFactors;
    private double a;
    private final boolean isCalibrateable;
    private double[][] correlationMatrix;
    private double[][] factorMatrix;

    public LIBORCorrelationModelExponentialDecay(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors, double a, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.isCalibrateable = isCalibrateable;
        this.initialize(numberOfFactors, a);
    }

    public LIBORCorrelationModelExponentialDecay(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors, double a) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.isCalibrateable = false;
        this.initialize(numberOfFactors, a);
    }

    @Override
    public void setParameter(double[] parameter) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = Math.abs(parameter[0]);
        this.initialize(this.numberOfFactors, this.a);
    }

    @Override
    public Object clone() {
        return new LIBORCorrelationModelExponentialDecay(this.timeDiscretization, this.liborPeriodDiscretization, this.numberOfFactors, this.a, this.isCalibrateable);
    }

    @Override
    public double getFactorLoading(int timeIndex, int factor, int component) {
        return this.factorMatrix[component][factor];
    }

    @Override
    public double getCorrelation(int timeIndex, int component1, int component2) {
        return this.correlationMatrix[component1][component2];
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorMatrix[0].length;
    }

    private void initialize(int numberOfFactors, double a) {
        a = Math.max(a, 0.0);
        this.correlationMatrix = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()][this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int row = 0; row < this.correlationMatrix.length; ++row) {
            for (int col = 0; col < this.correlationMatrix[row].length; ++col) {
                this.correlationMatrix[row][col] = Math.exp(-a * Math.abs(this.liborPeriodDiscretization.getTime(row) - this.liborPeriodDiscretization.getTime(col)));
            }
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, numberOfFactors);
        for (int component1 = 0; component1 < this.factorMatrix.length; ++component1) {
            for (int component2 = 0; component2 < component1; ++component2) {
                double correlation = 0.0;
                for (int factor = 0; factor < this.factorMatrix[component1].length; ++factor) {
                    correlation += this.factorMatrix[component1][factor] * this.factorMatrix[component2][factor];
                }
                this.correlationMatrix[component1][component2] = correlation;
                this.correlationMatrix[component2][component1] = correlation;
            }
            this.correlationMatrix[component1][component1] = 1.0;
        }
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] parameter = new double[]{this.a};
        return parameter;
    }
}

