/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariableInterface;

public class HullWhiteLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private final AbstractLIBORCovarianceModelParametric covarianceModel;
    private final double periodLength;

    public HullWhiteLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double periodLength) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.periodLength = periodLength;
    }

    @Override
    public Object clone() {
        return new HullWhiteLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.periodLength);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public double[] getParameter() {
        return this.covarianceModel.getParameter();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return new HullWhiteLocalVolatilityModel(this.covarianceModel.getCloneWithModifiedParameters(parameters), this.periodLength);
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariableInterface localVolatilityFactor = realizationAtTimeIndex[component].mult(this.periodLength).add(1.0);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }
}

