/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractLIBORCovarianceModelParametric
extends AbstractLIBORCovarianceModel {
    private static final Logger logger = Logger.getLogger("net.finmath");

    public AbstractLIBORCovarianceModelParametric(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
    }

    public abstract double[] getParameter();

    public abstract Object clone();

    public abstract AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] var1);

    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(LIBORMarketModelInterface calibrationModel, AbstractLIBORMonteCarloProduct[] calibrationProducts, double[] calibrationTargetValues, double[] calibrationWeights) throws CalculationException {
        return this.getCloneCalibrated(calibrationModel, calibrationProducts, calibrationTargetValues, calibrationWeights, null);
    }

    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(final LIBORMarketModelInterface calibrationModel, final AbstractLIBORMonteCarloProduct[] calibrationProducts, final double[] calibrationTargetValues, double[] calibrationWeights, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer numberOfPathsParameter = (Integer)calibrationParameters.get("numberOfPaths");
        Integer seedParameter = (Integer)calibrationParameters.get("seed");
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        BrownianMotionInterface brownianMotionParameter = (BrownianMotionInterface)calibrationParameters.get("brownianMotion");
        double[] initialParameters = this.getParameter();
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        double[] parameterStep = new double[initialParameters.length];
        double[] zero = new double[calibrationTargetValues.length];
        Arrays.fill(lowerBound, Double.NEGATIVE_INFINITY);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        Arrays.fill(parameterStep, parameterStepParameter != null ? parameterStepParameter : 1.0E-4);
        Arrays.fill(zero, 0.0);
        int numberOfThreads = 2;
        OptimizerFactoryInterface optimizerFactoryParameter = (OptimizerFactoryInterface)calibrationParameters.get("optimizerFactory");
        int numberOfPaths = numberOfPathsParameter != null ? numberOfPathsParameter : 2000;
        int seed = seedParameter != null ? seedParameter : 31415;
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 400;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-7;
        final BrownianMotionInterface brownianMotion = brownianMotionParameter != null ? brownianMotionParameter : new BrownianMotion(this.getTimeDiscretization(), this.getNumberOfFactors(), numberOfPaths, seed);
        OptimizerFactoryInterface optimizerFactory = optimizerFactoryParameter != null ? optimizerFactoryParameter : new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, numberOfThreads);
        int numberOfThreadsForProductValuation = 2 * Math.max(2, Runtime.getRuntime().availableProcessors());
        final ExecutorService executor = null;
        OptimizerInterface.ObjectiveFunction calibrationError = new OptimizerInterface.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                int calibrationProductIndex;
                AbstractLIBORCovarianceModelParametric calibrationCovarianceModel = AbstractLIBORCovarianceModelParametric.this.getCloneWithModifiedParameters(parameters);
                LIBORMarketModelInterface model = calibrationModel.getCloneWithModifiedCovarianceModel(calibrationCovarianceModel);
                ProcessEulerScheme process = new ProcessEulerScheme(brownianMotion);
                final LIBORModelMonteCarloSimulation liborMarketModelMonteCarloSimulation = new LIBORModelMonteCarloSimulation(model, process);
                ArrayList<Future<Double>> valueFutures = new ArrayList<Future<Double>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    Callable<Double> worker = new Callable<Double>(){

                        @Override
                        public Double call() throws SolverException {
                            try {
                                return calibrationProducts[workerCalibrationProductIndex].getValue(liborMarketModelMonteCarloSimulation);
                            }
                            catch (CalculationException e) {
                                return calibrationTargetValues[workerCalibrationProductIndex];
                            }
                            catch (Exception e) {
                                return calibrationTargetValues[workerCalibrationProductIndex];
                            }
                        }
                    };
                    if (executor != null) {
                        Future<Double> valueFuture = executor.submit(worker);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    FutureTask<Double> valueFutureTask = new FutureTask<Double>(worker);
                    valueFutureTask.run();
                    valueFutures.add(calibrationProductIndex, valueFutureTask);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        double value;
                        values[calibrationProductIndex] = value = ((Double)((Future)valueFutures.get(calibrationProductIndex)).get()).doubleValue();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new SolverException(e);
                    }
                    catch (ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
            }
        };
        OptimizerInterface optimizer = optimizerFactory.getOptimizer(calibrationError, initialParameters, lowerBound, upperBound, parameterStep, calibrationTargetValues);
        try {
            optimizer.run();
        }
        catch (SolverException e) {
            throw new CalculationException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        double[] bestParameters = optimizer.getBestFitParameters();
        AbstractLIBORCovarianceModelParametric calibrationCovarianceModel = this.getCloneWithModifiedParameters(bestParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
            String logString = "Best parameters:";
            for (int i = 0; i < bestParameters.length; ++i) {
                logString = logString + "\tparameter[" + i + "]: " + bestParameters[i];
            }
            logger.fine(logString);
        }
        return calibrationCovarianceModel;
    }

    public String toString() {
        return "AbstractLIBORCovarianceModelParametric [getParameter()=" + Arrays.toString(this.getParameter()) + "]";
    }
}

