/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.LIBORModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORModelMonteCarloSimulation
implements LIBORModelMonteCarloSimulationInterface {
    private final LIBORModelInterface model;

    public LIBORModelMonteCarloSimulation(LIBORModelInterface model, AbstractProcess process) {
        this.model = model;
        this.model.setProcess(process);
        process.setModel(model);
    }

    public LIBORModelMonteCarloSimulation(LIBORModelInterface model) {
        this.model = model;
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.model.getProcess().getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.model.getProcess().getTime(timeIndex);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.model.getProcess().getTimeIndex(time);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return (BrownianMotionInterface)this.model.getProcess().getStochasticDriver();
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.model.getLIBOR(timeIndex, liborIndex);
    }

    @Override
    public RandomVariableInterface[] getLIBORs(int timeIndex) throws CalculationException {
        RandomVariableInterface[] randomVariableVector = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            randomVariableVector[componentIndex] = this.getLIBOR(timeIndex, componentIndex);
        }
        return randomVariableVector;
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.model.getLIBOR(time, periodStart, periodEnd);
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.model.getLiborPeriod(timeIndex);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.model.getLiborPeriodDiscretization();
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.model.getLiborPeriodIndex(time);
    }

    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    @Override
    public int getNumberOfLibors() {
        return this.model.getNumberOfLibors();
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(time);
    }

    @Override
    public LIBORModelInterface getModel() {
        return this.model;
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.model.getProcess();
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        AbstractProcess process = (AbstractProcess)((AbstractProcess)this.getProcess()).getCloneWithModifiedSeed(seed);
        return new LIBORModelMonteCarloSimulation(this.model, process);
    }

    @Override
    public LIBORModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TermStructureModelInterface modelClone = this.model.getCloneWithModifiedData((Map)dataModified);
        if (dataModified.containsKey("discountCurve") && dataModified.size() == 1) {
            LIBORModelMonteCarloSimulation lmmSimClone = new LIBORModelMonteCarloSimulation((LIBORModelInterface)modelClone);
            modelClone.setProcess(this.getProcess());
            return lmmSimClone;
        }
        return new LIBORModelMonteCarloSimulation((LIBORModelInterface)modelClone, (AbstractProcess)this.getProcess().clone());
    }

    public LIBORModelMonteCarloSimulationInterface getCloneWithModifiedData(String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getCloneWithModifiedData(dataModifiedMap);
    }
}

