/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORMarketModelStandard
extends AbstractModel
implements LIBORMarketModelInterface {
    private static final boolean isUseAnalyticApproximation = Boolean.parseBoolean(System.getProperty("net.finmath.montecarlo.interestrate.LIBORMarketModelStandard.isUseAnalyticApproximation", "true"));
    private final TimeDiscretizationInterface liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private AbstractLIBORCovarianceModel covarianceModel;
    private AbstractSwaptionMarketData swaptionMarketData;
    private Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private double[][][] integratedLIBORCovariance;

    public LIBORMarketModelStandard(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, AbstractLIBORCovarianceModel covarianceModel) {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.forwardRateCurve = forwardRateCurve;
        this.covarianceModel = covarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel) {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.covarianceModel = covarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, AbstractLIBORCovarianceModel covarianceModel, AbstractSwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, null, covarianceModel, LIBORMarketModelStandard.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, AbstractSwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, LIBORMarketModelStandard.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, CalibrationItem[] calibrationItems) throws CalculationException {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        double[] times = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = liborPeriodDiscretization.getTime(i);
        }
        AbstractLIBORCovarianceModelParametric covarianceModelParametric = null;
        try {
            covarianceModelParametric = (AbstractLIBORCovarianceModelParametric)covarianceModel;
        }
        catch (Exception e) {
            throw new ClassCastException("Calibration is currently restricted to parametric covariance models (AbstractLIBORCovarianceModelParametric).");
        }
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        AbstractLIBORMonteCarloProduct[] calibrationProducts = new AbstractLIBORMonteCarloProduct[calibrationItems.length];
        double[] calibrationTargetValues = new double[calibrationItems.length];
        double[] calibrationWeights = new double[calibrationItems.length];
        for (int i = 0; i < calibrationTargetValues.length; ++i) {
            calibrationProducts[i] = calibrationItems[i].calibrationProduct;
            calibrationTargetValues[i] = calibrationItems[i].calibrationTargetValue;
            calibrationWeights[i] = calibrationItems[i].calibrationWeight;
        }
        this.covarianceModel = covarianceModelParametric.getCloneCalibrated(this, calibrationProducts, calibrationTargetValues, calibrationWeights);
    }

    private static CalibrationItem[] getCalibrationItems(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardCurve, AbstractSwaptionMarketData swaptionMarketData) {
        if (swaptionMarketData == null) {
            return null;
        }
        TimeDiscretizationInterface optionMaturities = swaptionMarketData.getOptionMaturities();
        TimeDiscretizationInterface tenor = swaptionMarketData.getTenor();
        double swapPeriodLength = swaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationItem> calibrationItems = new ArrayList<CalibrationItem>();
        for (int exerciseIndex = 0; exerciseIndex <= optionMaturities.getNumberOfTimeSteps(); ++exerciseIndex) {
            for (int tenorIndex = 0; tenorIndex <= tenor.getNumberOfTimeSteps() - exerciseIndex; ++tenorIndex) {
                AbstractLIBORMonteCarloProduct swaption;
                double exerciseDate = optionMaturities.getTime(exerciseIndex);
                double swapLength = tenor.getTime(tenorIndex);
                if (liborPeriodDiscretization.getTimeIndex(exerciseDate) < 0 || liborPeriodDiscretization.getTimeIndex(exerciseDate + swapLength) <= liborPeriodDiscretization.getTimeIndex(exerciseDate)) continue;
                int numberOfPeriods = (int)(swapLength / swapPeriodLength);
                double[] fixingDates = new double[numberOfPeriods];
                double[] paymentDates = new double[numberOfPeriods];
                double[] swapTenorTimes = new double[numberOfPeriods + 1];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    fixingDates[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                    paymentDates[periodStartIndex] = exerciseDate + (double)(periodStartIndex + 1) * swapPeriodLength;
                    swapTenorTimes[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                }
                swapTenorTimes[numberOfPeriods] = exerciseDate + (double)numberOfPeriods * swapPeriodLength;
                RegularSchedule swapTenor = new RegularSchedule(new TimeDiscretization(swapTenorTimes));
                double swaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve, null);
                double[] swaprates = new double[numberOfPeriods];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    swaprates[periodStartIndex] = swaprate;
                }
                if (isUseAnalyticApproximation) {
                    swaption = new SwaptionAnalyticApproximation(swaprate, swapTenorTimes, SwaptionAnalyticApproximation.ValueUnit.VOLATILITY);
                    double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                    calibrationItems.add(new CalibrationItem(swaption, impliedVolatility, 1.0));
                    continue;
                }
                swaption = new SwaptionSimple(swaprate, swapTenorTimes, SwaptionSimple.ValueUnit.VALUE);
                double forwardSwaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve);
                double swapAnnuity = SwapAnnuity.getSwapAnnuity((ScheduleInterface)swapTenor, forwardCurve);
                double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                double targetValue = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate, impliedVolatility, exerciseDate, swaprate, swapAnnuity);
                calibrationItems.add(new CalibrationItem(swaption, targetValue, 1.0));
            }
        }
        return calibrationItems.toArray(new CalibrationItem[calibrationItems.size()]);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        int timeIndex = this.getLiborPeriodIndex(time);
        if (timeIndex < 0) {
            int lowerIndex = -timeIndex - 1;
            int upperIndex = -timeIndex;
            double alpha = (time - this.getLiborPeriod(lowerIndex)) / (this.getLiborPeriod(upperIndex) - this.getLiborPeriod(lowerIndex));
            return this.getNumeraire(this.getLiborPeriod(upperIndex)).invert().mult(alpha).add(this.getNumeraire(this.getLiborPeriod(lowerIndex)).invert().mult(1.0 - alpha)).invert();
        }
        int firstLiborIndex = this.getLiborPeriodIndex(time);
        if (firstLiborIndex < 0) {
            throw new CalculationException("Simulation time discretization not part of forward rate tenor discretization.");
        }
        int lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            firstLiborIndex = 0;
            lastLiborIndex = this.getLiborPeriodIndex(time) - 1;
        }
        RandomVariableInterface numeraire = new RandomVariable(time, 1.0);
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            RandomVariableInterface libor = this.getLIBOR(this.getTimeIndex(Math.min(time, this.liborPeriodDiscretization.getTime(liborIndex))), liborIndex);
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            numeraire = this.measure == Measure.SPOT ? numeraire.accrue(libor, periodLength) : numeraire.discount(libor, periodLength);
        }
        if (this.discountCurve != null) {
            DiscountCurveFromForwardCurve discountcountCurveFromForwardPerformance = new DiscountCurveFromForwardCurve(this.forwardRateCurve);
            double deterministicNumeraireAdjustment = discountcountCurveFromForwardPerformance.getDiscountFactor(time) / this.discountCurve.getDiscountFactor(time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        double[] liborInitialStates = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int timeIndex = 0; timeIndex < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double rate = this.forwardRateCurve.getForward(null, this.liborPeriodDiscretization.getTime(timeIndex));
            liborInitialStates[timeIndex] = Math.log(rate);
        }
        RandomVariableInterface[] initialStateRandomVariable = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = new RandomVariable(liborInitialStates[componentIndex]);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        int componentIndex;
        double time = this.getTime(timeIndex);
        int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
        if (firstLiborIndex < 0) {
            firstLiborIndex = -firstLiborIndex - 1 + 1;
        }
        RandomVariableInterface[] drift = new RandomVariableInterface[this.getNumberOfComponents()];
        RandomVariableInterface[][] covarianceFactorSums = new RandomVariableInterface[this.getNumberOfComponents()][this.getNumberOfFactors()];
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            drift[componentIndex] = new RandomVariable(0.0);
        }
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            int factorIndex;
            double periodLength = this.liborPeriodDiscretization.getTimeStep(componentIndex);
            RandomVariableInterface libor = realizationAtTimeIndex[componentIndex];
            RandomVariableInterface oneStepMeasureTransform = libor.discount(libor, periodLength).mult(periodLength);
            RandomVariableInterface[] factorLoading = this.getFactorLoading(timeIndex, componentIndex, realizationAtTimeIndex);
            RandomVariableInterface[] covarianceFactors = new RandomVariableInterface[this.getNumberOfFactors()];
            for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                covarianceFactors[factorIndex] = factorLoading[factorIndex].mult(oneStepMeasureTransform);
                covarianceFactorSums[componentIndex][factorIndex] = covarianceFactors[factorIndex];
                if (componentIndex <= firstLiborIndex) continue;
                covarianceFactorSums[componentIndex][factorIndex] = covarianceFactorSums[componentIndex][factorIndex].add(covarianceFactorSums[componentIndex - 1][factorIndex]);
            }
            for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                drift[componentIndex] = drift[componentIndex].addProduct(covarianceFactorSums[componentIndex][factorIndex], factorLoading[factorIndex]);
            }
        }
        if (this.measure == Measure.TERMINAL) {
            for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                drift[componentIndex] = drift[componentIndex].sub(drift[this.getNumberOfComponents() - 1]);
            }
        }
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            RandomVariableInterface variance = this.covarianceModel.getCovariance(timeIndex, componentIndex, componentIndex, realizationAtTimeIndex);
            drift[componentIndex] = drift[componentIndex].addProduct(variance, -0.5);
        }
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
        return this.covarianceModel.getFactorLoading(timeIndex, componentIndex, realizationAtTimeIndex);
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        int periodStartIndex = this.getLiborPeriodIndex(periodStart);
        int periodEndIndex = this.getLiborPeriodIndex(periodEnd);
        if (periodEndIndex < 0) {
            int previousEndIndex = -periodEndIndex - 1 - 1;
            double previousEndTime = this.getLiborPeriod(previousEndIndex);
            double nextEndTime = this.getLiborPeriod(previousEndIndex + 1);
            RandomVariableInterface liborLongPeriod = this.getLIBOR(time, periodStart, nextEndTime);
            RandomVariableInterface liborShortPeriod = this.getLIBOR(time, previousEndTime, nextEndTime);
            RandomVariableInterface libor = liborLongPeriod.mult(nextEndTime - periodStart).add(1.0).div(liborShortPeriod.mult(nextEndTime - previousEndTime).add(1.0).log().mult((nextEndTime - periodEnd) / (nextEndTime - previousEndTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, periodEnd - previousEndTime);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, nextEndTime - previousEndTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) * (nextEndTime - periodEnd) / (nextEndTime - previousEndTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodEnd - previousEndTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).mult(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0) {
            int previousStartIndex = -periodStartIndex - 1 - 1;
            double previousStartTime = this.getLiborPeriod(previousStartIndex);
            double nextStartTime = this.getLiborPeriod(previousStartIndex + 1);
            RandomVariableInterface liborLongPeriod = this.getLIBOR(time, previousStartTime, periodEnd);
            RandomVariableInterface liborShortPeriod = this.getLIBOR(time, previousStartTime, nextStartTime);
            RandomVariableInterface libor = liborLongPeriod.mult(periodEnd - previousStartTime).add(1.0).div(liborShortPeriod.mult(nextStartTime - previousStartTime).add(1.0).log().mult((periodStart - previousStartTime) / (nextStartTime - previousStartTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - periodStart);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - previousStartTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) * (nextStartTime - periodStart) / (nextStartTime - previousStartTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodStart - previousStartTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).div(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0 || periodEndIndex < 0) {
            throw new AssertionError((Object)"LIBOR requested outside libor discretization points and interpolation was not performed.");
        }
        int timeIndex = this.getTimeIndex(time = Math.min(time, periodStart));
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        if (periodStartIndex + 1 == periodEndIndex) {
            return this.getLIBOR(timeIndex, periodStartIndex);
        }
        RandomVariableInterface accrualAccount = this.getProcess().getStochasticDriver().getRandomVariableForConstant(1.0);
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double subPeriodLength = this.getLiborPeriod(periodIndex + 1) - this.getLiborPeriod(periodIndex);
            RandomVariableInterface liborOverSubPeriod = this.getLIBOR(timeIndex, periodIndex);
            accrualAccount = accrualAccount.accrue(liborOverSubPeriod, subPeriodLength);
        }
        RandomVariableInterface libor = accrualAccount.sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.getProcessValue(timeIndex, liborIndex);
    }

    @Override
    public int getNumberOfComponents() {
        return this.getNumberOfLibors();
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        if (timeIndex >= this.liborPeriodDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds.");
        }
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    private RandomVariableInterface getDrift(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        if (this.getTime(timeIndex) >= this.getLiborPeriod(componentIndex)) {
            return null;
        }
        if (this.driftApproximationMethod == Driftapproximation.PREDICTOR_CORRECTOR && realizationPredictor != null) {
            RandomVariableInterface drift = this.getDriftEuler(timeIndex, componentIndex, realizationAtTimeIndex);
            RandomVariableInterface driftEulerWithPredictor = this.getDriftEuler(timeIndex, componentIndex, realizationPredictor);
            drift = drift.add(driftEulerWithPredictor).div(2.0);
            return drift;
        }
        if (this.driftApproximationMethod == Driftapproximation.LINE_INTEGRAL && realizationPredictor != null) {
            return this.getDriftLineIntegral(timeIndex, componentIndex, realizationAtTimeIndex, realizationPredictor);
        }
        return this.getDriftEuler(timeIndex, componentIndex, realizationAtTimeIndex);
    }

    protected RandomVariableInterface getDriftEuler(int timeIndex, int componentIndex, RandomVariableInterface[] liborVectorStart) {
        int lastLiborIndex;
        double time = this.getTime(timeIndex);
        RandomVariableInterface drift = new RandomVariable(time, 0.0);
        switch (this.measure) {
            case SPOT: {
                int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
                if (firstLiborIndex < 0) {
                    firstLiborIndex = -firstLiborIndex - 1 + 1;
                }
                lastLiborIndex = componentIndex;
                break;
            }
            default: {
                int firstLiborIndex = componentIndex + 1;
                lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            RandomVariableInterface covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariableInterface[])null);
            RandomVariableInterface libor = liborVectorStart[liborIndex];
            covariance = covariance.mult(periodLength).mult(libor).discount(libor, periodLength);
            drift = drift.add(covariance);
        }
        if (this.measure == Measure.TERMINAL) {
            drift = drift.mult(-1.0);
        }
        RandomVariableInterface variance = this.covarianceModel.getCovariance(timeIndex, componentIndex, componentIndex, (RandomVariableInterface[])null);
        drift = drift.addProduct(variance, -0.5);
        return drift;
    }

    private RandomVariableInterface getDriftLineIntegral(int timeIndex, int componentIndex, RandomVariableInterface[] liborVectorStart, RandomVariableInterface[] liborVectorEnd) {
        int lastLiborIndex;
        double time = this.getTime(timeIndex);
        if (this.getTime(timeIndex) >= this.getLiborPeriod(componentIndex)) {
            return null;
        }
        RandomVariableInterface drift = new RandomVariable(time, 0.0);
        switch (this.measure) {
            case SPOT: {
                int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
                if (firstLiborIndex < 0) {
                    firstLiborIndex = -firstLiborIndex - 1 + 1;
                }
                lastLiborIndex = componentIndex;
                break;
            }
            default: {
                int firstLiborIndex = componentIndex + 1;
                lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            RandomVariableInterface covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariableInterface[])null);
            RandomVariableInterface driftTerm = new RandomVariable(1.0);
            driftTerm = driftTerm.accrue(liborVectorEnd[liborIndex], periodLength);
            driftTerm = driftTerm.discount(liborVectorStart[liborIndex], periodLength);
            driftTerm = driftTerm.log();
            driftTerm = driftTerm.mult(covariance);
            driftTerm = driftTerm.div(liborVectorEnd[liborIndex].div(liborVectorStart[liborIndex]).log());
            drift = drift.sub(driftTerm);
        }
        return drift;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public synchronized double[][][] getIntegratedLIBORCovariance() {
        if (this.integratedLIBORCovariance != null) {
            return this.integratedLIBORCovariance;
        }
        TimeDiscretizationInterface liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        TimeDiscretizationInterface simulationTimeDiscretization = this.getTimeDiscretization();
        this.integratedLIBORCovariance = new double[simulationTimeDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
            for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                double integratedLIBORCovarianceValue = 0.0;
                for (int timeIndex = 0; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double dt = this.getTime(timeIndex + 1) - this.getTime(timeIndex);
                    RandomVariableInterface[] factorLoadingOfComponent1 = this.getCovarianceModel().getFactorLoading(timeIndex, componentIndex1, (RandomVariableInterface[])null);
                    RandomVariableInterface[] factorLoadingOfComponent2 = this.getCovarianceModel().getFactorLoading(timeIndex, componentIndex2, (RandomVariableInterface[])null);
                    for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                        integratedLIBORCovarianceValue += factorLoadingOfComponent1[factorIndex].get(0) * factorLoadingOfComponent2[factorIndex].get(0) * dt;
                    }
                    this.integratedLIBORCovariance[timeIndex][componentIndex1][componentIndex2] = integratedLIBORCovarianceValue;
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    public Object clone() {
        return new LIBORMarketModelStandard(this.liborPeriodDiscretization, this.forwardRateCurve, this.covarianceModel);
    }

    public void setDriftApproximationMethod(Driftapproximation driftApproximationMethod) {
        this.driftApproximationMethod = driftApproximationMethod;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        if (this.discountCurve == null) {
            DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(this.getForwardRateCurve());
            return discountCurveFromForwardCurve;
        }
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public AbstractSwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public LIBORMarketModelStandard getCloneWithModifiedCovarianceModel(AbstractLIBORCovarianceModel covarianceModel) {
        LIBORMarketModelStandard model = (LIBORMarketModelStandard)this.clone();
        model.covarianceModel = covarianceModel;
        return model;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretizationInterface liborPeriodDiscretization = this.liborPeriodDiscretization;
        AnalyticModelInterface analyticModel = this.curveModel;
        ForwardCurveInterface forwardRateCurve = this.forwardRateCurve;
        AbstractLIBORCovarianceModel covarianceModel = this.covarianceModel;
        AbstractSwaptionMarketData swaptionMarketData = null;
        if (dataModified.containsKey("liborPeriodDiscretization")) {
            liborPeriodDiscretization = (TimeDiscretizationInterface)dataModified.get("liborPeriodDiscretization");
        }
        if (dataModified.containsKey("forwardRateCurve")) {
            forwardRateCurve = (ForwardCurveInterface)dataModified.get("forwardRateCurve");
        }
        if (dataModified.containsKey("forwardRateShift")) {
            throw new RuntimeException("Forward rate shift clone currently disabled.");
        }
        if (dataModified.containsKey("covarianceModel")) {
            covarianceModel = (AbstractLIBORCovarianceModel)dataModified.get("covarianceModel");
        }
        if (dataModified.containsKey("swaptionMarketData")) {
            swaptionMarketData = (AbstractSwaptionMarketData)dataModified.get("swaptionMarketData");
        }
        if (swaptionMarketData == null) {
            return new LIBORMarketModel(liborPeriodDiscretization, forwardRateCurve, covarianceModel);
        }
        return new LIBORMarketModel(liborPeriodDiscretization, forwardRateCurve, covarianceModel, swaptionMarketData);
    }

    public static class CalibrationItem {
        public final AbstractLIBORMonteCarloProduct calibrationProduct;
        public final double calibrationTargetValue;
        public final double calibrationWeight;

        public CalibrationItem(AbstractLIBORMonteCarloProduct calibrationProduct, double calibrationTargetValue, double calibrationWeight) {
            this.calibrationProduct = calibrationProduct;
            this.calibrationTargetValue = calibrationTargetValue;
            this.calibrationWeight = calibrationWeight;
        }
    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

