/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.conditionalexpectation;

import net.finmath.functions.LinearAlgebra;
import net.finmath.stochastic.ConditionalExpectationEstimatorInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class MonteCarloConditionalExpectationRegression
implements ConditionalExpectationEstimatorInterface {
    private RandomVariableInterface[] basisFunctionsEstimator = null;
    private RandomVariableInterface[] basisFunctionsPredictor = null;

    public MonteCarloConditionalExpectationRegression(RandomVariableInterface[] basisFunctions) {
        this.basisFunctionsEstimator = basisFunctions;
        this.basisFunctionsPredictor = basisFunctions;
    }

    public MonteCarloConditionalExpectationRegression(RandomVariableInterface[] basisFunctionsEstimator, RandomVariableInterface[] basisFunctionsPredictor) {
        this.basisFunctionsEstimator = basisFunctionsEstimator;
        this.basisFunctionsPredictor = basisFunctionsPredictor;
    }

    @Override
    public RandomVariableInterface getConditionalExpectation(RandomVariableInterface randomVariable) {
        double[] linearRegressionParameters = this.getLinearRegressionParameters(randomVariable);
        RandomVariableInterface[] basisFunctions = this.getNonZeroBasisFunctions(this.basisFunctionsPredictor);
        RandomVariableInterface conditionalExpectation = basisFunctions[0].mult(linearRegressionParameters[0]);
        for (int i = 1; i < basisFunctions.length; ++i) {
            conditionalExpectation = conditionalExpectation.addProduct(basisFunctions[i], linearRegressionParameters[i]);
        }
        return conditionalExpectation;
    }

    public double[] getLinearRegressionParameters(RandomVariableInterface dependents) {
        RandomVariableInterface[] basisFunctions = this.getNonZeroBasisFunctions(this.basisFunctionsEstimator);
        double[][] XTX = new double[basisFunctions.length][basisFunctions.length];
        for (int i = 0; i < basisFunctions.length; ++i) {
            for (int j = i; j < basisFunctions.length; ++j) {
                XTX[i][j] = basisFunctions[i].mult(basisFunctions[j]).getAverage();
                XTX[j][i] = XTX[i][j];
            }
        }
        double[] XTy = new double[basisFunctions.length];
        for (int i = 0; i < basisFunctions.length; ++i) {
            XTy[i] = dependents.mult(basisFunctions[i]).getAverage();
        }
        double[] linearRegressionParameters = LinearAlgebra.solveLinearEquationLeastSquare(XTX, XTy);
        return linearRegressionParameters;
    }

    private RandomVariableInterface[] getNonZeroBasisFunctions(RandomVariableInterface[] basisFunctions) {
        int numberOfNonZeroBasisFunctions = 0;
        for (int indexBasisFunction = 0; indexBasisFunction < basisFunctions.length; ++indexBasisFunction) {
            if (basisFunctions[indexBasisFunction] == null) continue;
            ++numberOfNonZeroBasisFunctions;
        }
        RandomVariableInterface[] nonZerobasisFunctions = new RandomVariableInterface[numberOfNonZeroBasisFunctions];
        int indexOfNonZeroBasisFunctions = 0;
        for (RandomVariableInterface basisFunction : basisFunctions) {
            if (basisFunction == null) continue;
            nonZerobasisFunctions[indexOfNonZeroBasisFunctions] = basisFunction;
            ++indexOfNonZeroBasisFunctions;
        }
        return nonZerobasisFunctions;
    }
}

