/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariableInterface;

public class BermudanDigitalOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private int orderOfRegressionPolynomial = 4;
    private boolean intrinsicValueAsBasisFunction = true;
    private ExerciseMethod exerciseMethod = ExerciseMethod.ESTIMATE_COND_EXPECTATION;

    public BermudanDigitalOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod, Map<String, Object> properties) {
        this.exerciseDates = exerciseDates;
        this.notionals = notionals;
        this.strikes = strikes;
        this.exerciseMethod = exerciseMethod;
        this.orderOfRegressionPolynomial = (Integer)properties.getOrDefault("orderOfRegressionPolynomial", 4);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch optimizer = new GoldenSectionSearch(-1.0, 1.0);
            while (!optimizer.isDone()) {
                double lambda = optimizer.getNextPoint();
                double value = this.getValues(evaluationTime, model, lambda).getAverage();
                optimizer.setValue(value);
            }
            return this.getValues(evaluationTime, model, optimizer.getBestPoint());
        }
        return this.getValues(evaluationTime, model, 0.0);
    }

    private RandomVariableInterface getValues(double evaluationTime, AssetModelMonteCarloSimulationInterface model, double lambda) throws CalculationException {
        RandomVariableInterface value = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface exerciseTime = model.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        RandomVariableInterface one = model.getRandomVariableForConstant(1.0);
        for (int exerciseDateIndex = this.exerciseDates.length - 1; exerciseDateIndex >= 0; --exerciseDateIndex) {
            double exerciseDate = this.exerciseDates[exerciseDateIndex];
            double notional = this.notionals[exerciseDateIndex];
            double strike = this.strikes[exerciseDateIndex];
            RandomVariableInterface underlyingAtExercise = model.getAssetValue(exerciseDate, 0);
            RandomVariableInterface numeraireAtPayment = model.getNumeraire(exerciseDate);
            RandomVariableInterface monteCarloWeights = model.getMonteCarloWeights(exerciseDate);
            RandomVariableInterface valueOfPaymentsIfExercised = one.mult(notional).div(numeraireAtPayment);
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(underlyingAtExercise));
            RandomVariableInterface underlying = null;
            RandomVariableInterface trigger = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    RandomVariableInterface valueIfNotExcercisedEstimated = value.getConditionalExpectation(condExpEstimator);
                    underlying = underlyingAtExercise.sub(strike).mult(notional).div(numeraireAtPayment);
                    trigger = underlying.sub(valueIfNotExcercisedEstimated);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    throw new UnsupportedOperationException((Object)((Object)this.exerciseMethod) + " is currently not supported.");
                }
            }
            value = value.barrier(trigger, valueOfPaymentsIfExercised, value);
            exerciseTime = exerciseTime.barrier(trigger, exerciseTime, exerciseDate);
        }
        RandomVariableInterface numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtZero);
        return value;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(RandomVariableInterface underlying) {
        RandomVariableInterface[] basisFunctions = new RandomVariableInterface[this.orderOfRegressionPolynomial + 1];
        basisFunctions[0] = new RandomVariable(1.0);
        basisFunctions[1] = underlying;
        for (int powerOfRegressionMonomial = 2; powerOfRegressionMonomial <= this.orderOfRegressionPolynomial; ++powerOfRegressionMonomial) {
            basisFunctions[powerOfRegressionMonomial] = underlying.pow(powerOfRegressionMonomial);
        }
        return basisFunctions;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

