/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;

public class HestonModel
extends AbstractModel {
    private final RandomVariableInterface initialValue;
    private final RandomVariableInterface riskFreeRate;
    private final RandomVariableInterface volatility;
    private final RandomVariableInterface discountRate;
    private final RandomVariableInterface theta;
    private final RandomVariableInterface kappa;
    private final RandomVariableInterface xi;
    private final RandomVariableInterface rho;
    private final RandomVariableInterface rhoBar;
    private final Scheme scheme;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[2];

    public HestonModel(RandomVariableInterface initialValue, RandomVariableInterface riskFreeRate, RandomVariableInterface volatility, RandomVariableInterface discountRate, RandomVariableInterface theta, RandomVariableInterface kappa, RandomVariableInterface xi, RandomVariableInterface rho, Scheme scheme, AbstractRandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountRate = discountRate;
        this.theta = theta;
        this.kappa = kappa;
        this.xi = xi;
        this.rho = rho;
        this.rhoBar = rho.squared().sub(1.0).mult(-1.0).sqrt();
        this.scheme = scheme;
        this.randomVariableFactory = randomVariableFactory;
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double theta, double kappa, double xi, double rho, Scheme scheme, AbstractRandomVariableFactory randomVariableFactory) {
        this(randomVariableFactory.createRandomVariable(initialValue), randomVariableFactory.createRandomVariable(riskFreeRate), randomVariableFactory.createRandomVariable(volatility), randomVariableFactory.createRandomVariable(discountRate), randomVariableFactory.createRandomVariable(theta), randomVariableFactory.createRandomVariable(kappa), randomVariableFactory.createRandomVariable(xi), randomVariableFactory.createRandomVariable(rho), scheme, randomVariableFactory);
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double theta, double kappa, double xi, double rho, Scheme scheme) {
        this(initialValue, riskFreeRate, volatility, discountRate, theta, kappa, xi, rho, scheme, (AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double theta, double kappa, double xi, double rho, Scheme scheme) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate, theta, kappa, xi, rho, scheme, (AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialValueVector[0] == null) {
            this.initialValueVector[0] = this.initialValue.log();
            this.initialValueVector[1] = this.volatility.squared();
        }
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        RandomVariableInterface stochasticVariance;
        if (this.scheme == Scheme.FULL_TRUNCATION) {
            stochasticVariance = realizationAtTimeIndex[1].floor(0.0);
        } else if (this.scheme == Scheme.REFLECTION) {
            stochasticVariance = realizationAtTimeIndex[1].abs();
        } else {
            throw new UnsupportedOperationException("Scheme " + this.scheme.name() + " not supported.");
        }
        RandomVariableInterface[] drift = new RandomVariableInterface[]{this.riskFreeRate.sub(stochasticVariance.div(2.0)), this.theta.sub(stochasticVariance).mult(this.kappa)};
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface stochasticVolatility;
        if (this.scheme == Scheme.FULL_TRUNCATION) {
            stochasticVolatility = realizationAtTimeIndex[1].floor(0.0).sqrt();
        } else if (this.scheme == Scheme.REFLECTION) {
            stochasticVolatility = realizationAtTimeIndex[1].abs().sqrt();
        } else {
            throw new UnsupportedOperationException("Scheme " + this.scheme.name() + " not supported.");
        }
        RandomVariableInterface[] factorLoadings = new RandomVariableInterface[2];
        if (component == 0) {
            factorLoadings[0] = stochasticVolatility;
            factorLoadings[1] = this.getRandomVariableForConstant(0.0);
        } else if (component == 1) {
            RandomVariableInterface volatility = stochasticVolatility.mult(this.xi);
            factorLoadings[0] = volatility.mult(this.rho);
            factorLoadings[1] = volatility.mult(this.rhoBar);
        } else {
            throw new UnsupportedOperationException("Component " + component + " does not exist.");
        }
        return factorLoadings;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        if (componentIndex == 0) {
            return randomVariable.exp();
        }
        if (componentIndex == 1) {
            return randomVariable;
        }
        throw new UnsupportedOperationException("Component " + componentIndex + " does not exist.");
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        if (componentIndex == 0) {
            return randomVariable.log();
        }
        if (componentIndex == 1) {
            return randomVariable;
        }
        throw new UnsupportedOperationException("Component " + componentIndex + " does not exist.");
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        return this.discountRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 2;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public HestonModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableInterface newInitialValue = this.getRandomVariableForValue(dataModified.getOrDefault("initialValue", this.initialValue));
        RandomVariableInterface newRiskFreeRate = this.getRandomVariableForValue(dataModified.getOrDefault("riskFreeRate", this.riskFreeRate));
        RandomVariableInterface newVolatility = this.getRandomVariableForValue(dataModified.getOrDefault("volatility", this.volatility));
        RandomVariableInterface newDiscountRate = this.getRandomVariableForValue(dataModified.getOrDefault("discountRate", this.discountRate));
        RandomVariableInterface newTheta = this.getRandomVariableForValue(dataModified.getOrDefault("theta", this.theta));
        RandomVariableInterface newKappa = this.getRandomVariableForValue(dataModified.getOrDefault("kappa", this.kappa));
        RandomVariableInterface newXi = this.getRandomVariableForValue(dataModified.getOrDefault("xi", this.xi));
        RandomVariableInterface newRho = this.getRandomVariableForValue(dataModified.getOrDefault("rho", this.rho));
        return new HestonModel(newInitialValue, newRiskFreeRate, newVolatility, newDiscountRate, newTheta, newKappa, newXi, newRho, this.scheme, this.randomVariableFactory);
    }

    private RandomVariableInterface getRandomVariableForValue(Object value) {
        if (value instanceof RandomVariableInterface) {
            return (RandomVariableInterface)value;
        }
        return this.getRandomVariableForConstant(((Number)value).doubleValue());
    }

    public String toString() {
        return "HestonModel [initialValue=" + this.initialValue + ", riskFreeRate=" + this.riskFreeRate + ", volatility=" + this.volatility + ", theta=" + this.theta + ", kappa=" + this.kappa + ", xi=" + this.xi + ", rho=" + this.rho + ", scheme=" + (Object)((Object)this.scheme) + "]";
    }

    public RandomVariableInterface getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariableInterface getVolatility() {
        return this.volatility;
    }

    public static enum Scheme {
        REFLECTION,
        FULL_TRUNCATION;

    }
}

