/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;

public class BachelierModel
extends AbstractModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];

    public BachelierModel(double initialValue, double riskFreeRate, double volatility) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialValueVector[0] == null) {
            this.initialValueVector[0] = this.getRandomVariableForConstant(this.initialValue);
        }
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        double dt = this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        RandomVariableInterface[] drift = new RandomVariableInterface[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = realizationAtTimeIndex[componentIndex].mult((Math.exp(this.riskFreeRate * dt) - 1.0) / dt);
        }
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        double t = this.getProcess().getTime(timeIndex);
        double dt = this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        RandomVariableInterface volatilityOnPaths = this.getRandomVariableForConstant(this.volatility * Math.exp(this.riskFreeRate * (t + dt)));
        return new RandomVariableInterface[]{volatilityOnPaths};
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public BachelierModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.getRiskFreeRate();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.getVolatility();
        return new BachelierModel(newInitialValue, newRiskFreeRate, newVolatility);
    }

    public String toString() {
        return super.toString() + "\nBachelierModel:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getImpliedBachelierVolatility(double maturity) {
        return this.volatility * Math.exp(this.riskFreeRate * maturity);
    }
}

