/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import org.apache.commons.math3.util.FastMath;

public class RandomVariableLowMemory
implements RandomVariableInterface {
    private static final long serialVersionUID = 7620120320663270600L;
    private final double time;
    private final float[] realizations;
    private final double valueIfNonStochastic;

    public RandomVariableLowMemory(RandomVariableInterface value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : this.getFloatArray(value.getRealizations());
        this.valueIfNonStochastic = value.isDeterministic() ? value.get(0) : Double.NaN;
    }

    public RandomVariableLowMemory(double value) {
        this(-1.7976931348623157E308, value);
    }

    public RandomVariableLowMemory(double time, double value) {
        this.time = time;
        this.realizations = null;
        this.valueIfNonStochastic = value;
    }

    public RandomVariableLowMemory(double time, int numberOfPath, double value) {
        this.time = time;
        this.realizations = new float[numberOfPath];
        Arrays.fill(this.realizations, (float)value);
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariableLowMemory(double time, float[] realisations) {
        this.time = time;
        this.realizations = realisations;
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariableLowMemory(double time, double[] realisations) {
        this.time = time;
        this.realizations = this.getFloatArray(realisations);
        this.valueIfNonStochastic = Double.NaN;
    }

    private float[] getFloatArray(double[] arrayOfDouble) {
        float[] arrayOfFloat = new float[arrayOfDouble.length];
        for (int i = 0; i < arrayOfDouble.length; ++i) {
            arrayOfFloat[i] = (float)arrayOfDouble[i];
        }
        return arrayOfFloat;
    }

    private double[] getDoubleArray(float[] arrayOfFloat) {
        double[] arrayOfDouble = new double[arrayOfFloat.length];
        for (int i = 0; i < arrayOfFloat.length; ++i) {
            arrayOfDouble[i] = arrayOfFloat[i];
        }
        return arrayOfDouble;
    }

    public RandomVariableLowMemory getMutableCopy() {
        return this;
    }

    @Override
    public boolean equals(RandomVariableInterface randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.get(0);
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            if ((double)this.realizations[i] == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.realizations[pathOrState];
    }

    @Override
    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return this.realizations.length;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double min = Double.MAX_VALUE;
        if (this.realizations.length != 0) {
            min = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            min = Math.min((double)this.realizations[i], min);
        }
        return min;
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double max = -1.7976931348623157E308;
        if (this.realizations.length != 0) {
            max = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            max = Math.max((double)this.realizations[i], max);
        }
        return max;
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getAverage(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] * probabilities.get(i) - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sumOfSquared = 0.0;
        double errorOfSum = 0.0;
        double errorOfSumSquared = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
            double valueSquared = (double)(this.realizations[i] * this.realizations[i]) - errorOfSumSquared;
            double newSumOfSquared = sumOfSquared + valueSquared;
            errorOfSumSquared = newSumOfSquared - sumOfSquared - valueSquared;
            sumOfSquared = newSumOfSquared;
        }
        return sumOfSquared / (double)this.realizations.length - sum / (double)this.realizations.length * sum / (double)this.realizations.length;
    }

    @Override
    public double getVariance(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sumOfSquared = 0.0;
        double errorOfSum = 0.0;
        double errorOfSumSquared = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] * probabilities.get(i) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
            double valueSquared = (double)(this.realizations[i] * this.realizations[i]) * probabilities.get(i) - errorOfSumSquared;
            double newSumOfSquared = sumOfSquared + valueSquared;
            errorOfSumSquared = newSumOfSquared - sumOfSquared - valueSquared;
            sumOfSquared = newSumOfSquared;
        }
        return (sumOfSquared - sum * sum) / (double)this.realizations.length;
    }

    @Override
    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    @Override
    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        float[] realizationsSorted = (float[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - quantile) - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    @Override
    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        float[] realizationsSorted = (float[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += (double)realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            float[] realizationsSorted = (float[])this.realizations.clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && (double)realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariableInterface expand(int numberOfPaths) {
        if (this.isDeterministic()) {
            double[] clone = new double[numberOfPaths];
            Arrays.fill(clone, this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, clone);
        }
        return new RandomVariableLowMemory(this.time, (float[])this.realizations.clone());
    }

    @Override
    public RandomVariableInterface cache() {
        return this;
    }

    @Override
    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(() -> this.valueIfNonStochastic);
        }
        return Arrays.stream(this.getDoubleArray(this.realizations));
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        return this.getDoubleArray(this.realizations);
    }

    @Override
    public IntToDoubleFunction getOperator() {
        if (this.isDeterministic()) {
            return i -> this.valueIfNonStochastic;
        }
        return i -> this.realizations[i];
    }

    @Override
    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariable(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        double[] result = new double[this.realizations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = operator.applyAsDouble(this.realizations[i]);
        }
        return new RandomVariable(this.time, result);
    }

    @Override
    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        int newSize = Math.max(this.size(), argument.size());
        IntToDoubleFunction argument0Operator = this.getOperator();
        IntToDoubleFunction argument1Operator = argument.getOperator();
        IntToDoubleFunction result = i -> operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i));
        return new RandomVariable(newTime, result, newSize);
    }

    @Override
    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        IntToDoubleFunction argument0Operator = this.getOperator();
        IntToDoubleFunction argument1Operator = argument1.getOperator();
        IntToDoubleFunction argument2Operator = argument2.getOperator();
        IntToDoubleFunction result = i -> operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i), argument2Operator.applyAsDouble(i));
        return new RandomVariable(newTime, result, newSize);
    }

    @Override
    public RandomVariableInterface cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.min((double)this.realizations[i], cap);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.max((double)this.realizations[i], floor);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] + value;
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] - value;
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)((double)this.realizations[i] * value);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] / value;
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.pow(this.realizations[i], exponent);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface average() {
        return new RandomVariableLowMemory(this.getAverage());
    }

    @Override
    public RandomVariableInterface squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * this.realizations[i];
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.sqrt(this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableLowMemory exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.exp((double)this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.exp((double)this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableLowMemory log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.log((double)this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.log((double)this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface sin() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.sin((double)this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.sin((double)this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface cos() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.cos((double)this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.cos((double)this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.add(this);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] + randomVariable.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic - randomVariable.get(i);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] - randomVariable.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)(this.valueIfNonStochastic * randomVariable.get(i));
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)((double)this.realizations[i] * randomVariable.get(i));
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic / randomVariable.get(i);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] / randomVariable.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface cap(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.min((double)this.valueIfNonStochastic, (double)randomVariable.get(0));
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.cap(this);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.min((double)this.realizations[i], (double)randomVariable.get(i));
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface floor(RandomVariableInterface randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.max((double)this.valueIfNonStochastic, (double)randomVariable.get(0));
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.floor(this);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.max((double)this.realizations[i], (double)randomVariable.get(i));
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (this.isDeterministic() && rate.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * (1.0 + rate.get(0) * periodLength);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            double[] rateRealizations = rate.getRealizations();
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic * (1.0 + rateRealizations[i] * periodLength);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        if (!this.isDeterministic() && rate.isDeterministic()) {
            double rateValue = rate.get(0);
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (double)this.realizations[i] * (1.0 + rateValue * periodLength);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] rateRealizations = rate.getRealizations();
        double[] newRealizations = new double[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] * (1.0 + rateRealizations[i] * periodLength);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (this.isDeterministic() && rate.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / (1.0 + rate.get(0) * periodLength);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            double[] rateRealizations = rate.getRealizations();
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic / (1.0 + rateRealizations[i] * periodLength);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        if (!this.isDeterministic() && rate.isDeterministic()) {
            double rateValue = rate.get(0);
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (double)this.realizations[i] / (1.0 + rateValue * periodLength);
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] rateRealizations = rate.getRealizations();
        double[] newRealizations = new double[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] / (1.0 + rateRealizations[i] * periodLength);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        double newTime = Math.max(this.time, trigger.getFiltrationTime());
        newTime = Math.max(newTime, valueIfTriggerNonNegative.getFiltrationTime());
        newTime = Math.max(newTime, valueIfTriggerNegative.getFiltrationTime());
        if (this.isDeterministic() && trigger.isDeterministic() && valueIfTriggerNonNegative.isDeterministic() && valueIfTriggerNegative.isDeterministic()) {
            double newValueIfNonStochastic = trigger.get(0) >= 0.0 ? valueIfTriggerNonNegative.get(0) : valueIfTriggerNegative.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        int numberOfPaths = Math.max(Math.max(trigger.size(), valueIfTriggerNonNegative.size()), valueIfTriggerNegative.size());
        double[] newRealizations = new double[numberOfPaths];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = trigger.get(i) >= 0.0 ? valueIfTriggerNonNegative.get(i) : valueIfTriggerNegative.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return this.barrier(trigger, valueIfTriggerNonNegative, new RandomVariableLowMemory(valueIfTriggerNonNegative.getFiltrationTime(), valueIfTriggerNegative));
    }

    @Override
    public RandomVariableInterface invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = 1.0 / (double)this.realizations[i];
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return new RandomVariableLowMemory(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.abs(this.realizations[i]);
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        double newTime = Math.max(this.time, factor1.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.get(0) * factor2;
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !factor1.isDeterministic()) {
            double[] factor1Realizations = factor1.getRealizations();
            double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic + factor1Realizations[i] * factor2;
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        if (!this.isDeterministic() && factor1.isDeterministic()) {
            double factor1Value = factor1.get(0);
            double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (double)this.realizations[i] + factor1Value * factor2;
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] factor1Realizations = factor1.getRealizations();
        double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (double)this.realizations[i] + factor1Realizations[i] * factor2;
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        double newTime = Math.max(Math.max(this.time, factor1.getFiltrationTime()), factor2.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic() && factor2.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.get(0) * factor2.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !factor1.isDeterministic() && !factor2.isDeterministic()) {
            double[] factor1Realizations = factor1.getRealizations();
            double[] factor2Realizations = factor2.getRealizations();
            double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic + factor1Realizations[i] * factor2Realizations[i];
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        if (!(this.isDeterministic() || factor1.isDeterministic() || factor2.isDeterministic())) {
            double[] factor1Realizations = factor1.getRealizations();
            double[] factor2Realizations = factor2.getRealizations();
            double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (double)this.realizations[i] + factor1Realizations[i] * factor2Realizations[i];
            }
            return new RandomVariableLowMemory(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(Math.max(this.size(), factor1.size()), factor2.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.get(i) + factor1.get(i) * factor2.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + numerator.get(0) / denominator.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.get(i) + numerator.get(i) / denominator.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - numerator.get(0) / denominator.get(0);
            return new RandomVariableLowMemory(newTime, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.get(i) - numerator.get(i) / denominator.get(i);
        }
        return new RandomVariableLowMemory(newTime, newRealizations);
    }

    @Override
    public RandomVariableInterface isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariableLowMemory(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        float[] newRealizations = new float[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0f : 0.0f;
        }
        return new RandomVariableLowMemory(this.time, newRealizations);
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.time + "\nrealizations: " + Arrays.toString(this.realizations);
    }
}

