/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomVariableInterface;
import org.apache.commons.math3.util.FastMath;

public class RandomVariable
implements RandomVariableInterface {
    private static final long serialVersionUID = -1352953450936857742L;
    private final double time;
    private final double[] realizations;
    private final double valueIfNonStochastic;

    public RandomVariable(RandomVariableInterface value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value.getRealizations();
        this.valueIfNonStochastic = value.isDeterministic() ? value.get(0) : Double.NaN;
    }

    public RandomVariable(double value) {
        this(-1.7976931348623157E308, value);
    }

    public RandomVariable(RandomVariableInterface value, DoubleUnaryOperator function) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value.getRealizationsStream().map(function).toArray();
        this.valueIfNonStochastic = value.isDeterministic() ? function.applyAsDouble(value.get(0)) : Double.NaN;
    }

    public RandomVariable(double time, double value) {
        this.time = time;
        this.realizations = null;
        this.valueIfNonStochastic = value;
    }

    public RandomVariable(double time, int numberOfPath, double value) {
        this.time = time;
        this.realizations = new double[numberOfPath];
        Arrays.fill(this.realizations, value);
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariable(double time, double[] realisations) {
        this.time = time;
        this.realizations = realisations;
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariable(double time, IntToDoubleFunction realizations, int size) {
        this.time = time;
        this.realizations = size == 1 ? null : new double[size];
        double d = this.valueIfNonStochastic = size == 1 ? realizations.applyAsDouble(0) : Double.NaN;
        if (size > 1) {
            IntStream.range(0, size).parallel().forEach(i -> {
                this.realizations[i] = realizations.applyAsDouble(i);
            });
        }
    }

    public RandomVariable getMutableCopy() {
        return this;
    }

    @Override
    public boolean equals(RandomVariableInterface randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.get(0);
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            if (this.realizations[i] == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.realizations[pathOrState];
    }

    @Override
    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return this.realizations.length;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().min().getAsDouble();
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().max().getAsDouble();
    }

    public double getSum() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getRealizationsStream().sum();
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getRealizationsStream().sum() / (double)this.realizations.length;
    }

    @Override
    public double getAverage(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.mult(probabilities).getRealizationsStream().sum();
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (this.realizations[i] - average) * (this.realizations[i] - average) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getVariance(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage(probabilities);
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (this.realizations[i] - average) * (this.realizations[i] - average) * probabilities.get(i) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum;
    }

    @Override
    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    @Override
    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = (double[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - quantile) - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    @Override
    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = (double[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = (double[])this.realizations.clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariableInterface expand(int numberOfPaths) {
        if (this.isDeterministic()) {
            double[] clone = new double[numberOfPaths];
            Arrays.fill(clone, this.valueIfNonStochastic);
            return new RandomVariable(this.time, clone);
        }
        return new RandomVariable(this.time, (double[])this.realizations.clone());
    }

    @Override
    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(() -> this.valueIfNonStochastic);
        }
        return Arrays.stream(this.realizations);
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        return (double[])this.realizations.clone();
    }

    @Override
    public IntToDoubleFunction getOperator() {
        if (this.isDeterministic()) {
            return i -> this.valueIfNonStochastic;
        }
        return i -> this.realizations[i];
    }

    @Override
    public RandomVariableInterface cache() {
        return this;
    }

    @Override
    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariable(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        double[] result = new double[this.realizations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = operator.applyAsDouble(this.realizations[i]);
        }
        return new RandomVariable(this.time, result);
    }

    @Override
    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        int newSize = Math.max(this.size(), argument.size());
        IntToDoubleFunction argument0Operator = this.getOperator();
        IntToDoubleFunction argument1Operator = argument.getOperator();
        IntToDoubleFunction result = i -> operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i));
        return new RandomVariable(newTime, result, newSize);
    }

    @Override
    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        IntToDoubleFunction argument0Operator = this.getOperator();
        IntToDoubleFunction argument1Operator = argument1.getOperator();
        IntToDoubleFunction argument2Operator = argument2.getOperator();
        IntToDoubleFunction result = i -> operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i), argument2Operator.applyAsDouble(i));
        return new RandomVariable(newTime, result, newSize);
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operatorOuter, DoubleBinaryOperator operatorInner, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        return this.apply((x, y, z) -> operatorOuter.applyAsDouble(x, operatorInner.applyAsDouble(y, z)), argument1, argument2);
    }

    @Override
    public RandomVariableInterface cap(double cap) {
        return this.apply(x -> Math.min(x, cap));
    }

    @Override
    public RandomVariableInterface floor(double floor) {
        return this.apply(x -> Math.max(x, floor));
    }

    @Override
    public RandomVariableInterface add(double value) {
        return this.apply(x -> x + value);
    }

    @Override
    public RandomVariableInterface sub(double value) {
        return this.apply(x -> x - value);
    }

    @Override
    public RandomVariableInterface mult(double value) {
        return this.apply(x -> x * value);
    }

    @Override
    public RandomVariableInterface div(double value) {
        return this.apply(x -> x / value);
    }

    @Override
    public RandomVariableInterface pow(double exponent) {
        return this.apply(x -> FastMath.pow((double)x, (double)exponent));
    }

    @Override
    public RandomVariableInterface average() {
        return new RandomVariable(this.getAverage());
    }

    @Override
    public RandomVariableInterface squared() {
        return this.apply(x -> x * x);
    }

    @Override
    public RandomVariableInterface sqrt() {
        return this.apply(FastMath::sqrt);
    }

    @Override
    public RandomVariableInterface exp() {
        return this.apply(FastMath::exp);
    }

    @Override
    public RandomVariableInterface log() {
        return this.apply(FastMath::log);
    }

    @Override
    public RandomVariableInterface sin() {
        return this.apply(FastMath::sin);
    }

    @Override
    public RandomVariableInterface cos() {
        return this.apply(FastMath::cos);
    }

    @Override
    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x + y, randomVariable);
    }

    @Override
    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x - y, randomVariable);
    }

    @Override
    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x * y, randomVariable);
    }

    @Override
    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x / y, randomVariable);
    }

    @Override
    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return this.apply(FastMath::min, cap);
    }

    @Override
    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return this.apply(FastMath::max, floor);
    }

    @Override
    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return this.apply((x, y) -> x * (1.0 + y * periodLength), rate);
    }

    @Override
    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return this.apply((x, y) -> x / (1.0 + y * periodLength), rate);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        return trigger.apply((x, y, z) -> x >= 0.0 ? y : z, valueIfTriggerNonNegative, valueIfTriggerNegative);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return this.barrier(trigger, valueIfTriggerNonNegative, new RandomVariable(valueIfTriggerNonNegative.getFiltrationTime(), valueIfTriggerNegative));
    }

    @Override
    public RandomVariableInterface invert() {
        return this.apply(x -> 1.0 / x);
    }

    @Override
    public RandomVariableInterface abs() {
        return this.apply(Math::abs);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return this.apply((x, y) -> x + y * factor2, factor1);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return this.apply((x, y) -> x + y, (x, y) -> x * y, factor1, factor2);
    }

    @Override
    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply((x, y) -> x + y, (x, y) -> x / y, numerator, denominator);
    }

    @Override
    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply((x, y) -> x - y, (x, y) -> x / y, numerator, denominator);
    }

    @Override
    public RandomVariableInterface isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariable(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        double[] newRealizations = new double[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0 : 0.0;
        }
        return new RandomVariable(this.time, newRealizations);
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.time + "\nrealizations: " + (this.isDeterministic() ? Double.valueOf(this.valueIfNonStochastic) : Arrays.toString(this.realizations));
    }
}

