/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.modelling.ModelInterface;
import net.finmath.modelling.ProductInterface;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public abstract class AbstractMonteCarloProduct
implements ProductInterface {
    private final String currency;

    public AbstractMonteCarloProduct(String currency) {
        this.currency = currency;
    }

    public AbstractMonteCarloProduct() {
        this(null);
    }

    @Override
    public Object getValue(double evaluationTime, ModelInterface model) {
        throw new IllegalArgumentException("The product " + this.getClass() + " cannot be valued against a model " + model.getClass() + ".It requires a model of type " + AnalyticModelInterface.class + ".");
    }

    public abstract RandomVariableInterface getValue(double var1, MonteCarloSimulationInterface var3) throws CalculationException;

    public double getValue(MonteCarloSimulationInterface model) throws CalculationException {
        return this.getValue(0.0, model).getAverage();
    }

    public Map<String, Object> getValues(double evaluationTime, MonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values = this.getValue(evaluationTime, model);
        if (values == null) {
            return null;
        }
        double value = values.getAverage();
        double error = values.getStandardError();
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("value", value);
        results.put("error", error);
        return results;
    }

    public Map<String, Object> getValuesForModifiedData(double evaluationTime, MonteCarloSimulationInterface model, Map<String, Object> dataModified) throws CalculationException {
        MonteCarloSimulationInterface modelModified = model.getCloneWithModifiedData(dataModified);
        return this.getValues(evaluationTime, modelModified);
    }

    public Map<String, Object> getValuesForModifiedData(double evaluationTime, MonteCarloSimulationInterface model, String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getValuesForModifiedData(evaluationTime, model, dataModifiedMap);
    }

    public Map<String, Object> getValues(MonteCarloSimulationInterface model) throws CalculationException {
        return this.getValues(0.0, model);
    }

    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationInterface model, Map<String, Object> dataModified) throws CalculationException {
        return this.getValuesForModifiedData(0.0, model, dataModified);
    }

    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationInterface model, String entityKey, Object dataModified) throws CalculationException {
        return this.getValuesForModifiedData(0.0, model, entityKey, dataModified);
    }

    public String getCurrency() {
        return this.currency;
    }

    public String toString() {
        return "AbstractMonteCarloProduct [currency=" + this.currency + "]";
    }
}

