/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.time.ScheduleInterface;

public class SwapLeg
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final ScheduleInterface legSchedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private boolean isNotionalExchanged = false;

    public SwapLeg(ScheduleInterface legSchedule, String forwardCurveName, double spread, String discountCurveName, boolean isNotionalExchanged) {
        this.legSchedule = legSchedule;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
        this.isNotionalExchanged = isNotionalExchanged;
    }

    public SwapLeg(ScheduleInterface legSchedule, String forwardCurveName, double spread, String discountCurveName) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, false);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = this.legSchedule.getFixing(periodIndex);
            double paymentDate = this.legSchedule.getPayment(periodIndex);
            double periodLength = this.legSchedule.getPeriodLength(periodIndex);
            double forward = this.spread;
            if (forwardCurve != null) {
                forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
            }
            double discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            value += forward * periodLength * discountFactor;
            if (!this.isNotionalExchanged) continue;
            double periodEnd = this.legSchedule.getPeriodEnd(periodIndex);
            value += periodEnd > evaluationTime ? discountCurve.getDiscountFactor(model, periodEnd) : 0.0;
            double periodStart = this.legSchedule.getPeriodStart(periodIndex);
            value -= periodStart > evaluationTime ? discountCurve.getDiscountFactor(model, periodStart) : 0.0;
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public ScheduleInterface getSchedule() {
        return this.legSchedule;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getSpread() {
        return this.spread;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    public String toString() {
        return "SwapLeg [legSchedule=" + this.legSchedule + ", forwardCurveName=" + this.forwardCurveName + ", spread=" + this.spread + ", discountCurveName=" + this.discountCurveName + ", isNotionalExchanged=" + this.isNotionalExchanged + "]";
    }
}

