/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;

public class CapletVolatilitiesParametric
extends AbstractVolatilitySurfaceParametric {
    private final double timeScaling;
    private final double a;
    private final double b;
    private final double c;
    private final double d;

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve, double a, double b, double c, double d, double timeScaling, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        super(name, referenceDate);
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.timeScaling = timeScaling;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.quotingConvention = quotingConvention;
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve, double a, double b, double c, double d, double timeScaling) {
        super(name, referenceDate);
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.timeScaling = timeScaling;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.quotingConvention = VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL;
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, double a, double b, double c, double d, double timeScaling) {
        this(name, referenceDate, null, null, a, b, c, d, timeScaling);
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, double a, double b, double c, double d) {
        this(name, referenceDate, a, b, c, d, 1.0);
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double maturity, double strike, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        if (maturity <= 0.0) {
            return 0.0;
        }
        double T = maturity * this.timeScaling;
        double integratedVariance = this.c != 0.0 ? this.a * this.a * T * ((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T)) + this.a * this.b * T * T * (((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T) - Math.exp(-2.0 * this.c * T)) / (this.c * T)) + 2.0 * this.a * this.d * T * ((1.0 - Math.exp(-this.c * T)) / (this.c * T)) + this.b * this.b * T * T * T * ((((1.0 - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T) - Math.exp(-2.0 * this.c * T)) / (T * this.c) - Math.exp(-2.0 * this.c * T)) / (2.0 * this.c * T)) + 2.0 * this.b * this.d * T * T * ((1.0 - Math.exp(-this.c * T) - T * this.c * Math.exp(-this.c * T)) / (this.c * this.c * T * T)) + this.d * this.d * T : this.a * this.a * T + this.a * this.b * T * T + 2.0 * this.a * this.d * T + this.b * this.b * T * T * T / 3.0 + this.b * this.d * T * T + this.d * this.d * T;
        double value = Math.sqrt(integratedVariance / maturity);
        return this.convertFromTo(model, maturity, strike, value, this.quotingConvention, quotingConvention);
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    public AbstractVolatilitySurfaceParametric getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new CapletVolatilitiesParametric(this.getName(), this.getReferenceDate(), this.forwardCurve, this.discountCurve, value[0], value[1], value[2], value[3], this.timeScaling, this.quotingConvention);
    }
}

