/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.time.daycount.DayCountConventionInterface;

public abstract class AbstractVolatilitySurface
implements VolatilitySurfaceInterface,
Cloneable {
    private final LocalDate referenceDate;
    private final String name;
    protected ForwardCurveInterface forwardCurve;
    protected DiscountCurveInterface discountCurve;
    protected VolatilitySurfaceInterface.QuotingConvention quotingConvention;
    protected DayCountConventionInterface daycountConvention;

    public AbstractVolatilitySurface(String name, LocalDate referenceDate) {
        this.name = name;
        this.referenceDate = referenceDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String toString() {
        return super.toString() + "\n\"" + this.getName() + "\"";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public VolatilitySurfaceInterface.QuotingConvention getQuotingConvention() {
        return this.quotingConvention;
    }

    public double convertFromTo(AnalyticModelInterface model, double optionMaturity, double optionStrike, double value, VolatilitySurfaceInterface.QuotingConvention fromQuotingConvention, VolatilitySurfaceInterface.QuotingConvention toQuotingConvention) {
        double daycountFraction;
        if (fromQuotingConvention.equals((Object)toQuotingConvention)) {
            return value;
        }
        if (this.discountCurve == null) {
            throw new IllegalArgumentException("Missing discount curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        if (this.forwardCurve == null) {
            throw new IllegalArgumentException("Missing forward curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        double periodStart = optionMaturity;
        double periodEnd = periodStart + this.forwardCurve.getPaymentOffset(periodStart);
        double forward = this.forwardCurve.getForward(model, periodStart);
        if (this.daycountConvention != null) {
            LocalDate startDate = this.referenceDate.plusDays((int)Math.round(periodStart * 365.0));
            LocalDate endDate = this.referenceDate.plusDays((int)Math.round(periodEnd * 365.0));
            daycountFraction = this.daycountConvention.getDaycountFraction(startDate, endDate);
        } else {
            daycountFraction = this.forwardCurve.getPaymentOffset(periodStart);
        }
        double payoffUnit = this.discountCurve.getDiscountFactor(optionMaturity + this.forwardCurve.getPaymentOffset(optionMaturity)) * daycountFraction;
        if (toQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL)) {
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL)) {
            return AnalyticFormulas.bachelierOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        return this.convertFromTo(model, optionMaturity, optionStrike, this.convertFromTo(model, optionMaturity, optionStrike, value, fromQuotingConvention, VolatilitySurfaceInterface.QuotingConvention.PRICE), VolatilitySurfaceInterface.QuotingConvention.PRICE, toQuotingConvention);
    }

    public double convertFromTo(double optionMaturity, double optionStrike, double value, VolatilitySurfaceInterface.QuotingConvention fromQuotingConvention, VolatilitySurfaceInterface.QuotingConvention toQuotingConvention) {
        return this.convertFromTo(null, optionMaturity, optionStrike, value, fromQuotingConvention, toQuotingConvention);
    }
}

