/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class PiecewiseCurve
extends AbstractCurve
implements CurveInterface {
    private CurveInterface baseCurve;
    private CurveInterface fixedPartCurve;
    private double fixedPartStartTime;
    private double fixedPartEndTime;

    public PiecewiseCurve(CurveInterface curveInterface, CurveInterface fixedPartCurve, double fixedPartStartTime, double fixedPartEndTime) {
        super(curveInterface.getName(), curveInterface.getReferenceDate());
        this.baseCurve = curveInterface;
        this.fixedPartCurve = fixedPartCurve;
        this.fixedPartStartTime = fixedPartStartTime;
        this.fixedPartEndTime = fixedPartEndTime;
    }

    @Override
    public double[] getParameter() {
        return this.baseCurve.getParameter();
    }

    @Override
    public void setParameter(double[] parameter) {
        this.baseCurve.setParameter(parameter);
    }

    @Override
    public String getName() {
        return this.baseCurve.getName();
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.baseCurve.getReferenceDate();
    }

    public CurveInterface getBaseCurve() {
        return this.baseCurve;
    }

    public CurveInterface getFixedPartCurve() {
        return this.fixedPartCurve;
    }

    public double getFixedPartStartTime() {
        return this.fixedPartStartTime;
    }

    public double getFixedPartEndTime() {
        return this.fixedPartEndTime;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        if (time > this.fixedPartStartTime && time < this.fixedPartEndTime) {
            return this.fixedPartCurve.getValue(model, time);
        }
        return this.baseCurve.getValue(model, time);
    }

    @Override
    public CurveInterface getCloneForParameter(double[] value) throws CloneNotSupportedException {
        PiecewiseCurve newCurve = this.clone();
        newCurve.baseCurve = this.baseCurve.getCloneForParameter(value);
        return newCurve;
    }

    @Override
    public PiecewiseCurve clone() throws CloneNotSupportedException {
        return new PiecewiseCurve((CurveInterface)this.baseCurve.clone(), this.fixedPartCurve, this.fixedPartStartTime, this.fixedPartEndTime);
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return new CurveBuilder(this);
    }

    @Override
    public String toString() {
        return "ForwardCurveWithFixings [getBaseCurve()=" + this.getBaseCurve() + ", getFixedPartCurve()=" + this.getFixedPartCurve() + ", getFixedPartStartTime()=" + this.getFixedPartStartTime() + ", getFixedPartEndTime()=" + this.getFixedPartEndTime() + ", toString()=" + super.toString() + "]";
    }

    public static class CurveBuilder
    extends Curve.CurveBuilder
    implements CurveBuilderInterface {
        private PiecewiseCurve curve = null;

        public CurveBuilder(PiecewiseCurve piecewiseCurve) throws CloneNotSupportedException {
            super((Curve)piecewiseCurve.baseCurve);
            this.curve = piecewiseCurve;
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            PiecewiseCurve buildCurve = this.curve.clone();
            buildCurve.baseCurve = super.build();
            this.curve = null;
            return buildCurve;
        }
    }
}

