/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.curves.PiecewiseCurve;

public class ForwardCurveWithFixings
extends PiecewiseCurve
implements ForwardCurveInterface {
    public ForwardCurveWithFixings(ForwardCurveInterface curveInterface, ForwardCurveInterface fixedPartCurve, double fixedPartStartTime, double fixedPartEndTime) {
        super(curveInterface, fixedPartCurve, fixedPartStartTime, fixedPartEndTime);
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime) {
        if (fixingTime > this.getFixedPartStartTime() && fixingTime < this.getFixedPartEndTime()) {
            return ((ForwardCurveInterface)this.getFixedPartCurve()).getForward(model, fixingTime);
        }
        return ((ForwardCurveInterface)this.getBaseCurve()).getForward(model, fixingTime);
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime, double paymentOffset) {
        if (fixingTime > this.getFixedPartStartTime() && fixingTime < this.getFixedPartEndTime()) {
            return ((ForwardCurveInterface)this.getFixedPartCurve()).getForward(model, fixingTime, paymentOffset);
        }
        return ((ForwardCurveInterface)this.getBaseCurve()).getForward(model, fixingTime, paymentOffset);
    }

    public double[] getForwards(AnalyticModelInterface model, double[] fixingTimes) {
        double[] values = new double[fixingTimes.length];
        for (int i = 0; i < fixingTimes.length; ++i) {
            values[i] = this.getForward(model, fixingTimes[i]);
        }
        return values;
    }

    @Override
    public String getDiscountCurveName() {
        return ((ForwardCurveInterface)this.getBaseCurve()).getDiscountCurveName();
    }

    @Override
    public double getPaymentOffset(double fixingTime) {
        return ((ForwardCurveInterface)this.getBaseCurve()).getPaymentOffset(fixingTime);
    }

    @Override
    public CurveInterface getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new ForwardCurveWithFixings((ForwardCurveInterface)this.getBaseCurve().getCloneForParameter(value), (ForwardCurveInterface)this.getFixedPartCurve(), this.getFixedPartStartTime(), this.getFixedPartEndTime());
    }

    @Override
    public ForwardCurveWithFixings clone() throws CloneNotSupportedException {
        return new ForwardCurveWithFixings((ForwardCurveInterface)this.getBaseCurve().clone(), (ForwardCurveInterface)this.getFixedPartCurve(), this.getFixedPartStartTime(), this.getFixedPartEndTime());
    }
}

